/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import java.math.BigInteger;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.uom.se.AbstractConverter;
import tec.uom.se.format.SymbolMap;
import tec.uom.se.function.MultiplyConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.unit.MetricPrefix;

class UCUMConverterFormatter {
    protected static final double epsilon = Math.ulp(1.0f) * 2.0f;

    UCUMConverterFormatter() {
    }

    static void formatConverter(Unit<?> unit, Unit<?> unitParent, boolean continued, StringBuilder buffer, SymbolMap symbolMap) {
        MetricPrefix prefix;
        int scalePower;
        double scale;
        int log10;
        int pow;
        boolean unitIsExpression = buffer.indexOf(".") >= 0 || buffer.indexOf("/") >= 0;
        UnitConverter converter = unit.getConverterTo(unitParent);
        String mapSymbol = symbolMap.getSymbol(unitParent);
        Map map = unit.getBaseUnits();
        if (map != null && map.size() == 1 && mapSymbol == null && (pow = ((Integer)map.values().iterator().next()).intValue()) != 1 && pow != 0 && Math.abs(Math.pow(10.0, log10 = (int)Math.round(Math.log10(scale = converter.convert(1.0)))) - scale) < epsilon && Math.abs((double)(scalePower = log10 / pow) - (double)log10 / (double)pow) < epsilon) {
            if (scalePower > 0) {
                converter = new RationalConverter(BigInteger.TEN.pow(scalePower), BigInteger.ONE);
            } else if (scalePower < 0) {
                converter = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(-scalePower));
            }
        }
        if ((prefix = symbolMap.getPrefix(converter)) != null && !unitIsExpression) {
            buffer.insert(0, symbolMap.getSymbol(prefix));
        } else if (converter != AbstractConverter.IDENTITY) {
            if (converter instanceof MultiplyConverter) {
                MultiplyConverter multiplyConverter;
                double factor;
                long lFactor;
                if (unitIsExpression) {
                    buffer.insert(0, '(');
                    buffer.append(')');
                }
                if ((lFactor = (long)(factor = (multiplyConverter = (MultiplyConverter)converter).getFactor())) < Long.MIN_VALUE || lFactor > Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Only integer factors are supported in UCUM");
                }
                if (continued) {
                    buffer.append('.');
                }
                buffer.append(lFactor);
            } else if (converter instanceof RationalConverter) {
                RationalConverter rationalConverter;
                if (unitIsExpression) {
                    buffer.insert(0, '(');
                    buffer.append(')');
                }
                if (!(rationalConverter = (RationalConverter)converter).getDividend().equals(BigInteger.ONE)) {
                    if (continued) {
                        buffer.append('.');
                    }
                    buffer.append(rationalConverter.getDividend());
                }
                if (!rationalConverter.getDivisor().equals(BigInteger.ONE)) {
                    buffer.append('/');
                    buffer.append(rationalConverter.getDivisor());
                }
            } else {
                buffer.insert(0, converter.toString() + "(");
                buffer.append(")");
            }
        }
    }
}

