/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.function;

import java.util.Objects;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.spi.NumberSystem;

public final class Calculator {
    private final NumberSystem ns;
    private Number acc = 0;

    private static Calculator getInstance() {
        return new Calculator(Calculus.currentNumberSystem());
    }

    public static Calculator of(Number number) {
        return Calculator.getInstance().load(number);
    }

    private Calculator(NumberSystem ns) {
        this.ns = ns;
    }

    private Calculator() {
        this(Calculus.currentNumberSystem());
    }

    private Calculator load(Number number) {
        Objects.requireNonNull(number);
        this.acc = this.ns.narrow(number);
        return this;
    }

    public Calculator add(Number number) {
        Objects.requireNonNull(number);
        this.acc = this.ns.add(this.acc, this.ns.narrow(number));
        return this;
    }

    public Calculator subtract(Number number) {
        Objects.requireNonNull(number);
        this.acc = this.ns.subtract(this.acc, this.ns.narrow(number));
        return this;
    }

    public Calculator multiply(Number number) {
        this.acc = this.ns.multiply(this.acc, this.ns.narrow(number));
        return this;
    }

    public Calculator divide(Number number) {
        this.acc = this.ns.divide(this.acc, this.ns.narrow(number));
        return this;
    }

    public Calculator power(int exponent) {
        this.acc = this.ns.power(this.acc, exponent);
        return this;
    }

    public Calculator abs() {
        this.acc = this.ns.abs(this.acc);
        return this;
    }

    public Calculator negate() {
        this.acc = this.ns.negate(this.acc);
        return this;
    }

    public Calculator reciprocal() {
        this.acc = this.ns.reciprocal(this.acc);
        return this;
    }

    public Calculator exp() {
        this.acc = this.ns.exp(this.acc);
        return this;
    }

    public Calculator log() {
        this.acc = this.ns.log(this.acc);
        return this;
    }

    public Number peek() {
        return this.ns.narrow(this.acc);
    }

    public boolean isLessThanOne() {
        return this.ns.isLessThanOne(this.acc);
    }
}

