/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api;

import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;

/**
 * FloatIterable is an interface which is memory-optimized for float primitives.
 * It is inspired by the interface RichIterable, and contains a subset of the internal iterator methods on RichIterable like collect, sum, etc.
 * The API also includes an external iterator method, which returns an FloatIterator. FloatIterator helps iterate over the FloatIterable without boxing the primitives.
 * This file was automatically generated from template file primitiveIterable.stg.
 */
public interface FloatIterable extends PrimitiveIterable
{
    FloatIterator floatIterator();

    float[] toArray();

    boolean contains(float value);

    boolean containsAll(float... source);

    boolean containsAll(FloatIterable source);

    void forEach(FloatProcedure procedure);

    /**
     * @since 7.0.
     */
    void each(FloatProcedure procedure);

    FloatIterable select(FloatPredicate predicate);

    FloatIterable reject(FloatPredicate predicate);

    <V> RichIterable<V> collect(FloatToObjectFunction<? extends V> function);

    float detectIfNone(FloatPredicate predicate, float ifNone);

    int count(FloatPredicate predicate);

    boolean anySatisfy(FloatPredicate predicate);

    boolean allSatisfy(FloatPredicate predicate);

    boolean noneSatisfy(FloatPredicate predicate);

    MutableFloatList toList();

    MutableFloatSet toSet();

    MutableFloatBag toBag();

    LazyFloatIterable asLazy();

    <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function);


    double sum();

    float max();

    float maxIfEmpty(float defaultValue);

    float min();

    float minIfEmpty(float defaultValue);

    double average();

    double median();

    float[] toSortedArray();

    MutableFloatList toSortedList();
}
