/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ByteShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableShortCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.primitive.ByteShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteShortMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ByteShortPair;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteShortMaps;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.ByteShortHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

/**
 * ImmutableByteShortSingletonMap is an optimization for {@link ImmutableByteShortMap} of size 1.
 * This file was automatically generated from template file immutablePrimitivePrimitiveSingletonMap.stg.
 * @since 4.0.
 */
final class ImmutableByteShortSingletonMap implements ImmutableByteShortMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_VALUE = (short) 0;
    private final byte key1;
    private final short value1;

    ImmutableByteShortSingletonMap(byte key1, short value1)
    {
        this.key1 = key1;
        this.value1 = value1;
    }

    public short get(byte key)
    {
        return this.getIfAbsent(key, EMPTY_VALUE);
    }

    public short getIfAbsent(byte key, short ifAbsent)
    {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public short getOrThrow(byte key)
    {
        if (this.key1 == key)
        {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(byte key)
    {
        return this.key1 == key;
    }

    public boolean containsValue(short value)
    {
        return this.value1 == value;
    }

    public void forEachValue(ShortProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public void forEachKey(ByteProcedure procedure)
    {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ByteShortProcedure procedure)
    {
        procedure.value(this.key1, this.value1);
    }

    public LazyByteIterable keysView()
    {
        return ByteLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ByteShortPair> keyValuesView()
    {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableByteShortMap select(ByteShortPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? ByteShortHashMap.newWithKeysValues(this.key1, this.value1).toImmutable()
                : new ByteShortHashMap().toImmutable();
    }

    public ImmutableByteShortMap reject(ByteShortPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? new ByteShortHashMap().toImmutable()
                : ByteShortHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.value1);
    }

    public ImmutableByteShortMap toImmutable()
    {
        return this;
    }

    public ShortIterator shortIterator()
    {
        return new UnmodifiableShortIterator(ByteShortHashMap.newWithKeysValues(this.key1, this.value1).shortIterator());
    }

    public void forEach(ShortProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(ShortProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public int count(ShortPredicate predicate)
    {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum()
    {
        return this.value1;
    }

    public short min()
    {
        return this.value1;
    }

    public short max()
    {
        return this.value1;
    }

    public short maxIfEmpty(short defaultValue)
    {
        return this.value1;
    }

    public short minIfEmpty(short defaultValue)
    {
        return this.value1;
    }

    public double average()
    {
        return this.value1;
    }

    public double median()
    {
        return this.value1;
    }

    public short[] toSortedArray()
    {
        return new short[]{this.value1};
    }

    public MutableShortList toSortedList()
    {
        return ShortArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return !predicate.accept(this.value1);
    }

    public ImmutableShortCollection select(ShortPredicate predicate)
    {
        return predicate.accept(this.value1) ? ShortArrayList.newListWith(this.value1).toImmutable() : new ShortArrayList().toImmutable();
    }

    public ImmutableShortCollection reject(ShortPredicate predicate)
    {
        return predicate.accept(this.value1) ? new ShortArrayList().toImmutable() : ShortArrayList.newListWith(this.value1).toImmutable();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public short[] toArray()
    {
        return new short[]{this.value1};
    }

    public boolean contains(short value)
    {
        return this.value1 == value;
    }

    public boolean containsAll(short... source)
    {
        for (short value : source)
        {
            if (this.value1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(ShortIterable source)
    {
        for (ShortIterator iterator = source.shortIterator(); iterator.hasNext(); )
        {
            if (this.value1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public MutableShortList toList()
    {
        return ShortArrayList.newListWith(this.value1);
    }

    public MutableShortSet toSet()
    {
        return ShortHashSet.newSetWith(this.value1);
    }

    public MutableShortBag toBag()
    {
        return ShortHashBag.newBagWith(this.value1);
    }

    public LazyShortIterable asLazy()
    {
        return new LazyShortIterableAdapter(this);
    }

    public ImmutableByteShortMap newWithKeyValue(byte key, short value)
    {
        return ByteShortMaps.immutable.withAll(ByteShortHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableByteShortMap newWithoutKey(byte key)
    {
        return this.key1 == key ? ByteShortMaps.immutable.with() : this;
    }

    public ImmutableByteShortMap newWithoutAllKeys(ByteIterable keys)
    {
        return keys.contains(this.key1) ? ByteShortMaps.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public MutableByteSet keySet()
    {
        return UnmodifiableByteSet.of(ByteHashSet.newSetWith(this.key1));
    }

    public MutableShortCollection values()
    {
        return UnmodifiableShortCollection.of(ShortArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ByteShortMap))
        {
            return false;
        }
        ByteShortMap map = (ByteShortMap) obj;
        if (map.size() != 1)
        {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode()
    {
        return (int) this.key1 ^ (int) this.value1;
    }

    @Override
    public String toString()
    {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
