/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableFloatStack;
import org.eclipse.collections.api.stack.primitive.FloatStack;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.FloatStacks;
import org.eclipse.collections.impl.iterator.ImmutableEmptyFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableFloatEmptyStack is an optimization for {@link ImmutableFloatStack} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptyStack.stg.
 */
@Immutable
final class ImmutableFloatEmptyStack implements ImmutableFloatStack, Serializable
{
    static final ImmutableFloatStack INSTANCE = new ImmutableFloatEmptyStack();
    private static final long serialVersionUID = 1L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public FloatIterator floatIterator()
    {
        return ImmutableEmptyFloatIterator.INSTANCE;
    }

    public void forEach(FloatProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(FloatProcedure procedure)
    {
    }

    public int count(FloatPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return true;
    }

    public float peek()
    {
        throw new EmptyStackException();
    }

    public FloatList peek(int count)
    {
        this.checkNegativeCount(count);
        if (count == 0)
        {
            return new FloatArrayList(0);
        }
        throw new EmptyStackException();
    }

    public float peekAt(int index)
    {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    public ImmutableFloatStack select(FloatPredicate predicate)
    {
        return this;
    }

    public ImmutableFloatStack reject(FloatPredicate predicate)
    {
        return this;
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableStack<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return Stacks.immutable.of();
    }

    public double sum()
    {
        return 0;
    }

    public float max()
    {
        throw new NoSuchElementException();
    }

    public float maxIfEmpty(float defaultValue)
    {
        return defaultValue;
    }

    public float min()
    {
        throw new NoSuchElementException();
    }

    public float minIfEmpty(float defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public float[] toSortedArray()
    {
        return new float[0];
    }

    public MutableFloatList toSortedList()
    {
        return new FloatArrayList();
    }

    public float[] toArray()
    {
        return new float[0];
    }

    public boolean contains(float value)
    {
        return false;
    }

    public boolean containsAll(float... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(FloatIterable source)
    {
        return source.isEmpty();
    }

    public MutableFloatList toList()
    {
        return new FloatArrayList();
    }

    public MutableFloatSet toSet()
    {
        return new FloatHashSet();
    }

    public MutableFloatBag toBag()
    {
        return new FloatHashBag();
    }

    public LazyFloatIterable asLazy()
    {
        return new LazyFloatIterableAdapter(this);
    }

    public ImmutableFloatStack toImmutable()
    {
        return this;
    }

    public ImmutableFloatStack push(float element)
    {
        return FloatStacks.immutable.with(element);
    }

    public ImmutableFloatStack pop()
    {
        throw new EmptyStackException();
    }

    public ImmutableFloatStack pop(int count)
    {
        this.checkNegativeCount(count);
        if (count == 0)
        {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count)
    {
        if (count < 0)
        {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherStack)
    {
        if (otherStack == this)
        {
            return true;
        }
        if (!(otherStack instanceof FloatStack))
        {
            return false;
        }
        FloatStack stack = (FloatStack) otherStack;
        return stack.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 1;
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
