/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.CharSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableCharSingletonSet;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;

final class ImmutableCharEmptySet
implements ImmutableCharSet,
Serializable {
    static final ImmutableCharSet INSTANCE = new ImmutableCharEmptySet();
    private static final long serialVersionUID = 1L;

    ImmutableCharEmptySet() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public ImmutableCharSet newWith(char element) {
        return new ImmutableCharSingletonSet(element);
    }

    @Override
    public ImmutableCharSet newWithout(char element) {
        return this;
    }

    @Override
    public ImmutableCharSet newWithAll(CharIterable elements) {
        return CharSets.immutable.withAll(elements);
    }

    @Override
    public ImmutableCharSet newWithoutAll(CharIterable elements) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public boolean contains(char value) {
        return false;
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return source.isEmpty();
    }

    @Override
    public boolean containsAll(char ... elements) {
        return elements.length == 0;
    }

    @Override
    public void forEach(CharProcedure procedure) {
    }

    @Override
    public void each(CharProcedure procedure) {
    }

    @Override
    public ImmutableCharSet select(CharPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableCharSet reject(CharPredicate predicate) {
        return this;
    }

    @Override
    public <V> ImmutableSet<V> collect(CharToObjectFunction<? extends V> function) {
        return Sets.immutable.of();
    }

    @Override
    public MutableCharList toList() {
        return new CharArrayList();
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return ifNone;
    }

    @Override
    public int count(CharPredicate predicate) {
        return 0;
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return false;
    }

    @Override
    public long sum() {
        return 0L;
    }

    @Override
    public char min() {
        throw new NoSuchElementException();
    }

    @Override
    public char max() {
        throw new NoSuchElementException();
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        return defaultValue;
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public char[] toSortedArray() {
        return new char[0];
    }

    @Override
    public MutableCharList toSortedList() {
        return new CharArrayList();
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return true;
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharSet)) {
            return false;
        }
        CharSet set = (CharSet)obj;
        return set.isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public MutableCharSet toSet() {
        return new CharHashSet();
    }

    @Override
    public MutableCharBag toBag() {
        return new CharHashBag();
    }

    @Override
    public CharSet freeze() {
        return this;
    }

    @Override
    public ImmutableCharSet toImmutable() {
        return this;
    }

    @Override
    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    @Override
    public char[] toArray() {
        return new char[0];
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CharIterator charIterator() {
        return ImmutableEmptyCharIterator.INSTANCE;
    }
}

