/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.databinding.runtime.adapter;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.ValueProperty;
import org.eclipse.viatra.addon.databinding.runtime.adapter.ObservableDefinition;
import org.eclipse.viatra.addon.databinding.runtime.api.ViatraObservables;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;

public class MatcherProperties {
    private static final String SOURCE_MUST_BE_A_PATTERN_MATCH = "Source must be a Pattern Match";

    private MatcherProperties() {
    }

    public static String[] getPropertyNames(IQuerySpecification<?> query) {
        Map<String, ObservableDefinition> parameterMap = ViatraObservables.calculateObservableValues(query);
        return parameterMap.keySet().toArray(new String[parameterMap.keySet().size()]);
    }

    public static IObservableValue getObservableValue(IQuerySpecification<?> query, IPatternMatch match, String parameterName) {
        Map<String, ObservableDefinition> parameterMap = ViatraObservables.calculateObservableValues(query);
        if (parameterMap.size() > 0) {
            ObservableDefinition def = parameterMap.get(parameterName);
            String expression = def.getExpression();
            switch (def.getType()) {
                case OBSERVABLE_FEATURE: {
                    return ViatraObservables.getObservableValue(match, expression);
                }
                case OBSERVABLE_LABEL: {
                    return ViatraObservables.getObservableLabelFeature(match, expression);
                }
            }
            return null;
        }
        return null;
    }

    public static IValueProperty getValueProperty(IQuerySpecification<?> query, String parameterName) {
        Map<String, ObservableDefinition> parameterMap = ViatraObservables.calculateObservableValues(query);
        Preconditions.checkArgument((boolean)parameterMap.containsKey(parameterName), (Object)"Invalid parameter name");
        ObservableDefinition def = parameterMap.get(parameterName);
        switch (def.getType()) {
            case OBSERVABLE_FEATURE: {
                return new MatcherProperty(def.getExpression());
            }
            case OBSERVABLE_LABEL: {
                return new MatcherLabelProperty(def.getExpression());
            }
        }
        return null;
    }

    protected static class MatcherLabelProperty
    extends ValueProperty {
        private String expression;

        public MatcherLabelProperty(String expression) {
            this.expression = expression;
        }

        public Object getValueType() {
            return String.class;
        }

        public IObservableValue observe(Realm realm, Object source) {
            Preconditions.checkArgument((boolean)(source instanceof IPatternMatch), (Object)MatcherProperties.SOURCE_MUST_BE_A_PATTERN_MATCH);
            return ViatraObservables.getObservableLabelFeature((IPatternMatch)source, this.expression);
        }
    }

    protected static class MatcherProperty
    extends ValueProperty {
        private String expression;

        public MatcherProperty(String expression) {
            this.expression = expression;
        }

        public Object getValueType() {
            return null;
        }

        public IObservableValue observe(Realm realm, Object source) {
            Preconditions.checkArgument((boolean)(source instanceof IPatternMatch), (Object)MatcherProperties.SOURCE_MUST_BE_A_PATTERN_MATCH);
            return ViatraObservables.getObservableValue((IPatternMatch)source, this.expression);
        }
    }
}

