/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.generator.dtos.scenario.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.apache.log4j.Logger;
import org.eclipse.viatra.examples.cps.generator.dtos.AppClass;
import org.eclipse.viatra.examples.cps.generator.dtos.BuildableCPSConstraint;
import org.eclipse.viatra.examples.cps.generator.dtos.HostClass;
import org.eclipse.viatra.examples.cps.generator.dtos.MinMaxData;
import org.eclipse.viatra.examples.cps.generator.dtos.Percentage;
import org.eclipse.viatra.examples.cps.generator.dtos.constraints.ICPSConstraints;
import org.eclipse.viatra.examples.cps.generator.dtos.scenario.IScenario;
import org.eclipse.viatra.examples.cps.generator.utils.RandomUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;

public class BasicScenario
implements IScenario {
    @Extension
    protected Logger logger = Logger.getLogger((String)"cps.generator.Tests.BasicScenario");
    @Extension
    protected RandomUtils randUtil = new RandomUtils();
    private Random rand;
    private int C;
    private double Ssig = 0.0;
    private double Shc = 0.0;
    private double Sac = 0.0;
    private Iterable<HostClass> hostClasses = ImmutableList.of();

    public BasicScenario(Random rand) {
        this.rand = rand;
    }

    @Override
    public ICPSConstraints getConstraintsFor(int countOfElements) {
        double _sqrt = Math.sqrt(countOfElements);
        double _multiply = 0.05726 * _sqrt;
        long _round = Math.round(_multiply);
        this.C = (int)_round;
        this.logger.info((Object)("--> Element count = " + Integer.valueOf(countOfElements)));
        this.logger.info((Object)("--> C = " + Integer.valueOf(this.C)));
        this.hostClasses = this.createHostClassList();
        long _round_1 = Math.round((double)(this.C / 2) * (1.0 - this.Ssig));
        int min = (int)_round_1;
        long _round_2 = Math.round((double)(this.C / 2) * (1.0 + this.Ssig));
        int max = (int)_round_2;
        MinMaxData<Integer> _minMaxData = new MinMaxData<Integer>(min, max);
        Iterable<AppClass> _createAppClassList = this.createAppClassList();
        BuildableCPSConstraint cons = new BuildableCPSConstraint("Basic Scenario", _minMaxData, _createAppClassList, this.hostClasses);
        return cons;
    }

    public Iterable<HostClass> createHostClassList() {
        try {
            ArrayList hostClasses = Lists.newArrayList();
            int min = (int)((double)this.C * (1.0 - this.Shc));
            int max = (int)((double)this.C * (1.0 + this.Shc));
            int hostClassCount = this.randUtil.randInt(new MinMaxData<Integer>(min, max), this.rand);
            this.logger.info((Object)("--> HostClass count = " + Integer.valueOf(hostClassCount)));
            int typCount = hostClassCount * 5;
            this.logger.info((Object)("--> HostType count = " + Integer.valueOf(typCount)));
            int instCount = hostClassCount * 5;
            this.logger.info((Object)("--> HostInstance count = " + Integer.valueOf(instCount)));
            int comCount = instCount / 3;
            this.logger.info((Object)("--> Host comm count = " + Integer.valueOf(comCount)));
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, hostClassCount, true);
            for (Integer i : _doubleDotLessThan) {
                MinMaxData<Integer> _minMaxData = new MinMaxData<Integer>(typCount, typCount);
                MinMaxData<Integer> _minMaxData_1 = new MinMaxData<Integer>(instCount, instCount);
                MinMaxData<Integer> _minMaxData_2 = new MinMaxData<Integer>(comCount, comCount);
                HashMap<HostClass, Integer> _hashMap = new HashMap<HostClass, Integer>();
                HostClass _hostClass = new HostClass("HC" + i, _minMaxData, _minMaxData_1, _minMaxData_2, _hashMap);
                hostClasses.add(_hostClass);
            }
            return hostClasses;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Iterable<AppClass> createAppClassList() {
        try {
            ArrayList appClasses = Lists.newArrayList();
            int min = (int)((double)this.C * (1.0 - this.Sac));
            int max = (int)((double)this.C * (1.0 + this.Sac));
            int appClassCount = this.randUtil.randInt(new MinMaxData<Integer>(min, max), this.rand);
            this.logger.info((Object)("--> AppClass count = " + Integer.valueOf(appClassCount)));
            HashMap<HostClass, Integer> allocRatios = new HashMap<HostClass, Integer>();
            for (HostClass hc : this.hostClasses) {
                allocRatios.put(hc, 1);
            }
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, appClassCount, true);
            for (Integer i : _doubleDotLessThan) {
                MinMaxData<Integer> _minMaxData = new MinMaxData<Integer>(appClassCount * 5, appClassCount * 8);
                MinMaxData<Integer> _minMaxData_1 = new MinMaxData<Integer>(appClassCount * 5, appClassCount * 8);
                MinMaxData<Integer> _minMaxData_2 = new MinMaxData<Integer>(5, 5);
                MinMaxData<Integer> _minMaxData_3 = new MinMaxData<Integer>(7, 7);
                Percentage _percentage = new Percentage(80.0);
                Percentage _percentage_1 = new Percentage(75.0);
                Percentage _percentage_2 = new Percentage(30.0);
                AppClass _appClass = new AppClass("AC" + i, _minMaxData, _minMaxData_1, _minMaxData_2, _minMaxData_3, _percentage, allocRatios, _percentage_1, _percentage_2);
                appClasses.add(_appClass);
            }
            return appClasses;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

