/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.bundlor.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.bundlor.ui.BundlorUiPlugin;
import org.eclipse.virgo.ide.bundlor.ui.internal.actions.RunBundlorActionDelegate;
import org.eclipse.virgo.ide.facet.core.FacetUtils;

public class AutomaticRunBundlorActionDelegate
extends RunBundlorActionDelegate {
    public void run(IAction action) {
        final LinkedHashSet<IJavaProject> projects = new LinkedHashSet<IJavaProject>();
        for (IProject project : this.getSelected()) {
            if (!FacetUtils.isBundleProject((IResource)project)) continue;
            projects.add(JavaCore.create((IProject)project));
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                for (IJavaProject javaProject : projects) {
                    IProject project = javaProject.getProject();
                    IProjectDescription description = project.getDescription();
                    try {
                        List<ICommand> cmds = Arrays.asList(description.getBuildSpec());
                        ArrayList<ICommand> newCmds = new ArrayList<ICommand>(cmds);
                        if (BundlorUiPlugin.isBundlorBuilding((IResource)project)) {
                            for (ICommand config : cmds) {
                                if (!config.getBuilderName().equals("org.eclipse.virgo.ide.bundlor.core.builder")) continue;
                                newCmds.remove(config);
                            }
                        } else {
                            ICommand command = project.getDescription().newCommand();
                            command.setBuilderName("org.eclipse.virgo.ide.bundlor.core.builder");
                            newCmds.add(command);
                        }
                        if (cmds.equals(newCmds)) continue;
                        description.setBuildSpec(newCmds.toArray(new ICommand[0]));
                        project.setDescription(description, monitor);
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.bundlor.ui", "An exception occurred while running bundlor.", (Throwable)e));
                    }
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), (IRunnableWithProgress)op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.bundlor.ui", "An exception occurred while running bundlor.", (Throwable)e));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

