/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class JarExtractor {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");

    public static File extract(File file, String pathname) throws IOException {
        File docBase = new File(file.getParentFile(), pathname);
        JarExtractor.extract(file, docBase);
        return docBase;
    }

    public static void extract(File file, File destinationDir) throws IOException {
        if (destinationDir.exists()) {
            return;
        }
        logger.info("Extracting jar: " + file.getAbsolutePath());
        destinationDir.mkdirs();
        JarFile jarFile = null;
        InputStream input = null;
        try {
            jarFile = new JarFile(file);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                int last = name.lastIndexOf(47);
                if (last >= 0) {
                    File parent = new File(destinationDir, name.substring(0, last));
                    parent.mkdirs();
                }
                if (name.endsWith("/")) continue;
                input = jarFile.getInputStream(jarEntry);
                File extractedFile = JarExtractor.extract(input, destinationDir, name);
                long lastModified = jarEntry.getTime();
                if (lastModified != -1L && lastModified != 0L && extractedFile != null) {
                    extractedFile.setLastModified(lastModified);
                }
                input.close();
                input = null;
            }
        }
        catch (IOException e) {
            JarExtractor.deleteDir(destinationDir);
            throw e;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable t) {}
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {}
            }
        }
        logger.info("Extracted path: " + destinationDir.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File src, File dest) {
        String[] files;
        boolean result = true;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length && result; ++i) {
            File fileSrc = new File(src, files[i]);
            File fileDest = new File(dest, files[i]);
            if (fileSrc.isDirectory()) {
                result = JarExtractor.copy(fileSrc, fileDest);
                continue;
            }
            FileChannel ic = null;
            AbstractInterruptibleChannel oc = null;
            try {
                ic = new FileInputStream(fileSrc).getChannel();
                oc = new FileOutputStream(fileDest).getChannel();
                ic.transferTo(0L, ic.size(), (WritableByteChannel)((Object)oc));
                continue;
            }
            catch (IOException e) {
                logger.error("Copy failed: src: " + fileSrc + ", dest: " + fileDest, e);
                result = false;
                continue;
            }
            finally {
                if (ic != null) {
                    try {
                        ic.close();
                    }
                    catch (IOException e) {}
                }
                if (oc != null) {
                    try {
                        oc.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return result;
    }

    public static boolean delete(File dir) {
        if (dir == null) {
            return true;
        }
        if (dir.isDirectory()) {
            return JarExtractor.deleteDir(dir);
        }
        return dir.delete();
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return true;
        }
        String[] fileNames = dir.list();
        if (fileNames == null) {
            fileNames = new String[]{};
        }
        for (String fileName : fileNames) {
            File file = new File(dir, fileName);
            if (file.isDirectory()) {
                JarExtractor.deleteDir(file);
                continue;
            }
            file.delete();
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File extract(InputStream input, File docBase, String name) throws IOException {
        File file = new File(docBase, name);
        FilterOutputStream output = null;
        try {
            int n;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                ((BufferedOutputStream)output).write(buffer, 0, n);
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
        }
        return file;
    }
}

