/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectAction
extends ProvisioningAction {
    public static final String ACTION_COLLECT = "collect";

    public IStatus execute(Map<String, Object> parameters) {
        IProfile profile = (IProfile)parameters.get("profile");
        IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        try {
            IArtifactRequest[] requests = this.collect(agent, iu, profile);
            Collection artifactRequests = (Collection)parameters.get("artifactRequests");
            artifactRequests.add(requests);
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Status.OK_STATUS;
    }

    IArtifactRequest[] collect(IProvisioningAgent agent, IInstallableUnit installableUnit, IProfile profile) throws ProvisionException {
        Collection toDownload = installableUnit.getArtifacts();
        if (toDownload == null) {
            return new IArtifactRequest[0];
        }
        IFileArtifactRepository destination = Util.getDownloadCacheRepo(agent);
        IArtifactRequest[] requests = new IArtifactRequest[toDownload.size()];
        int count = 0;
        for (IArtifactKey key : toDownload) {
            requests[count++] = Util.getArtifactRepositoryManager(agent).createMirrorRequest(key, (IArtifactRepository)destination, null, null, profile.getProperty("org.eclipse.equinox.p2.stats.parameters"));
        }
        if (requests.length == count) {
            return requests;
        }
        IArtifactRequest[] result = new IArtifactRequest[count];
        System.arraycopy(requests, 0, result, 0, count);
        return result;
    }
}

