/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;
import javax.ejb.TimerConfig;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.timer.TimerData;
import org.apache.openejb.core.timer.TimerType;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class IntervalTimerData
extends TimerData {
    private final long intervalDuration;
    private final Date initialExpiration;

    public IntervalTimerData(long id, EjbTimerServiceImpl timerService, String deploymentId, Object primaryKey, Method timeoutMethod, TimerConfig timerConfig, Date initialExpiration, long intervalDuration) {
        super(id, timerService, deploymentId, primaryKey, timeoutMethod, timerConfig);
        this.initialExpiration = initialExpiration;
        this.intervalDuration = intervalDuration;
    }

    @Override
    public TimerType getType() {
        return TimerType.Interval;
    }

    public long getIntervalDuration() {
        return this.intervalDuration;
    }

    public Date getInitialExpiration() {
        return this.initialExpiration;
    }

    @Override
    public Trigger initializeTrigger() {
        SimpleTrigger simpleTrigger = new SimpleTrigger();
        Date startTime = new Date(this.initialExpiration.getTime() - this.intervalDuration);
        simpleTrigger.setStartTime(startTime);
        simpleTrigger.setRepeatInterval(this.intervalDuration);
        simpleTrigger.setRepeatCount(-1);
        return simpleTrigger;
    }

    public String toString() {
        return TimerType.Interval.name() + " initialExpiration = [" + DateFormat.getDateTimeInstance().format(this.initialExpiration) + "] intervalDuration = [" + this.intervalDuration + "]";
    }
}

