/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.ArtifactSpecification;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;
import org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactGraphFactory;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStorageFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.InstallArtifactRefreshHandler;
import org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.ArtifactIdentityScoper;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.ScopeNameFactory;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.nano.shim.scope.ScopeFactory;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.math.OrderedPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ParPlanInstallArtifact
extends StandardPlanInstallArtifact {
    private static final ArrayList<ArtifactSpecification> EMPTY_ARTIFACT_SPECIFICATION_LIST;
    private static final String META_INF_PATH = "//META-INF";
    private final Object monitor;
    private final InstallArtifactGraphFactory bundleInstallArtifactGraphFactory;
    private final InstallArtifactGraphFactory configInstallArtifactGraphFactory;
    private final ArtifactStorageFactory artifactStorageFactory;
    private final ArtifactIdentityDeterminer artifactIdentityDeterminer;
    private final List<GraphNode<InstallArtifact>> childInstallArtifacts;
    private final InstallArtifactGraphFactory planInstallArtifactGraphFactory;
    private static final Logger LOGGER;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        Factory factory = new Factory("ParPlanInstallArtifact.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findChildArtifacts", "org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact", "org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "artifactFS:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "java.util.List"), 95);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "createChildInstallArtifacts", "org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact", "java.util.List:", "childArtifacts:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "java.util.List"), 124);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "beginInstall", "org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact", "", "", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 158);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "isChildPresent", "org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact", "java.util.List:org.eclipse.virgo.util.common.GraphNode:", "children:newChild:", "", "boolean"), 188);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "equalIdentities", "org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "ia1:ia2:", "", "boolean"), 199);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createArtifactStorage", "org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact", "org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry:org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:", "artifactFSEntry:artifactIdentity:", "", "org.eclipse.virgo.kernel.install.artifact.ArtifactStorage"), 205);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact", "java.lang.String:", "symbolicName:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "boolean"), 215);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doRefresh", "org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact", "java.lang.String:", "symbolicName:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "boolean"), 220);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findChild", "org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact", "java.lang.String:", "symbolicName:", "", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact"), 231);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact");
        EMPTY_ARTIFACT_SPECIFICATION_LIST = new ArrayList();
        LOGGER = LoggerFactory.getLogger(ParPlanInstallArtifact.class);
    }

    public ParPlanInstallArtifact(@NonNull ArtifactIdentity identity, @NonNull ArtifactStorage artifactStorage, @NonNull ArtifactStateMonitor artifactStateMonitor, @NonNull ScopeServiceRepository scopeServiceRepository, @NonNull ScopeFactory scopeFactory, @NonNull EventLogger eventLogger, @NonNull InstallArtifactGraphFactory bundleInstallArtifactGraphFactory, @NonNull InstallArtifactRefreshHandler refreshHandler, String repositoryName, @NonNull InstallArtifactGraphFactory configInstallArtifactGraphFactory, @NonNull ArtifactStorageFactory artifactStorageFactory, @NonNull ArtifactIdentityDeterminer artifactIdentityDeterminer, @NonNull InstallArtifactGraphFactory planInstallArtifactGraphFactory) throws DeploymentException {
        EventLogger eventLogger2 = eventLogger;
        ScopeFactory scopeFactory2 = scopeFactory;
        ScopeServiceRepository scopeServiceRepository2 = scopeServiceRepository;
        ArtifactStateMonitor artifactStateMonitor2 = artifactStateMonitor;
        ArtifactStorage artifactStorage2 = artifactStorage;
        ArtifactIdentity artifactIdentity = identity;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)artifactIdentity);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)artifactStorage2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)artifactStateMonitor2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)scopeServiceRepository2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$5$e9cfb671((Object)scopeFactory2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$6$2b4b16f2((Object)eventLogger2);
        super(identity, true, true, PlanDescriptor.Provisioning.AUTO, artifactStorage, artifactStateMonitor, scopeServiceRepository, scopeFactory, eventLogger, refreshHandler, repositoryName, EMPTY_ARTIFACT_SPECIFICATION_LIST);
        try {
            this.monitor = new Object();
            this.artifactStorageFactory = artifactStorageFactory;
            this.configInstallArtifactGraphFactory = configInstallArtifactGraphFactory;
            this.bundleInstallArtifactGraphFactory = bundleInstallArtifactGraphFactory;
            this.planInstallArtifactGraphFactory = planInstallArtifactGraphFactory;
            this.artifactIdentityDeterminer = artifactIdentityDeterminer;
            List<OrderedPair<ArtifactIdentity, ArtifactFSEntry>> childArtifacts = this.findChildArtifacts(artifactStorage.getArtifactFS());
            this.childInstallArtifacts = this.createChildInstallArtifacts(childArtifacts);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private List<OrderedPair<ArtifactIdentity, ArtifactFSEntry>> findChildArtifacts(ArtifactFS artifactFS) throws DeploymentException {
        try {
            try {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                ArrayList<OrderedPair<ArtifactIdentity, ArtifactFSEntry>> childArtifacts = new ArrayList<OrderedPair<ArtifactIdentity, ArtifactFSEntry>>();
                ArtifactFSEntry entry = artifactFS.getEntry("/");
                ArtifactFSEntry[] children = entry.getChildren();
                if (children.length == 0) {
                    throw new DeploymentException("Failed to find child artifacts in par " + artifactFS);
                }
                String scopeName = ScopeNameFactory.createScopeName(this.getName(), this.getVersion());
                ArtifactFSEntry[] artifactFSEntryArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ArtifactFSEntry child = artifactFSEntryArray[n2];
                    String name = child.getPath();
                    if (!META_INF_PATH.equals(name)) {
                        ArtifactIdentity artifactIdentity = this.artifactIdentityDeterminer.determineIdentity(child.getArtifactFS().getFile(), scopeName);
                        if (artifactIdentity != null) {
                            ArtifactIdentity scopedIdentity = ArtifactIdentityScoper.scopeArtifactIdentity(artifactIdentity);
                            childArtifacts.add((OrderedPair<ArtifactIdentity, ArtifactFSEntry>)new OrderedPair((Object)scopedIdentity, (Object)child));
                        } else {
                            LOGGER.warn("Skipping entry " + name + " as it is not of a recognized type");
                        }
                    }
                    ++n2;
                }
                ArrayList<OrderedPair<ArtifactIdentity, ArtifactFSEntry>> arrayList = childArtifacts;
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                return arrayList;
            }
            catch (Throwable throwable) {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    List<GraphNode<InstallArtifact>> createChildInstallArtifacts(List<OrderedPair<ArtifactIdentity, ArtifactFSEntry>> childArtifacts) throws DeploymentException {
        try {
            try {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                ArrayList<GraphNode<InstallArtifact>> childInstallArtifacts = new ArrayList<GraphNode<InstallArtifact>>();
                for (OrderedPair<ArtifactIdentity, ArtifactFSEntry> childArtifact : childArtifacts) {
                    GraphNode<InstallArtifact> subGraph = null;
                    ArtifactIdentity identity = (ArtifactIdentity)childArtifact.getFirst();
                    ArtifactFSEntry artifactFs = (ArtifactFSEntry)childArtifact.getSecond();
                    ArtifactStorage childArtifactStorage = this.createArtifactStorage(artifactFs, identity);
                    if ("bundle".equals(identity.getType())) {
                        subGraph = this.bundleInstallArtifactGraphFactory.constructInstallArtifactGraph(identity, childArtifactStorage, null, null);
                    } else if ("configuration".equals(identity.getType())) {
                        subGraph = this.configInstallArtifactGraphFactory.constructInstallArtifactGraph(identity, childArtifactStorage, null, null);
                    } else if ("plan".equals(identity.getType())) {
                        subGraph = this.planInstallArtifactGraphFactory.constructInstallArtifactGraph(identity, childArtifactStorage, null, null);
                    }
                    if (subGraph == null) {
                        LOGGER.warn("Skipping " + identity + " as " + identity.getType() + " artifacts are not supported within a PAR");
                        continue;
                    }
                    childInstallArtifacts.add(subGraph);
                }
                ArrayList<GraphNode<InstallArtifact>> arrayList = childInstallArtifacts;
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return arrayList;
            }
            catch (Throwable throwable) {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginInstall() throws DeploymentException {
        try {
            try {
                ArrayList<GraphNode<InstallArtifact>> children;
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                super.beginInstall();
                Object object = this.monitor;
                synchronized (object) {
                    children = new ArrayList<GraphNode<InstallArtifact>>(this.childInstallArtifacts);
                }
                for (GraphNode graphNode : children) {
                    ((AbstractInstallArtifact)graphNode.getValue()).beginInstall();
                }
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGraph(GraphNode<InstallArtifact> graph) throws DeploymentException {
        try {
            Object object = this.monitor;
            synchronized (object) {
                super.setGraph(graph);
                List children = graph.getChildren();
                for (GraphNode<InstallArtifact> child : this.childInstallArtifacts) {
                    if (ParPlanInstallArtifact.isChildPresent(children, child)) continue;
                    graph.addChild(child);
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean isChildPresent(List<GraphNode<InstallArtifact>> children, GraphNode<InstallArtifact> newChild) {
        try {
            try {
                boolean bl;
                block5: {
                    ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                    InstallArtifact newChildValue = (InstallArtifact)newChild.getValue();
                    for (GraphNode<InstallArtifact> child : children) {
                        InstallArtifact childValue = (InstallArtifact)child.getValue();
                        if (!ParPlanInstallArtifact.equalIdentities(childValue, newChildValue)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return bl;
            }
            catch (Throwable throwable) {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean equalIdentities(InstallArtifact ia1, InstallArtifact ia2) {
        try {
            try {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                ArtifactIdentity id1 = ((AbstractInstallArtifact)ia1).getIdentity();
                ArtifactIdentity id2 = ((AbstractInstallArtifact)ia2).getIdentity();
                boolean bl = id1.equals(id2);
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return bl;
            }
            catch (Throwable throwable) {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ArtifactStorage createArtifactStorage(ArtifactFSEntry artifactFSEntry, ArtifactIdentity artifactIdentity) {
        try {
            try {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                ArtifactStorage innerStorage = this.artifactStorageFactory.create(artifactFSEntry.getArtifactFS().getFile(), artifactIdentity);
                ArtifactStorage outerStorage = this.artifactStorage;
                DelegatingArtifactStorage delegatingArtifactStorage = new DelegatingArtifactStorage(innerStorage, outerStorage, null);
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return delegatingArtifactStorage;
            }
            catch (Throwable throwable) {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public boolean refresh(String symbolicName) throws DeploymentException {
        try {
            try {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_6);
                boolean bl = super.refresh(symbolicName);
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_6);
                return bl;
            }
            catch (Throwable throwable) {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    protected boolean doRefresh(String symbolicName) throws DeploymentException {
        try {
            try {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
                InstallArtifact childToRefresh = this.findChild(symbolicName);
                if (childToRefresh == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_FAILED, new Object[]{symbolicName, this.getType(), this.getName(), this.getVersion()});
                    throw new DeploymentException("Refresh failed: child '" + symbolicName + "' not found in " + this.getType() + "(" + this.getName() + ", " + this.getVersion() + ")");
                }
                boolean bl = childToRefresh.refresh();
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
                return bl;
            }
            catch (Throwable throwable) {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private InstallArtifact findChild(String symbolicName) {
        try {
            try {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
                InstallArtifact childToRefresh = null;
                List children = this.getGraph().getChildren();
                for (GraphNode child : children) {
                    InstallArtifact childInstallArtifact = (InstallArtifact)child.getValue();
                    String childName = childInstallArtifact.getName();
                    if (!childName.equals(symbolicName) && !childName.equals(String.valueOf(ScopeNameFactory.createScopeName(this.getName(), this.getVersion())) + "-" + symbolicName)) continue;
                    childToRefresh = childInstallArtifact;
                    break;
                }
                InstallArtifact installArtifact = childToRefresh;
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
                return installArtifact;
            }
            catch (Throwable throwable) {
                ParPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static final class DelegatingArtifactStorage
    implements ArtifactStorage {
        private final ArtifactStorage delegate;
        private final ArtifactStorage sourceStorage;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

        private DelegatingArtifactStorage(ArtifactStorage delegate, ArtifactStorage sourceStorage) {
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                this.delegate = delegate;
                this.sourceStorage = sourceStorage;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public void delete() {
            try {
                try {
                    DelegatingArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                    this.delegate.delete();
                    DelegatingArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                    return;
                }
                catch (Throwable throwable) {
                    DelegatingArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                    throw throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public ArtifactFS getArtifactFS() {
            try {
                return this.delegate.getArtifactFS();
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public void synchronize() {
            try {
                try {
                    DelegatingArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                    this.sourceStorage.synchronize();
                    this.delegate.synchronize();
                    DelegatingArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                    return;
                }
                catch (Throwable throwable) {
                    DelegatingArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                    throw throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public void synchronize(URI sourceUri) {
            try {
                try {
                    DelegatingArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                    this.delegate.synchronize(sourceUri);
                    DelegatingArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                    return;
                }
                catch (Throwable throwable) {
                    DelegatingArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                    throw throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public void rollBack() {
            try {
                try {
                    DelegatingArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
                    this.delegate.rollBack();
                    this.sourceStorage.rollBack();
                    DelegatingArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
                    return;
                }
                catch (Throwable throwable) {
                    DelegatingArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
                    throw throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ DelegatingArtifactStorage(ArtifactStorage artifactStorage, ArtifactStorage artifactStorage2, DelegatingArtifactStorage delegatingArtifactStorage) {
            ArtifactStorage artifactStorage3 = artifactStorage2;
            ArtifactStorage artifactStorage4 = artifactStorage;
            DelegatingArtifactStorage ajc$aspectInstance = this;
            try {
                void sourceStorage;
                void delegate;
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                ajc$aspectInstance.delegate = delegate;
                ajc$aspectInstance.sourceStorage = sourceStorage;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        static {
            Factory factory = new Factory("ParPlanInstallArtifact.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact$DelegatingArtifactStorage"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact$DelegatingArtifactStorage", "", "", "", "void"), 259);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "synchronize", "org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact$DelegatingArtifactStorage", "", "", "", "void"), 273);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "synchronize", "org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact$DelegatingArtifactStorage", "java.net.URI:", "sourceUri:", "", "void"), 281);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rollBack", "org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact$DelegatingArtifactStorage", "", "", "", "void"), 285);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact$DelegatingArtifactStorage");
        }
    }
}

