/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.eclipse.gemini.web.tomcat.internal.loading.BundleWebappClassLoader;
import org.eclipse.gemini.web.tomcat.internal.support.BundleDependencyDeterminer;
import org.eclipse.gemini.web.tomcat.internal.support.BundleFileResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BundleDependenciesJarScanner
implements JarScanner {
    private static final String COMMA_SEPARATOR = ",";
    static final String SCANNER_SKIP_BUNDLES_PROPERTY_NAME = "org.eclipse.gemini.web.tomcat.scanner.skip.bundles";
    private static final String SCANNER_SKIP_BUNDLES_PROPERTY_VALUE_DEFAULT = "org.eclipse.osgi,javax.servlet,javax.servlet.jsp,javax.el";
    private static final String JAR_URL_SUFFIX = "!/";
    private static final String JAR_URL_PREFIX = "jar:";
    private static final String REFERENCE_URL_PREFIX = "reference";
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleDependenciesJarScanner.class);
    private final BundleDependencyDeterminer bundleDependencyDeterminer;
    private final BundleFileResolver bundleFileResolver;
    private final Set<String> skipBundles;

    public BundleDependenciesJarScanner(BundleDependencyDeterminer bundleDependencyDeterminer, BundleFileResolver bundleFileResolver, BundleContext bundleContext) {
        this.bundleDependencyDeterminer = bundleDependencyDeterminer;
        this.bundleFileResolver = bundleFileResolver;
        this.skipBundles = Collections.unmodifiableSet(this.getBundlesToSkip(bundleContext));
    }

    public void scan(ServletContext context, ClassLoader classLoader, JarScannerCallback callback, Set<String> jarsToSkip) {
        if (classLoader instanceof BundleWebappClassLoader) {
            Bundle bundle = ((BundleWebappClassLoader)classLoader).getBundle();
            this.scanDependentBundles(bundle, callback);
        }
    }

    private void scanDependentBundles(Bundle rootBundle, JarScannerCallback callback) {
        Set<Bundle> dependencies = this.bundleDependencyDeterminer.getDependencies(rootBundle);
        for (Bundle bundle : dependencies) {
            if (this.skipBundles.contains(bundle.getSymbolicName())) continue;
            this.scanBundle(bundle, callback);
        }
    }

    private void scanBundle(Bundle bundle, JarScannerCallback callback) {
        File bundleFile = this.bundleFileResolver.resolve(bundle);
        if (bundleFile != null) {
            this.scanBundleFile(bundleFile, callback);
        } else {
            this.scanJarUrlConnection(bundle, callback);
        }
    }

    private void scanJarUrlConnection(Bundle bundle, JarScannerCallback callback) {
        URL bundleUrl;
        String bundleLocation = bundle.getLocation();
        try {
            bundleUrl = new URL(bundleLocation);
            bundleUrl = REFERENCE_URL_PREFIX.equals(bundleUrl.getProtocol()) ? new URL(JAR_URL_PREFIX + bundleUrl.getFile() + JAR_URL_SUFFIX) : new URL(JAR_URL_PREFIX + bundleLocation + JAR_URL_SUFFIX);
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn("Failed to create jar: url for bundle location " + bundleLocation);
            return;
        }
        this.scanBundleUrl(bundleUrl, callback);
    }

    private void scanBundleFile(File bundleFile, JarScannerCallback callback) {
        if (bundleFile.isDirectory()) {
            try {
                callback.scan(bundleFile);
            }
            catch (IOException e) {
                LOGGER.warn("Failure when attempting to scan bundle file '" + bundleFile + "'.", (Throwable)e);
            }
        } else {
            URL bundleUrl;
            try {
                bundleUrl = new URL(JAR_URL_PREFIX + bundleFile.toURI().toURL() + JAR_URL_SUFFIX);
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.warn("Failed to create jar: url for bundle file " + bundleFile);
                return;
            }
            this.scanBundleUrl(bundleUrl, callback);
        }
    }

    private void scanBundleUrl(URL url, JarScannerCallback callback) {
        try {
            URLConnection connection = url.openConnection();
            if (connection instanceof JarURLConnection) {
                callback.scan((JarURLConnection)connection);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failure when attempting to scan bundle via jar URL '" + url + "'.", (Throwable)e);
        }
    }

    private Set<String> getBundlesToSkip(BundleContext bundleContext) {
        HashSet<String> result = new HashSet<String>();
        String property = bundleContext.getProperty(SCANNER_SKIP_BUNDLES_PROPERTY_NAME);
        if (property == null) {
            property = SCANNER_SKIP_BUNDLES_PROPERTY_VALUE_DEFAULT;
        }
        String[] bundlesNames = property.split(COMMA_SEPARATOR);
        int i = 0;
        while (bundlesNames != null && i < bundlesNames.length) {
            result.add(bundlesNames[i]);
            ++i;
        }
        return result;
    }
}

