/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.AppContext;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.cdi.CdiResourceInjectionService;
import org.apache.openejb.cdi.CdiScanner;
import org.apache.openejb.cdi.CustomELAdapter;
import org.apache.openejb.cdi.ManagedSecurityService;
import org.apache.openejb.cdi.OpenEJBLifecycle;
import org.apache.openejb.cdi.OpenEJBTransactionService;
import org.apache.openejb.cdi.OpenEJBValidatorService;
import org.apache.openejb.cdi.OptimizedLoaderService;
import org.apache.openejb.cdi.StartupObject;
import org.apache.openejb.cdi.ThreadSingletonService;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.classloader.MultipleClassLoader;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.ConversationService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.spi.adaptor.ELAdaptor;

public class ThreadSingletonServiceImpl
implements ThreadSingletonService {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, ThreadSingletonServiceImpl.class);
    private static final ThreadLocal<WebBeansContext> contexts = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(StartupObject startupObject) {
        AppContext appContext = startupObject.getAppContext();
        appContext.setCdiEnabled(this.hasBeans(startupObject.getAppInfo()));
        Properties properties = new Properties();
        HashMap services = new HashMap();
        properties.setProperty("org.apache.webbeans.application.jsp", "true");
        properties.setProperty("org.apache.webbeans.spi.deployer.useEjbMetaDataDiscoveryService", "true");
        properties.setProperty("org.apache.webbeans.forceNoCheckedExceptions", "false");
        properties.setProperty(SecurityService.class.getName(), ManagedSecurityService.class.getName());
        properties.setProperty("org.apache.webbeans.conversation.Conversation.periodicDelay", "1800000");
        properties.setProperty("org.apache.webbeans.application.supportsConversation", "true");
        properties.setProperty("org.apache.webbeans.ignoredDecoratorInterfaces", "org.apache.aries.proxy.weaving.WovenProxy");
        services.put(AppContext.class, appContext);
        services.put(TransactionService.class, new OpenEJBTransactionService());
        services.put(ELAdaptor.class, new CustomELAdapter(appContext));
        services.put(ContextsService.class, (Object)((Object)new CdiAppContextsService(true)));
        services.put(ResourceInjectionService.class, new CdiResourceInjectionService());
        services.put(ScannerService.class, new CdiScanner());
        services.put(LoaderService.class, new OptimizedLoaderService());
        this.optional(services, ConversationService.class, "org.apache.webbeans.jsf.DefaultConversationService");
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = oldClassLoader != ThreadSingletonServiceImpl.class.getClassLoader() ? new MultipleClassLoader(oldClassLoader, ThreadSingletonServiceImpl.class.getClassLoader()) : oldClassLoader;
        Thread.currentThread().setContextClassLoader(cl);
        Object old = null;
        try {
            WebBeansContext webBeansContext = new WebBeansContext(services, properties);
            appContext.set(WebBeansContext.class, webBeansContext);
            old = this.contextEntered(webBeansContext);
            this.setConfiguration(webBeansContext.getOpenWebBeansConfiguration());
            try {
                ((ContainerLifecycle)webBeansContext.getService(ContainerLifecycle.class)).startApplication((Object)startupObject);
            }
            catch (Exception e) {
                throw new RuntimeException("couldn't start owb context", e);
            }
            this.contextExited(old);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        catch (Throwable throwable) {
            this.contextExited(old);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            throw throwable;
        }
    }

    private boolean hasBeans(AppInfo appInfo) {
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            if (ejbJar.beans == null) continue;
            return true;
        }
        return false;
    }

    private <T> void optional(Map<Class<?>, Object> services, Class<T> type, String implementation) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(implementation);
            services.put(type, type.cast(clazz.newInstance()));
            logger.debug(String.format("CDI Service Installed: %s = %s", type.getName(), implementation));
        }
        catch (ClassNotFoundException e) {
            logger.debug(String.format("CDI Service not installed: %s", type.getName()));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void setConfiguration(OpenWebBeansConfiguration configuration) {
        configuration.setProperty(SecurityService.class.getName(), (Object)ManagedSecurityService.class.getName());
        configuration.setProperty("org.apache.webbeans.forceNoCheckedExceptions", (Object)"false");
        configuration.setProperty("org.apache.webbeans.spi.ContainerLifecycle", (Object)OpenEJBLifecycle.class.getName());
        configuration.setProperty("org.apache.webbeans.spi.TransactionService", (Object)OpenEJBTransactionService.class.getName());
        configuration.setProperty("org.apache.webbeans.spi.ScannerService", (Object)CdiScanner.class.getName());
        configuration.setProperty("org.apache.webbeans.spi.ContextsService", (Object)CdiAppContextsService.class.getName());
        configuration.setProperty("org.apache.webbeans.spi.ValidatorService", (Object)OpenEJBValidatorService.class.getName());
        configuration.setProperty(ResourceInjectionService.class.getName(), (Object)CdiResourceInjectionService.class.getName());
    }

    @Override
    public Object contextEntered(WebBeansContext newOWBContext) {
        return ThreadSingletonServiceImpl.enter(newOWBContext);
    }

    public static WebBeansContext enter(WebBeansContext newOWBContext) {
        WebBeansContext oldContext = contexts.get();
        contexts.set(newOWBContext);
        ThreadSingletonServiceImpl.contextMessage(newOWBContext, "Enter:");
        return oldContext;
    }

    private static void contextMessage(WebBeansContext newOWBContext, String prefix) {
    }

    @Override
    public void contextExited(Object oldContext) {
        ThreadSingletonServiceImpl.exit(oldContext);
    }

    public static void exit(Object oldContext) {
        if (oldContext != null && !(oldContext instanceof WebBeansContext)) {
            throw new IllegalArgumentException("ThreadSingletonServiceImpl can only be used with WebBeansContext, not " + oldContext.getClass().getName());
        }
        contexts.set((WebBeansContext)oldContext);
    }

    private WebBeansContext getContext(Object key) {
        return ThreadSingletonServiceImpl.get((ClassLoader)key);
    }

    public static WebBeansContext get(ClassLoader classLoader) {
        WebBeansContext context = contexts.get();
        if (context == null) {
            ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
            List<AppContext> appContexts = containerSystem.getAppContexts();
            if (appContexts.size() > 0) {
                for (AppContext currentAppContext : appContexts) {
                    if (classLoader != currentAppContext.getClassLoader()) continue;
                    return currentAppContext.getWebBeansContext();
                }
            }
            throw new IllegalStateException("On a thread without an initialized context");
        }
        return context;
    }

    private static WebBeansContext getWebBeansContext(List<AppContext> appContexts) {
        Collections.sort(appContexts, new Comparator<AppContext>(){

            @Override
            public int compare(AppContext appContext, AppContext appContext1) {
                return appContext1.getWebBeansContext().getBeanManagerImpl().getBeans().size() - appContext.getWebBeansContext().getBeanManagerImpl().getBeans().size();
            }
        });
        return appContexts.get(0).getWebBeansContext();
    }

    public WebBeansContext get(Object key) {
        return this.getContext(key);
    }

    public void clear(Object key) {
        ThreadSingletonServiceImpl.contextMessage(this.getContext(key), "clearing ");
        this.getContext(key).clear();
    }
}

