/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFramework;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.shell.Command;
import org.eclipse.virgo.shell.internal.commands.AbstractInstallArtifactBasedCommands;
import org.eclipse.virgo.shell.internal.formatting.PackageCommandFormatter;
import org.eclipse.virgo.shell.internal.util.PackageHolder;
import org.osgi.framework.Version;

@Command(value="package")
public final class PackageCommands {
    private final QuasiFrameworkFactory quasiFrameworkFactory;
    private final PackageCommandFormatter formatter;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public PackageCommands(QuasiFrameworkFactory quasiFrameworkFactory) {
        this.quasiFrameworkFactory = quasiFrameworkFactory;
        this.formatter = new PackageCommandFormatter();
    }

    @Command(value="list")
    public List<String> list() {
        try {
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            List<String> list = this.formatter.formatList(this.getAllPackages());
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return list;
        }
        catch (Throwable throwable) {
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    @Command(value="examine")
    public List<String> examine(String name, String versionString) {
        try {
            List<String> list;
            block5: {
                Version version;
                PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                ArrayList<QuasiExportPackage> matchingExports = new ArrayList<QuasiExportPackage>();
                try {
                    version = AbstractInstallArtifactBasedCommands.convertToVersion(versionString);
                }
                catch (IllegalArgumentException iae) {
                    list = Arrays.asList(iae.getMessage());
                    break block5;
                }
                PackageHolder packages = this.getPackages(name);
                for (QuasiExportPackage exportPackage : packages.getExporters()) {
                    if (!exportPackage.getVersion().equals((Object)version)) continue;
                    matchingExports.add(exportPackage);
                }
                list = matchingExports.isEmpty() ? Arrays.asList(String.format("No package with name '%s' and version '%s' was found", name, version)) : this.formatter.formatExamine(matchingExports);
            }
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return list;
        }
        catch (Throwable throwable) {
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private List<QuasiExportPackage> getAllPackages() {
        ArrayList<QuasiExportPackage> packages = new ArrayList<QuasiExportPackage>();
        for (QuasiBundle bundle : this.quasiFrameworkFactory.create().getBundles()) {
            packages.addAll(bundle.getExportPackages());
        }
        return packages;
    }

    private PackageHolder getPackages(String packageName) {
        QuasiFramework framework = this.quasiFrameworkFactory.create();
        if (packageName != null) {
            ArrayList<QuasiImportPackage> importers = new ArrayList<QuasiImportPackage>();
            ArrayList<QuasiExportPackage> exporters = new ArrayList<QuasiExportPackage>();
            List bundles = framework.getBundles();
            for (QuasiBundle qBundle : bundles) {
                QuasiExportPackage exportPackage;
                QuasiImportPackage importPackage = this.processImporters(qBundle, packageName);
                if (importPackage != null) {
                    importers.add(importPackage);
                }
                if ((exportPackage = this.processExporters(qBundle, packageName)) == null) continue;
                exporters.add(exportPackage);
            }
            return new PackageHolder(exporters, importers, packageName);
        }
        return null;
    }

    private QuasiImportPackage processImporters(QuasiBundle qBundle, String packageName) {
        try {
            QuasiImportPackage quasiImportPackage;
            block3: {
                PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                for (QuasiImportPackage qImportPackage : qBundle.getImportPackages()) {
                    if (!qImportPackage.getPackageName().equals(packageName)) continue;
                    quasiImportPackage = qImportPackage;
                    break block3;
                }
                quasiImportPackage = null;
            }
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return quasiImportPackage;
        }
        catch (Throwable throwable) {
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private QuasiExportPackage processExporters(QuasiBundle qBundle, String packageName) {
        try {
            QuasiExportPackage quasiExportPackage;
            block3: {
                PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                for (QuasiExportPackage qExportPackage : qBundle.getExportPackages()) {
                    if (!qExportPackage.getPackageName().equals(packageName)) continue;
                    quasiExportPackage = qExportPackage;
                    break block3;
                }
                quasiExportPackage = null;
            }
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return quasiExportPackage;
        }
        catch (Throwable throwable) {
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("PackageCommands.java", Class.forName("org.eclipse.virgo.shell.internal.commands.PackageCommands"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "list", "org.eclipse.virgo.shell.internal.commands.PackageCommands", "", "", "", "java.util.List"), 43);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "examine", "org.eclipse.virgo.shell.internal.commands.PackageCommands", "java.lang.String:java.lang.String:", "name:versionString:", "", "java.util.List"), 48);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processImporters", "org.eclipse.virgo.shell.internal.commands.PackageCommands", "org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle:java.lang.String:", "qBundle:packageName:", "", "org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage"), 102);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processExporters", "org.eclipse.virgo.shell.internal.commands.PackageCommands", "org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle:java.lang.String:", "qBundle:packageName:", "", "org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage"), 111);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.shell.internal.commands.PackageCommands");
    }
}

