/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.xml;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.validation.ValidationException;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.FieldAccess;
import org.apache.bval.util.MethodAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaConstraint<T, A extends Annotation> {
    private final Member member;
    private final Class<T> beanClass;
    private final A annotation;
    private final AccessStrategy accessStrategy;

    public MetaConstraint(Class<T> beanClass, Member member, A annotation) {
        this.member = member;
        this.beanClass = beanClass;
        this.annotation = annotation;
        if (member != null) {
            this.accessStrategy = MetaConstraint.createAccessStrategy(member);
            if (this.accessStrategy == null || this.accessStrategy.getPropertyName() == null) {
                throw new ValidationException("Annotated method does not follow the JavaBeans naming convention: " + member);
            }
        } else {
            this.accessStrategy = null;
        }
    }

    private static AccessStrategy createAccessStrategy(Member member) {
        if (member instanceof Method) {
            return new MethodAccess((Method)member);
        }
        if (member instanceof Field) {
            return new FieldAccess((Field)member);
        }
        return null;
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public Member getMember() {
        return this.member;
    }

    public A getAnnotation() {
        return this.annotation;
    }

    public AccessStrategy getAccessStrategy() {
        return this.accessStrategy;
    }
}

