/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.log.impl;

import java.io.PrintStream;
import java.util.Locale;
import org.eclipse.virgo.medic.impl.config.ConfigurationProvider;
import org.eclipse.virgo.medic.log.impl.ExecutionStackAccessor;
import org.eclipse.virgo.medic.log.impl.LoggingLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingPrintStreamWrapper
extends PrintStream {
    private static final String LOGBACK_PACKAGE_NAME_PREFIX = "ch.qos.logback";
    private final ThreadLocal<StringBuilder> entryBuilders;
    private Logger logger;
    private final ExecutionStackAccessor executionStackAccessor;
    private final ConfigurationProvider configurationProvider;
    private final String configurationProperty;
    private final PrintStream originalPrintStream;
    private final LoggingLevel loggingLevel;
    private final String loggerName;
    private static final String NULL_STRING = "null";

    public LoggingPrintStreamWrapper(PrintStream printStream, String loggerName, LoggingLevel loggingLevel, ExecutionStackAccessor executionStackAccessor, ConfigurationProvider configurationProvider, String configurationProperty) {
        super(printStream);
        this.loggerName = loggerName;
        this.loggingLevel = loggingLevel;
        this.executionStackAccessor = executionStackAccessor;
        this.entryBuilders = new StringBuilderThreadLocal();
        this.configurationProvider = configurationProvider;
        this.configurationProperty = configurationProperty;
        this.originalPrintStream = printStream;
    }

    public LoggingPrintStreamWrapper(PrintStream printStream, String loggerName, ExecutionStackAccessor executionStackAccessor, ConfigurationProvider configurationProvider, String configurationProperty) {
        this(printStream, loggerName, LoggingLevel.DEBUG, executionStackAccessor, configurationProvider, configurationProperty);
    }

    @Override
    public PrintStream append(char c) {
        if (!this.isLoggingEnabled()) {
            super.append(c);
        } else {
            this.internalAppend(c);
        }
        return this;
    }

    private boolean internalAppend(char c) {
        if (c == '\n' || c == '\r') {
            this.createEntryAndLog(this.entryBuilders.get());
            return true;
        }
        this.entryBuilders.get().append(c);
        return false;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        if (!this.isLoggingEnabled()) {
            super.append(csq, start, end);
        } else {
            this.internalAppend(csq, start, end);
        }
        return this;
    }

    private void internalAppend(CharSequence csq, int start, int end) {
        int i = start;
        while (i < end) {
            char c;
            boolean loggedEntry = this.internalAppend(csq.charAt(i));
            if (loggedEntry && i < end - 1 && ((c = csq.charAt(i + 1)) == '\n' || c == '\r')) {
                ++i;
            }
            ++i;
        }
    }

    @Override
    public PrintStream append(CharSequence csq) {
        if (!this.isLoggingEnabled()) {
            super.append(csq);
        } else {
            if (csq == null) {
                throw new NullPointerException("Character Sequence to be added to the printStream from source '" + this.loggerName + "' is null");
            }
            this.internalAppend(csq, 0, csq.length());
        }
        return this;
    }

    @Override
    public boolean checkError() {
        if (!this.isLoggingEnabled()) {
            return super.checkError();
        }
        return false;
    }

    @Override
    public void close() {
        if (!this.isLoggingEnabled()) {
            super.close();
        }
    }

    @Override
    public void flush() {
        if (!this.isLoggingEnabled()) {
            super.flush();
        }
    }

    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        if (!this.isLoggingEnabled()) {
            super.format(l, format, args);
        } else {
            this.internalPrint(String.format(l, format, args));
        }
        return this;
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        if (!this.isLoggingEnabled()) {
            super.format(format, args);
        } else {
            this.internalPrint(String.format(format, args));
        }
        return this;
    }

    @Override
    public void print(boolean b) {
        if (!this.isLoggingEnabled()) {
            super.print(b);
        } else {
            this.internalPrint(b);
        }
    }

    private void internalPrint(boolean b) {
        this.entryBuilders.get().append(b);
    }

    @Override
    public void print(char c) {
        if (!this.isLoggingEnabled()) {
            super.print(c);
        } else {
            this.internalAppend(c);
        }
    }

    @Override
    public void print(char[] ca) {
        if (!this.isLoggingEnabled()) {
            super.print(ca);
        } else {
            this.internalPrint(ca);
        }
    }

    private void internalPrint(char[] ca) {
        String s = new String(ca);
        this.internalAppend(s, 0, s.length());
    }

    @Override
    public void print(double d) {
        if (!this.isLoggingEnabled()) {
            super.print(d);
        } else {
            this.internalPrint(d);
        }
    }

    private void internalPrint(double d) {
        this.entryBuilders.get().append(d);
    }

    @Override
    public void print(float f) {
        if (!this.isLoggingEnabled()) {
            super.print(f);
        } else {
            this.internalPrint(f);
        }
    }

    private void internalPrint(float f) {
        this.entryBuilders.get().append(f);
    }

    @Override
    public void print(int i) {
        if (!this.isLoggingEnabled()) {
            super.print(i);
        } else {
            this.internalPrint(i);
        }
    }

    private void internalPrint(int i) {
        this.entryBuilders.get().append(i);
    }

    @Override
    public void print(long l) {
        if (!this.isLoggingEnabled()) {
            super.print(l);
        } else {
            this.internalPrint(l);
        }
    }

    private void internalPrint(long l) {
        this.entryBuilders.get().append(l);
    }

    @Override
    public void print(Object obj) {
        if (!this.isLoggingEnabled()) {
            super.print(obj);
        } else {
            this.internalPrint(obj);
        }
    }

    private void internalPrint(Object obj) {
        if (obj == null) {
            this.entryBuilders.get().append(NULL_STRING);
        } else {
            this.internalPrint(obj.toString().toCharArray());
        }
    }

    @Override
    public void print(String s) {
        if (!this.isLoggingEnabled()) {
            super.print(s);
        } else {
            this.internalPrint(s);
        }
    }

    private void internalPrint(String s) {
        if (s == null) {
            s = NULL_STRING;
        }
        this.internalAppend(s, 0, s.length());
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        if (!this.isLoggingEnabled()) {
            super.printf(l, format, args);
        } else {
            this.internalPrint(String.format(l, format, args));
        }
        return this;
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        if (!this.isLoggingEnabled()) {
            super.printf(format, args);
        } else {
            this.internalPrint(String.format(format, args));
        }
        return this;
    }

    @Override
    public void println() {
        if (!this.isLoggingEnabled()) {
            super.println();
        } else {
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(boolean x) {
        if (!this.isLoggingEnabled()) {
            super.println(x);
        } else {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(char x) {
        if (!this.isLoggingEnabled()) {
            super.println(x);
        } else {
            this.internalAppend(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(char[] x) {
        if (!this.isLoggingEnabled()) {
            super.println(x);
        } else {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(double x) {
        if (!this.isLoggingEnabled()) {
            super.println(x);
        } else {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(float x) {
        if (!this.isLoggingEnabled()) {
            super.println(x);
        } else {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(int x) {
        if (!this.isLoggingEnabled()) {
            super.println(x);
        } else {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(long x) {
        if (!this.isLoggingEnabled()) {
            super.println(x);
        } else {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(Object x) {
        if (!this.isLoggingEnabled()) {
            super.println(x);
        } else {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(String x) {
        if (!this.isLoggingEnabled()) {
            super.println(x);
        } else {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    protected void setError() {
        if (!this.isLoggingEnabled()) {
            super.setError();
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        if (!this.isLoggingEnabled()) {
            super.write(buf, off, len);
        } else {
            byte[] outputBytes = new byte[len];
            System.arraycopy(buf, off, outputBytes, 0, len);
            this.internalPrint(new String(outputBytes));
        }
    }

    @Override
    public void write(int b) {
        if (!this.isLoggingEnabled()) {
            super.write(b);
        } else if (b == 10 || b == 13) {
            this.createEntryAndLog(this.entryBuilders.get());
        } else {
            this.entryBuilders.get().append(new String(new byte[]{(byte)b}));
        }
    }

    private void createEntryAndLog(StringBuilder stringBuilder) {
        String string = stringBuilder.toString();
        switch (this.loggingLevel) {
            case DEBUG: {
                this.getLogger().debug(string);
                break;
            }
            case ERROR: {
                this.getLogger().error(string);
                break;
            }
            case INFO: {
                this.getLogger().info(string);
                break;
            }
            case WARNING: {
                this.getLogger().warn(string);
            }
        }
        this.entryBuilders.remove();
    }

    private boolean isLoggingEnabled() {
        return this.isEnabledInConfiguration() && !this.isWithinLogback();
    }

    private boolean isWithinLogback() {
        Class<?>[] executionStack;
        Class<?>[] classArray = executionStack = this.executionStackAccessor.getExecutionStack();
        int n = executionStack.length;
        int n2 = 0;
        while (n2 < n) {
            String pkgName;
            Class<?> clazz = classArray[n2];
            Package pkg = clazz.getPackage();
            if (pkg != null && (pkgName = pkg.getName()) != null && pkgName.startsWith(LOGBACK_PACKAGE_NAME_PREFIX)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isEnabledInConfiguration() {
        return Boolean.valueOf((String)this.configurationProvider.getConfiguration().get(this.configurationProperty));
    }

    public PrintStream getOriginalPrintStream() {
        return this.originalPrintStream;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger((String)this.loggerName);
        }
        return this.logger;
    }

    private static final class StringBuilderThreadLocal
    extends ThreadLocal<StringBuilder> {
        private StringBuilderThreadLocal() {
        }

        @Override
        public StringBuilder initialValue() {
            return new StringBuilder();
        }
    }
}

