/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.deployer.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.virgo.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusFileModificator {
    private static final char DOT = '.';
    private static final char NEW_LINE = '\n';
    public static final String SUCCESS_MARK = "ok";
    public static final String ERROR_MARK = "error";
    public static final String OP_DEPLOY = "deploy";
    public static final String OP_UNDEPLOY = "undeploy";
    private static final String STATE_DIR_NAME = ".state";
    private static final String BUNDLE_ID_RECORD = "bundle-id";
    private static final String LAST_MODIFIED = "last-modified";
    private static final String DELIMITER = "=";
    private static final String EMPTY_STRING = "";
    private static final Logger logger = LoggerFactory.getLogger(StatusFileModificator.class);
    private static final String[] STATUS_FILENAMES_SUFFEXES = new String[]{".deploy.ok", ".deploy.error", ".undeploy.ok", ".undeploy.error"};
    private static final String STATUS_FILENAMES_DEPLOY_PATTERN = ".deploy.(ok|error)";

    public static void deleteStatusFile(String deployableName, File pickupDir) {
        File stateDir = new File(pickupDir, STATE_DIR_NAME);
        if (stateDir.exists()) {
            String[] stringArray = STATUS_FILENAMES_SUFFEXES;
            int n = STATUS_FILENAMES_SUFFEXES.length;
            int n2 = 0;
            while (n2 < n) {
                String fileNameSuffix = stringArray[n2];
                StatusFileModificator.deleteFile(new File(stateDir, String.valueOf(deployableName) + fileNameSuffix));
                ++n2;
            }
        } else if (logger.isInfoEnabled()) {
            logger.info("State directory [" + stateDir.getAbsolutePath() + "] does not exist. Therefore, there is no status file to delete.");
        }
    }

    public static String deleteStatusFileByNamePattern(String warNamePattern, File pickupDir) {
        File stateDir = new File(pickupDir, STATE_DIR_NAME);
        if (stateDir.exists()) {
            String[] statusFileNames;
            String[] stringArray = statusFileNames = stateDir.list();
            int n = statusFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String stateFileName = stringArray[n2];
                if (stateFileName.matches(String.valueOf(warNamePattern) + STATUS_FILENAMES_DEPLOY_PATTERN)) {
                    StatusFileModificator.deleteFile(new File(stateDir, stateFileName));
                    return stateFileName.substring(0, stateFileName.lastIndexOf(OP_DEPLOY) - 1);
                }
                ++n2;
            }
        } else if (logger.isInfoEnabled()) {
            logger.info("State directory [" + stateDir.getAbsolutePath() + "] does not exist. Therefore, there is no status file to delete.");
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Cannot delete any status file, as no status file matches the given warNamePattern [" + warNamePattern + "].");
        }
        return EMPTY_STRING;
    }

    public static void createStatusFile(String deployableName, File pickupDir, String operation, boolean status, long bundleId, long lastModified) {
        File stateDir = new File(pickupDir, STATE_DIR_NAME);
        if (!stateDir.exists() && !stateDir.mkdirs()) {
            logger.error("Cannot create state directory [" + stateDir.getAbsolutePath() + "]. Status file for the operation cannot be created.");
            return;
        }
        File statusFile = new File(stateDir, String.valueOf(deployableName) + '.' + operation + '.' + (status ? SUCCESS_MARK : ERROR_MARK));
        StatusFileModificator.writeStatusFileRecord(statusFile, bundleId, lastModified);
    }

    public static long getLastModifiedFromStatusFile(String deployableName, File pickupDir) {
        String lastModifiedStr;
        File stateDir = new File(pickupDir, STATE_DIR_NAME);
        if (!stateDir.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info("Checking if last stored state of [" + deployableName + "]." + "The state directory does not exist.");
            }
            return -1L;
        }
        File statusFile = new File(stateDir, String.valueOf(deployableName) + '.' + OP_DEPLOY + '.' + SUCCESS_MARK);
        if (!statusFile.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info("The status file [" + statusFile.getAbsolutePath() + "] does not exist.");
            }
            return -1L;
        }
        Properties props = StatusFileModificator.loadProperties(statusFile);
        if (props != null && (lastModifiedStr = props.getProperty(LAST_MODIFIED)) != null && !EMPTY_STRING.equals(lastModifiedStr)) {
            return Long.parseLong(lastModifiedStr);
        }
        return -1L;
    }

    private static void writeStatusFileRecord(File statusFile, long bundleId, long lastModified) {
        block5: {
            FileWriter fw = null;
            try {
                try {
                    fw = new FileWriter(statusFile, true);
                    fw.write("bundle-id=" + bundleId);
                    fw.write(10);
                    fw.write("last-modified=" + lastModified);
                    fw.write(10);
                    fw.flush();
                }
                catch (IOException e) {
                    logger.error("Cannot update the status of operation.", (Throwable)e);
                    IOUtils.closeQuietly((Closeable)fw);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)fw);
        }
    }

    private static void deleteFile(File file) {
        if (file.exists() && !file.delete()) {
            logger.error("Cannot delete file [" + file.getAbsolutePath() + "].");
        }
    }

    private static Properties loadProperties(File statusFile) {
        Properties properties;
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(statusFile);
            props.load(fis);
            properties = props;
        }
        catch (IOException e) {
            block4: {
                try {
                    if (!logger.isInfoEnabled()) break block4;
                    logger.info("Cannot load file with name [" + statusFile.getAbsolutePath() + "].", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)fis);
            return null;
        }
        IOUtils.closeQuietly((Closeable)fis);
        return properties;
    }
}

