/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.ArrayEnumeration;

public class DelegatePermissionCollection
extends PermissionCollection {
    private static final String PERMISSION_COLLECTION_CLASS = "openejb.permission-collection.class";
    private PermissionCollection pc = DelegatePermissionCollection.getPermissionCollection();

    @Override
    public void add(Permission permission) {
        this.pc.add(permission);
    }

    @Override
    public boolean implies(Permission permission) {
        return this.pc.implies(permission);
    }

    @Override
    public Enumeration<Permission> elements() {
        return this.pc.elements();
    }

    public static PermissionCollection getPermissionCollection() {
        try {
            return (PermissionCollection)DelegatePermissionCollection.class.getClassLoader().loadClass(SystemInstance.get().getOptions().get(PERMISSION_COLLECTION_CLASS, FastPermissionCollection.class.getName())).newInstance();
        }
        catch (Exception cnfe) {
            return new FastPermissionCollection();
        }
    }

    public static class FastPermissionCollection
    extends PermissionCollection {
        private static final int MAX_CACHE_SIZE = SystemInstance.get().getOptions().get("openejb.permission-collection.cache.size", 3000);
        private final List<Permission> permissions = new ArrayList<Permission>();
        private final Map<Permission, Boolean> alreadyEvaluatedPermissions = new ConcurrentHashMap<Permission, Boolean>();

        @Override
        public synchronized void add(Permission permission) {
            this.permissions.add(permission);
        }

        @Override
        public synchronized boolean implies(Permission permission) {
            if (this.alreadyEvaluatedPermissions.containsKey(permission)) {
                return this.alreadyEvaluatedPermissions.get(permission);
            }
            if (this.alreadyEvaluatedPermissions.size() > MAX_CACHE_SIZE) {
                this.alreadyEvaluatedPermissions.clear();
            }
            for (Permission perm : this.permissions) {
                if (!perm.implies(permission)) continue;
                this.alreadyEvaluatedPermissions.put(permission, true);
                return true;
            }
            this.alreadyEvaluatedPermissions.put(permission, false);
            return false;
        }

        @Override
        public synchronized Enumeration<Permission> elements() {
            return new ArrayEnumeration(this.permissions);
        }
    }
}

