/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal.bundle;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;
import org.eclipse.virgo.kernel.deployer.core.internal.BlockingAbortableSignal;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.InstallArtifactRefreshHandler;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleDriver;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.ArtifactIdentityScoper;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.core.AbortableSignal;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.io.FileCopyUtils;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.BundleSymbolicName;
import org.eclipse.virgo.util.osgi.manifest.ExportedPackage;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardBundleInstallArtifact
extends AbstractInstallArtifact
implements BundleInstallArtifact {
    private static final String DEFAULTED_BSN = "org-eclipse-virgo-kernel-DefaultedBSN";
    private final Logger logger;
    private static final String MANIFEST_ENTRY_NAME = "META-INF/MANIFEST.MF";
    private static final String EQUINOX_SYSTEM_BUNDLE_NAME = "org.eclipse.osgi";
    private static final String RESERVED_SYSTEM_BUNDLE_NAME = "system.bundle";
    private static final long REFRESH_RESTART_WAIT_PERIOD = 60L;
    private final Object monitor;
    private final ArtifactStorage artifactStorage;
    private final BundleDriver bundleDriver;
    private final InstallArtifactRefreshHandler refreshHandler;
    private final ArtifactIdentityDeterminer identityDeterminer;
    private BundleManifest bundleManifest;
    private QuasiBundle quasiBundle;
    private Bundle cachedBundle;
    private File cachedBundleFile;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;

    public StandardBundleInstallArtifact(@NonNull ArtifactIdentity artifactIdentifier, @NonNull BundleManifest bundleManifest, @NonNull ArtifactStorage artifactStorage, @NonNull BundleDriver bundleDriver, @NonNull ArtifactStateMonitor artifactStateMonitor, @NonNull InstallArtifactRefreshHandler refreshHandler, String repositoryName, EventLogger eventLogger, ArtifactIdentityDeterminer identityDeterminer) {
        InstallArtifactRefreshHandler installArtifactRefreshHandler = refreshHandler;
        ArtifactStateMonitor artifactStateMonitor2 = artifactStateMonitor;
        BundleDriver bundleDriver2 = bundleDriver;
        ArtifactStorage artifactStorage2 = artifactStorage;
        BundleManifest bundleManifest2 = bundleManifest;
        ArtifactIdentity artifactIdentity = artifactIdentifier;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)artifactIdentity);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)bundleManifest2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)artifactStorage2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)bundleDriver2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$5$e9cfb671((Object)artifactStateMonitor2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$6$2b4b16f2((Object)installArtifactRefreshHandler);
        super(artifactIdentifier, artifactStorage, artifactStateMonitor, repositoryName, eventLogger);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.monitor = new Object();
            this.artifactStorage = artifactStorage;
            this.bundleManifest = bundleManifest;
            this.bundleDriver = bundleDriver;
            this.refreshHandler = refreshHandler;
            this.identityDeterminer = identityDeterminer;
            this.synchronizeBundleSymbolicNameWithIdentity();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void synchronizeBundleSymbolicNameWithIdentity() {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                BundleManifest bundleManifest = this.bundleManifest;
                BundleSymbolicName bundleSymbolicName = bundleManifest.getBundleSymbolicName();
                if (!this.getName().equals(bundleSymbolicName.getSymbolicName())) {
                    bundleSymbolicName.setSymbolicName(this.getName());
                    bundleManifest.setHeader(DEFAULTED_BSN, "true");
                }
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleManifest getBundleManifest() throws IOException {
        try {
            Object object = this.monitor;
            synchronized (object) {
                if (this.bundleManifest == null) {
                    this.bundleManifest = this.getManifestFromArtifactFS();
                }
                return this.bundleManifest;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private BundleManifest getManifestFromArtifactFS() throws IOException {
        try {
            ArtifactFSEntry manifestEntry = this.artifactStorage.getArtifactFS().getEntry(MANIFEST_ENTRY_NAME);
            if (manifestEntry != null && manifestEntry.exists()) {
                InputStreamReader manifestReader = new InputStreamReader(manifestEntry.getInputStream());
                try {
                    BundleManifest bundleManifest = BundleManifestFactory.createBundleManifest((Reader)manifestReader);
                    return bundleManifest;
                }
                finally {
                    ((Reader)manifestReader).close();
                }
            }
            return BundleManifestFactory.createBundleManifest();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuasiBundle getQuasiBundle() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                return this.quasiBundle;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQuasiBundle(QuasiBundle quasiBundle) {
        try {
            Object object = this.monitor;
            synchronized (object) {
                this.quasiBundle = quasiBundle;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getBundle() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                return this.quasiBundle == null ? this.cachedBundle : this.quasiBundle.getBundle();
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getBundleFile() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                return this.quasiBundle == null ? this.cachedBundleFile : this.quasiBundle.getBundleFile();
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public InstallArtifact.State getState() {
        try {
            this.monitorBundle();
            InstallArtifact.State state = super.getState();
            return this.isFragment() && (state == InstallArtifact.State.STARTING || state == InstallArtifact.State.ACTIVE || state == InstallArtifact.State.STOPPING) ? InstallArtifact.State.RESOLVED : state;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void endInstall() throws DeploymentException {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                this.monitorBundle();
                super.endInstall();
                this.cacheAndDelete();
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorBundle() {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                Object object = this.monitor;
                synchronized (object) {
                    Bundle bundle = this.getBundle();
                    if (bundle != null) {
                        this.bundleDriver.setBundle(bundle);
                    }
                }
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheAndDelete() {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                Object object = this.monitor;
                synchronized (object) {
                    if (this.quasiBundle == null) {
                    } else {
                        this.cachedBundle = this.quasiBundle.getBundle();
                        this.cachedBundleFile = this.quasiBundle.getBundleFile();
                        this.quasiBundle = null;
                    }
                }
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void pushThreadContext() {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
                this.bundleDriver.pushThreadContext();
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void popThreadContext() {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
                this.bundleDriver.popThreadContext();
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void trackStart() {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                AbortableSignal signal = this.createStateMonitorSignal(null);
                this.bundleDriver.trackStart(signal);
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void beginInstall() throws DeploymentException {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_7);
                if (this.isFragmentOnSystemBundle()) {
                    throw new DeploymentException("Deploying fragments of the system bundle is not supported");
                }
                super.beginInstall();
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_7);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_7);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean isFragment() {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
                boolean bl = this.bundleManifest.getFragmentHost().getBundleSymbolicName() != null;
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
                return bl;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean isFragmentOnSystemBundle() {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_9);
                String fragmentHost = this.bundleManifest.getFragmentHost().getBundleSymbolicName();
                boolean bl = fragmentHost != null ? fragmentHost.equals(EQUINOX_SYSTEM_BUNDLE_NAME) || fragmentHost.equals(RESERVED_SYSTEM_BUNDLE_NAME) : false;
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_9);
                return bl;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_9);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void start(AbortableSignal signal) throws DeploymentException {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_10);
                if (!this.hasStartingParent()) {
                    this.topLevelStart();
                }
                this.pushThreadContext();
                try {
                    this.driveDoStart(signal);
                }
                finally {
                    this.popThreadContext();
                }
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_10);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_10);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    protected void doStart(AbortableSignal signal) throws DeploymentException {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_11);
                this.bundleDriver.start(signal);
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_11);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_11);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void stop() throws DeploymentException {
        try {
            try {
                block10: {
                    StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_12);
                    if (this.getBundle().getState() == 32 && this.shouldStop()) {
                        this.pushThreadContext();
                        try {
                            try {
                                this.doStop();
                            }
                            catch (DeploymentException e) {
                                this.getStateMonitor().onStopFailed(this, e);
                                this.popThreadContext();
                                break block10;
                            }
                        }
                        catch (Throwable throwable) {
                            this.popThreadContext();
                            throw throwable;
                        }
                        this.popThreadContext();
                    }
                }
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_12);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_12);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    protected void doStop() throws DeploymentException {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_13);
                this.bundleDriver.stop();
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_13);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_13);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void uninstall() throws DeploymentException {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_14);
                super.uninstall();
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_14);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_14);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    protected void doUninstall() throws DeploymentException {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_15);
                this.bundleDriver.uninstall();
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_15);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_15);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean isScoped() {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_16);
                boolean bl = this.getScopeName() != null;
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_16);
                return bl;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_16);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean stopBundleIfNecessary() throws DeploymentException {
        try {
            try {
                boolean bl;
                boolean stopBundle;
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_17);
                int bundleState = this.getBundle().getState();
                boolean bl2 = stopBundle = bundleState == 8 || bundleState == 32;
                if (stopBundle) {
                    this.stop();
                    bl = true;
                } else {
                    bl = false;
                }
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_17);
                return bl;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_17);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean completeUpdateAndRefresh(boolean startRequired) {
        try {
            try {
                boolean bl;
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_18);
                try {
                    boolean refreshed = this.bundleDriver.update(this.bundleManifest, this.artifactStorage.getArtifactFS().getFile());
                    if (refreshed && startRequired) {
                        BlockingAbortableSignal blockingSignal = new BlockingAbortableSignal(true);
                        this.start(blockingSignal);
                        try {
                            refreshed = blockingSignal.checkComplete();
                        }
                        catch (DeploymentException deploymentException) {
                            refreshed = false;
                        }
                    }
                    bl = refreshed;
                }
                catch (Exception exception) {
                    bl = false;
                }
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_18);
                return bl;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_18);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doRefresh() throws DeploymentException {
        try {
            try {
                boolean bl;
                BundleManifest newBundleManifest;
                BundleManifest currentBundleManifest;
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_19);
                Object object = this.monitor;
                synchronized (object) {
                    currentBundleManifest = this.bundleManifest;
                }
                try {
                    newBundleManifest = this.getManifestFromArtifactFS();
                }
                catch (IOException ioe) {
                    throw new DeploymentException("Failed to read new bundle manifest during refresh", (Throwable)ioe);
                }
                ArtifactIdentity newIdentity = this.identityDeterminer.determineIdentity(this.artifactStorage.getArtifactFS().getFile(), this.getScopeName());
                if (newIdentity == null) {
                    throw new DeploymentException("Failed to determine new identity during refresh");
                }
                if (!this.isNameAndVersionUnchanged(newIdentity = ArtifactIdentityScoper.scopeArtifactIdentity(newIdentity))) {
                    bl = false;
                } else {
                    boolean bundleStopped = this.stopBundleIfNecessary();
                    Object object2 = this.monitor;
                    synchronized (object2) {
                        this.bundleManifest = newBundleManifest;
                    }
                    this.synchronizeBundleSymbolicNameWithIdentity();
                    if (!this.refreshScope()) {
                        object2 = this.monitor;
                        synchronized (object2) {
                            this.bundleManifest = currentBundleManifest;
                        }
                        this.startIfNecessary(bundleStopped);
                        bl = false;
                    } else if (this.isScoped() && !this.isExportPackageUnchanged(currentBundleManifest, newBundleManifest)) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.CANNOT_REFRESH_BUNDLE_AS_SCOPED_AND_EXPORTS_CHANGED, new Object[]{this.getName(), this.getVersion()});
                        object2 = this.monitor;
                        synchronized (object2) {
                            this.bundleManifest = currentBundleManifest;
                        }
                        this.startIfNecessary(bundleStopped);
                        bl = false;
                    } else {
                        boolean refreshSuccessful = this.completeUpdateAndRefresh(bundleStopped);
                        if (!refreshSuccessful) {
                            Object object3 = this.monitor;
                            synchronized (object3) {
                                this.bundleManifest = currentBundleManifest;
                            }
                            this.startIfNecessary(bundleStopped);
                        }
                        bl = refreshSuccessful;
                    }
                }
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_19);
                return bl;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_19);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void startIfNecessary(boolean bundleStopped) throws DeploymentException {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_20);
                if (bundleStopped) {
                    BlockingAbortableSignal signal = new BlockingAbortableSignal(true);
                    this.start(signal);
                    signal.awaitCompletion(60L);
                }
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_20);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_20);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean isExportPackageUnchanged(BundleManifest currentBundleManifest, BundleManifest newBundleManifest) {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_21);
                Set<ExportedPackage> previousExportedPackageSet = this.getExportedPackageSet(currentBundleManifest.getExportPackage().getExportedPackages());
                Set<ExportedPackage> newExportedPackageSet = this.getExportedPackageSet(newBundleManifest.getExportPackage().getExportedPackages());
                boolean bl = newExportedPackageSet.equals(previousExportedPackageSet);
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_21);
                return bl;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_21);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean isNameAndVersionUnchanged(ArtifactIdentity newIdentity) {
        try {
            try {
                boolean bl;
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_22);
                if (newIdentity.getName().equals(this.getName()) && newIdentity.getVersion().equals((Object)this.getVersion())) {
                    bl = true;
                } else {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.CANNOT_REFRESH_BUNDLE_IDENTITY_CHANGED, new Object[]{this.getName(), this.getVersion(), newIdentity.getName(), newIdentity.getVersion()});
                    bl = false;
                }
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_22);
                return bl;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_22);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean refreshScope() {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_23);
                PlanInstallArtifact scopedAncestor = this.getScopedAncestor();
                boolean refreshed = scopedAncestor != null ? scopedAncestor.refreshScope() : this.refreshHandler.refresh(this);
                boolean bl = refreshed;
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_23);
                return bl;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_23);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    PlanInstallArtifact getScopedAncestor() {
        try {
            List ancestors = this.getGraph().getParents();
            while (!ancestors.isEmpty()) {
                GraphNode ancestor = (GraphNode)ancestors.get(0);
                InstallArtifact ancestorArtifact = (InstallArtifact)ancestor.getValue();
                PlanInstallArtifact planAncestor = (PlanInstallArtifact)ancestorArtifact;
                if (planAncestor.isScoped()) {
                    return planAncestor;
                }
                ancestor = (GraphNode)ancestors.get(0);
                ancestors = ancestor.getParents();
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Set<ExportedPackage> getExportedPackageSet(List<ExportedPackage> exportedPackages) {
        try {
            HashSet<ExportedPackage> packageExports = new HashSet<ExportedPackage>();
            for (ExportedPackage exportPackage : exportedPackages) {
                packageExports.add(exportPackage);
            }
            return packageExports;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void deleteEntry(String targetPath) {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_24);
                this.deleteEntry(this.getBundleFile(), targetPath);
                this.getArtifactFS().getEntry(targetPath).delete();
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_24);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_24);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void deleteEntry(File root, String path) {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_25);
                if (root.isDirectory()) {
                    File f = new File(root, path);
                    if (f.exists() && !f.delete()) {
                        this.logger.warn("Unable to delete resource at {}", (Object)path);
                    }
                } else {
                    this.logger.warn("Unable to delete resource in non-directory location at {}", (Object)root.getAbsolutePath());
                }
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_25);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_25);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void updateEntry(URI inputPath, String targetPath) {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_26);
                this.updateEntry(this.getBundleFile(), inputPath, targetPath);
                this.updateEntry(this.getArtifactFS().getEntry(targetPath), inputPath);
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_26);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_26);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void updateEntry(ArtifactFSEntry entry, URI inputPath) {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_27);
                this.doUpdate(inputPath, entry.getOutputStream(), String.valueOf(entry.getArtifactFS().getFile().getAbsolutePath()) + File.separatorChar + entry.getPath());
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_27);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_27);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void updateEntry(File root, URI inputPath, String targetPath) {
        try {
            try {
                block9: {
                    StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_28);
                    try {
                        if (root.isDirectory()) {
                            FileOutputStream out = null;
                            try {
                                out = new FileOutputStream(new File(root, targetPath));
                                this.doUpdate(inputPath, out, targetPath);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(out);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((Closeable)out);
                            break block9;
                        }
                        this.logger.warn("Unable to update resource in non-directory location at {}", (Object)root.getAbsolutePath());
                    }
                    catch (Exception exception) {
                        this.logger.warn("Unable to update resource at {} with resource at {}", (Object)targetPath, (Object)inputPath.toASCIIString());
                    }
                }
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_28);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_28);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void doUpdate(URI input, OutputStream output, String targetPath) {
        try {
            try {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_29);
                try {
                    InputStream in = input.toURL().openStream();
                    FileCopyUtils.copy((InputStream)in, (OutputStream)output);
                }
                catch (Exception exception) {
                    this.logger.warn("Unable to update resource at {} with resource at {}", (Object)targetPath, (Object)input.toASCIIString());
                }
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_29);
                return;
            }
            catch (Throwable throwable) {
                StandardBundleInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_29);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("StandardBundleInstallArtifact.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "synchronizeBundleSymbolicNameWithIdentity", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "", "void"), 129);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "endInstall", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 213);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "org.eclipse.virgo.nano.core.AbortableSignal:", "signal:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 291);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doStart", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "org.eclipse.virgo.nano.core.AbortableSignal:", "signal:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 311);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 319);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doStop", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 341);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uninstall", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 349);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doUninstall", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 354);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isScoped", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "", "boolean"), 358);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "stopBundleIfNecessary", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "boolean"), 362);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "completeUpdateAndRefresh", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "boolean:", "startRequired:", "", "boolean"), 374);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doRefresh", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "boolean"), 399);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "monitorBundle", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "", "void"), 219);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "startIfNecessary", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "boolean:", "bundleStopped:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 463);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isExportPackageUnchanged", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "org.eclipse.virgo.util.osgi.manifest.BundleManifest:org.eclipse.virgo.util.osgi.manifest.BundleManifest:", "currentBundleManifest:newBundleManifest:", "", "boolean"), 471);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isNameAndVersionUnchanged", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:", "newIdentity:", "", "boolean"), 477);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "refreshScope", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "", "boolean"), 492);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteEntry", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "java.lang.String:", "targetPath:", "", "void"), 530);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteEntry", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "java.io.File:java.lang.String:", "root:path:", "", "void"), 535);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateEntry", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "java.net.URI:java.lang.String:", "inputPath:targetPath:", "", "void"), 546);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateEntry", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry:java.net.URI:", "entry:inputPath:", "", "void"), 551);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateEntry", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "java.io.File:java.net.URI:java.lang.String:", "root:inputPath:targetPath:", "", "void"), 556);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doUpdate", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "java.net.URI:java.io.OutputStream:java.lang.String:", "input:output:targetPath:", "", "void"), 574);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "cacheAndDelete", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "", "void"), 232);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pushThreadContext", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "", "void"), 247);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "popThreadContext", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "", "void"), 255);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "trackStart", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "", "void"), 262);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "beginInstall", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 268);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isFragment", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "", "boolean"), 275);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isFragmentOnSystemBundle", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact", "", "", "", "boolean"), 279);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact");
    }
}

