/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.detector.ServerDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerDetector
implements ServerDetector {
    protected Set<ObjectName> searchMBeans(Set<? extends MBeanServerConnection> pMbeanServers, String pMbeanPattern) {
        try {
            ObjectName oName = new ObjectName(pMbeanPattern);
            for (MBeanServerConnection mBeanServerConnection : pMbeanServers) {
                Set<ObjectName> names = mBeanServerConnection.queryNames(oName, null);
                if (names == null || names.size() <= 0) continue;
                return names;
            }
            return null;
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected boolean mBeanExists(Set<? extends MBeanServerConnection> pMBeanServers, String pObjectName) {
        return this.searchMBeans(pMBeanServers, pObjectName) != null;
    }

    protected String getAttributeValue(Set<? extends MBeanServer> pMbeanServers, String pMBean, String pAttribute) {
        try {
            ObjectName oName = new ObjectName(pMBean);
            return this.getAttributeValue(pMbeanServers, oName, pAttribute);
        }
        catch (JMException e) {
            return null;
        }
    }

    protected String getAttributeValue(Set<? extends MBeanServerConnection> pMbeanServers, ObjectName pMBean, String pAttribute) {
        try {
            for (MBeanServerConnection mBeanServerConnection : pMbeanServers) {
                Object attr = mBeanServerConnection.getAttribute(pMBean, pAttribute);
                if (attr == null) continue;
                return attr.toString();
            }
            return null;
        }
        catch (JMException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected String getSingleStringAttribute(Set<? extends MBeanServerConnection> pMbeanServers, String pMBeanName, String pAttribute) {
        Set<ObjectName> serverMBeanNames = this.searchMBeans(pMbeanServers, pMBeanName);
        if (serverMBeanNames == null || serverMBeanNames.size() == 0) {
            return null;
        }
        HashSet<String> attributeValues = new HashSet<String>();
        for (ObjectName oName : serverMBeanNames) {
            String val = this.getAttributeValue(pMbeanServers, oName, pAttribute);
            if (val == null) continue;
            attributeValues.add(val);
        }
        if (attributeValues.size() == 0 || attributeValues.size() > 1) {
            return null;
        }
        return (String)attributeValues.iterator().next();
    }

    protected String getVersionFromJsr77(Set<MBeanServer> pMbeanServers) {
        Set<ObjectName> names = this.searchMBeans(pMbeanServers, "*:j2eeType=J2EEServer,*");
        if (names != null && names.size() > 0) {
            return this.getAttributeValue(pMbeanServers, names.iterator().next(), "serverVersion");
        }
        return null;
    }

    @Override
    public void addMBeanServers(Set<MBeanServer> pServers) {
    }
}

