/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.cm.ConfigurationAdminFactory;
import org.eclipse.equinox.internal.cm.ConfigurationImpl;
import org.eclipse.equinox.internal.cm.ConfigurationStore;
import org.eclipse.equinox.internal.cm.SerializedTaskQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

class ManagedServiceFactoryTracker
extends ServiceTracker {
    final ConfigurationAdminFactory configurationAdminFactory;
    private final ConfigurationStore configurationStore;
    private final Map managedServiceFactories;
    private final Map managedServiceFactoryReferences;
    private final SerializedTaskQueue queue;
    static /* synthetic */ Class class$0;

    public ManagedServiceFactoryTracker(ConfigurationAdminFactory configurationAdminFactory, ConfigurationStore configurationStore, BundleContext context) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz.getName(), null);
        this.managedServiceFactories = new HashMap();
        this.managedServiceFactoryReferences = new HashMap();
        this.queue = new SerializedTaskQueue("ManagedServiceFactory Update Queue");
        this.configurationAdminFactory = configurationAdminFactory;
        this.configurationStore = configurationStore;
    }

    protected void notifyDeleted(ConfigurationImpl config) {
        config.checkLocked();
        String factoryPid = config.getFactoryPid(false);
        ServiceReference reference = this.getManagedServiceFactoryReference(factoryPid);
        if (reference != null && config.bind(reference.getBundle())) {
            this.asynchDeleted(this.getManagedServiceFactory(factoryPid), config.getPid(false));
        }
    }

    protected void notifyUpdated(ConfigurationImpl config) {
        config.checkLocked();
        String factoryPid = config.getFactoryPid();
        ServiceReference reference = this.getManagedServiceFactoryReference(factoryPid);
        if (reference != null && config.bind(reference.getBundle())) {
            Dictionary properties = config.getProperties();
            this.configurationAdminFactory.modifyConfiguration(reference, properties);
            this.asynchUpdated(this.getManagedServiceFactory(factoryPid), config.getPid(), properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        String factoryPid = (String)reference.getProperty("service.pid");
        if (factoryPid == null) {
            return null;
        }
        ManagedServiceFactory service = (ManagedServiceFactory)this.context.getService(reference);
        if (service == null) {
            return null;
        }
        ConfigurationStore configurationStore = this.configurationStore;
        synchronized (configurationStore) {
            this.add(reference, factoryPid, service);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference reference, Object service) {
        String factoryPid = (String)reference.getProperty("service.pid");
        ConfigurationStore configurationStore = this.configurationStore;
        synchronized (configurationStore) {
            if (this.getManagedServiceFactory(factoryPid) == service) {
                return;
            }
            String previousPid = this.getPidForManagedServiceFactory(service);
            this.remove(reference, previousPid);
            this.addingService(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        String factoryPid = (String)reference.getProperty("service.pid");
        ConfigurationStore configurationStore = this.configurationStore;
        synchronized (configurationStore) {
            this.remove(reference, factoryPid);
        }
        this.context.ungetService(reference);
    }

    /*
     * Unable to fully structure code
     */
    private void add(ServiceReference reference, String factoryPid, ManagedServiceFactory service) {
        configs = this.configurationStore.getFactoryConfigurations(factoryPid);
        try {
            i = 0;
            while (i < configs.length) {
                configs[i].lock();
                ++i;
            }
            if (this.trackManagedServiceFactory(factoryPid, reference, service)) {
                i = 0;
                while (i < configs.length) {
                    if (!configs[i].isDeleted()) {
                        if (configs[i].bind(reference.getBundle())) {
                            properties = configs[i].getProperties();
                            this.configurationAdminFactory.modifyConfiguration(reference, properties);
                            this.asynchUpdated(service, configs[i].getPid(), properties);
                        } else {
                            this.configurationAdminFactory.log(2, "Configuration for service.pid=" + configs[i].getPid() + " could not be bound to " + reference.getBundle().getLocation());
                        }
                    }
                    ++i;
                }
            }
        }
        finally {
            i = 0;
            if (true) ** GOTO lbl30
        }
        {
        }
        do {
            configs[i].unlock();
            ++i;
lbl30:
            // 2 sources

        } while (i < configs.length);
    }

    /*
     * Unable to fully structure code
     */
    private void remove(ServiceReference reference, String factoryPid) {
        configs = this.configurationStore.getFactoryConfigurations(factoryPid);
        try {
            i = 0;
            while (i < configs.length) {
                configs[i].lock();
                ++i;
            }
            this.untrackManagedServiceFactory(factoryPid, reference);
        }
        finally {
            i = 0;
            ** while (i < configs.length)
        }
lbl-1000:
        // 1 sources

        {
            configs[i].unlock();
            ++i;
            continue;
        }
lbl16:
        // 1 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean trackManagedServiceFactory(String factoryPid, ServiceReference reference, ManagedServiceFactory service) {
        Map map = this.managedServiceFactoryReferences;
        synchronized (map) {
            block7: {
                if (!this.managedServiceFactoryReferences.containsKey(factoryPid)) break block7;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.configurationAdminFactory.log(2, String.valueOf(clazz.getName()) + " already registered for " + "service.pid" + "=" + factoryPid);
                return false;
            }
            this.managedServiceFactoryReferences.put(factoryPid, reference);
            this.managedServiceFactories.put(factoryPid, service);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrackManagedServiceFactory(String factoryPid, ServiceReference reference) {
        Map map = this.managedServiceFactoryReferences;
        synchronized (map) {
            this.managedServiceFactoryReferences.remove(factoryPid);
            this.managedServiceFactories.remove(factoryPid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedServiceFactory getManagedServiceFactory(String factoryPid) {
        Map map = this.managedServiceFactoryReferences;
        synchronized (map) {
            return (ManagedServiceFactory)this.managedServiceFactories.get(factoryPid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceReference getManagedServiceFactoryReference(String factoryPid) {
        Map map = this.managedServiceFactoryReferences;
        synchronized (map) {
            return (ServiceReference)this.managedServiceFactoryReferences.get(factoryPid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPidForManagedServiceFactory(Object service) {
        Map map = this.managedServiceFactoryReferences;
        synchronized (map) {
            Iterator it = this.managedServiceFactories.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (entry.getValue() != service) continue;
                return (String)entry.getKey();
            }
            return null;
        }
    }

    private void asynchDeleted(final ManagedServiceFactory service, final String pid) {
        this.queue.put(new Runnable(){

            public void run() {
                try {
                    service.deleted(pid);
                }
                catch (Throwable t) {
                    ManagedServiceFactoryTracker.this.configurationAdminFactory.log(1, t.getMessage(), t);
                }
            }
        });
    }

    private void asynchUpdated(final ManagedServiceFactory service, final String pid, final Dictionary properties) {
        this.queue.put(new Runnable(){

            public void run() {
                try {
                    service.updated(pid, properties);
                }
                catch (ConfigurationException e) {
                    Throwable cause = e.getCause();
                    ManagedServiceFactoryTracker.this.configurationAdminFactory.log(1, e.getMessage(), cause != null ? cause : e);
                }
                catch (Throwable t) {
                    ManagedServiceFactoryTracker.this.configurationAdminFactory.log(1, t.getMessage(), t);
                }
            }
        });
    }
}

