/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.bosch.things.javaclient.templates;

import com.google.common.base.Objects;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.bosch.things.javaclient.TypeMapper;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ThingsClientTemplate
implements ITemplate<InformationModel> {
    public String getContent(InformationModel model, InvocationContext context) {
        String _xblockexpression = null;
        Map properties = context.getConfigurationProperties();
        String _elvis = null;
        String _get = (String)properties.get("thingId");
        _elvis = _get != null ? _get : "Please add Things Id";
        String thingid = _elvis;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package com.example.things;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.ExecutionException;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.TimeUnit;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.TimeoutException;");
        _builder.newLine();
        _builder.append((Object)"import java.util.function.Function;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.Logger;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.LoggerFactory;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import com.bosch.cr.integration.IntegrationClient;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.cr.integration.things.FeatureHandle;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.cr.integration.things.ThingHandle;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.cr.integration.things.ThingIntegration;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.cr.json.JsonObject;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.cr.model.things.Feature;");
        _builder.newLine();
        _builder.append((Object)"import com.example.things.functionblocks.*;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import java.text.DateFormat;");
        _builder.newLine();
        _builder.append((Object)"import java.text.SimpleDateFormat;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* This example shows how to create and use the Java Integration Client for");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* managing your Thing.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = model.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"ThingsClient {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private static final Logger LOGGER = LoggerFactory.getLogger(");
        String _name_1 = model.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append((Object)"ThingsClient.class);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private static final String THING_ID = \"");
        _builder.append((Object)thingid, "    ");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private static final int TIMEOUT = 5;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"static final DateFormat JSON_DATE_FORMAT = new SimpleDateFormat(\"yyyy-MM-dd HH:mm:ssZ\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static void main(final String... args) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"new ");
        String _name_2 = model.getName();
        _builder.append((Object)_name_2, "        ");
        _builder.append((Object)"ThingsClient().execute();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* Periodically update a thing with the java client.");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public void execute() {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"IntegrationClient thingClient = ThingClientFactory.getThingIntegrationClient();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"ThingIntegration thingIntegration = thingClient.things();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"ThingHandle thingHandle = thingIntegration.forId(THING_ID);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"// Test if the thing exist, exceptions will be thrown if it doesn't");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"thingHandle.retrieve().get(TIMEOUT, TimeUnit.SECONDS);");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"// Loop to update the attributes of the Thing");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"for(int i = 0; i <= 100; i++) {");
        _builder.newLine();
        EList _properties = model.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append((Object)"                ");
            _builder.append((Object)"update");
            String _name_3 = fbProperty.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_3);
            _builder.append((Object)_firstUpper, "                ");
            _builder.append((Object)"(thingHandle, get");
            String _name_4 = fbProperty.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_4);
            _builder.append((Object)_firstUpper_1, "                ");
            _builder.append((Object)"());");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"                ");
        _builder.append((Object)"Thread.sleep(2000);");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} catch (InterruptedException | ExecutionException | TimeoutException e) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"LOGGER.info(e.getMessage());");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} finally {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"// Terminate the Java client");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"thingClient.destroy();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        EList _properties_1 = model.getProperties();
        for (FunctionblockProperty fbProperty_1 : _properties_1) {
            _builder.append((Object)"    ");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)" ");
            _builder.append((Object)"* Modify this code to retrieve actual sensor reading");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"private ");
            FunctionblockModel _type = fbProperty_1.getType();
            String _name_5 = _type.getName();
            _builder.append((Object)_name_5, "    ");
            _builder.append((Object)" get");
            String _name_6 = fbProperty_1.getName();
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_6);
            _builder.append((Object)_firstUpper_2, "    ");
            _builder.append((Object)"()  {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"\t");
            FunctionblockModel _type_1 = fbProperty_1.getType();
            String _name_7 = _type_1.getName();
            _builder.append((Object)_name_7, "    \t");
            _builder.append((Object)" ");
            String _name_8 = fbProperty_1.getName();
            _builder.append((Object)_name_8, "    \t");
            _builder.append((Object)" = new ");
            FunctionblockModel _type_2 = fbProperty_1.getType();
            String _name_9 = _type_2.getName();
            _builder.append((Object)_name_9, "    \t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            boolean _and = false;
            boolean _and_1 = false;
            FunctionblockModel _type_3 = fbProperty_1.getType();
            String _namespace = _type_3.getNamespace();
            boolean _equals = Objects.equal((Object)_namespace, (Object)"com.ipso.smartobjects");
            if (!_equals) {
                _and_1 = false;
            } else {
                boolean _equals_1;
                FunctionblockModel _type_4 = fbProperty_1.getType();
                String _name_10 = _type_4.getName();
                _and_1 = _equals_1 = Objects.equal((Object)_name_10, (Object)"Location");
            }
            if (!_and_1) {
                _and = false;
            } else {
                boolean _equals_2;
                FunctionblockModel _type_5 = fbProperty_1.getType();
                String _version = _type_5.getVersion();
                _and = _equals_2 = Objects.equal((Object)_version, (Object)"0.0.1");
            }
            if (_and) {
                _builder.append((Object)"    ");
                _builder.append((Object)"\t");
                String _name_11 = fbProperty_1.getName();
                _builder.append((Object)_name_11, "    \t");
                _builder.append((Object)".setLatitude(\"");
                _builder.append((Object)1.0, "    \t");
                _builder.append((Object)"\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"\t");
                String _name_12 = fbProperty_1.getName();
                _builder.append((Object)_name_12, "    \t");
                _builder.append((Object)".setLongitude(\"");
                _builder.append((Object)1.0, "    \t");
                _builder.append((Object)"\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"\t");
                String _name_13 = fbProperty_1.getName();
                _builder.append((Object)_name_13, "    \t");
                _builder.append((Object)".setUncertainty(\"\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"\t");
                String _name_14 = fbProperty_1.getName();
                _builder.append((Object)_name_14, "    \t");
                _builder.append((Object)".setCompass_direction(new java.util.Random().nextFloat());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"\t");
                String _name_15 = fbProperty_1.getName();
                _builder.append((Object)_name_15, "    \t");
                _builder.append((Object)".setVelocity((byte) new java.util.Random().nextInt(100));");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"\t");
                String _name_16 = fbProperty_1.getName();
                _builder.append((Object)_name_16, "    \t");
                _builder.append((Object)".setTimestamp(new java.util.Date());");
                _builder.newLineIfNotEmpty();
            } else {
                FunctionblockModel _type_6 = fbProperty_1.getType();
                FunctionBlock _functionblock = _type_6.getFunctionblock();
                Status _status = _functionblock.getStatus();
                EList _properties_2 = _status.getProperties();
                for (Property statusProperty : _properties_2) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"\t");
                    String _name_17 = fbProperty_1.getName();
                    _builder.append((Object)_name_17, "    \t");
                    _builder.append((Object)".set");
                    String _name_18 = statusProperty.getName();
                    String _checkKeyword = TypeMapper.checkKeyword(_name_18);
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)_checkKeyword);
                    _builder.append((Object)_firstUpper_3, "    \t");
                    _builder.append((Object)"(");
                    PropertyType _type_7 = statusProperty.getType();
                    String _randomValue = TypeMapper.getRandomValue(_type_7);
                    _builder.append((Object)_randomValue, "    \t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"return ");
            String _name_19 = fbProperty_1.getName();
            _builder.append((Object)_name_19, "        ");
            _builder.append((Object)"; ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)" ");
            _builder.append((Object)"* Update ");
            FunctionblockModel _type_8 = fbProperty_1.getType();
            String _name_20 = _type_8.getName();
            _builder.append((Object)_name_20, "     ");
            _builder.append((Object)" Feature");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"private void update");
            String _name_21 = fbProperty_1.getName();
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_21);
            _builder.append((Object)_firstUpper_4, "    ");
            _builder.append((Object)"(ThingHandle thingHandle, ");
            FunctionblockModel _type_9 = fbProperty_1.getType();
            String _name_22 = _type_9.getName();
            _builder.append((Object)_name_22, "    ");
            _builder.append((Object)" fb) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"String featureId = \"");
            String _name_23 = fbProperty_1.getName();
            _builder.append((Object)_name_23, "        ");
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"FeatureHandle featureHandle = thingHandle.forFeature(featureId);");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"try {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"        ");
            _builder.append((Object)"featureHandle.retrieve()");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"            ");
            _builder.append((Object)".exceptionally(addMissingFeature(thingHandle, featureId))");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"            ");
            _builder.append((Object)".thenCompose(feature -> {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"                ");
            _builder.append((Object)"return featureHandle.putProperty(\"status\", JsonObject.newBuilder()");
            _builder.newLine();
            FunctionblockModel _type_10 = fbProperty_1.getType();
            FunctionBlock _functionblock_1 = _type_10.getFunctionblock();
            Status _status_1 = _functionblock_1.getStatus();
            EList _properties_3 = _status_1.getProperties();
            for (Property statusProperty_1 : _properties_3) {
                boolean _and_2 = false;
                PropertyType _type_11 = statusProperty_1.getType();
                if (!(_type_11 instanceof PrimitivePropertyType)) {
                    _and_2 = false;
                } else {
                    boolean _equals_3;
                    PropertyType _type_12 = statusProperty_1.getType();
                    PrimitiveType _type_13 = ((PrimitivePropertyType)_type_12).getType();
                    _and_2 = _equals_3 = Objects.equal((Object)_type_13, (Object)PrimitiveType.DATETIME);
                }
                if (_and_2) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"                    ");
                    _builder.append((Object)".set(\"");
                    String _name_24 = statusProperty_1.getName();
                    _builder.append((Object)_name_24, "                        ");
                    _builder.append((Object)"\", JSON_DATE_FORMAT.format(fb.get");
                    String _name_25 = statusProperty_1.getName();
                    String _checkKeyword_1 = TypeMapper.checkKeyword(_name_25);
                    String _firstUpper_5 = StringExtensions.toFirstUpper((String)_checkKeyword_1);
                    _builder.append((Object)_firstUpper_5, "                        ");
                    _builder.append((Object)"()))");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"    ");
                _builder.append((Object)"                    ");
                _builder.append((Object)".set(\"");
                String _name_26 = statusProperty_1.getName();
                _builder.append((Object)_name_26, "                        ");
                _builder.append((Object)"\", fb.get");
                String _name_27 = statusProperty_1.getName();
                String _checkKeyword_2 = TypeMapper.checkKeyword(_name_27);
                String _firstUpper_6 = StringExtensions.toFirstUpper((String)_checkKeyword_2);
                _builder.append((Object)_firstUpper_6, "                        ");
                _builder.append((Object)"())");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"                    ");
            _builder.append((Object)".build());");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"             ");
            _builder.append((Object)"}).whenComplete((aVoid, throwable) -> {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"                 ");
            _builder.append((Object)"if (null == throwable) {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"                     ");
            _builder.append((Object)"LOGGER.info(\"Thing with ID '{}' feature ");
            FunctionblockModel _type_14 = fbProperty_1.getType();
            String _name_28 = _type_14.getName();
            _builder.append((Object)_name_28, "                         ");
            _builder.append((Object)" was updated.\", THING_ID);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"                 ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"                 ");
            _builder.append((Object)"else {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"                     ");
            _builder.append((Object)"LOGGER.error(throwable.getMessage());");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"                 ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"             ");
            _builder.append((Object)"}).get(TIMEOUT, TimeUnit.SECONDS);");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"} catch (InterruptedException | ExecutionException | TimeoutException e) {");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"        ");
            _builder.append((Object)"e.printStackTrace();");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"        ");
            _builder.append((Object)"throw new RuntimeException(e);");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.newLine();
        }
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private Function<Throwable, Feature> addMissingFeature(ThingHandle thingHandle, String featureId) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return throwable -> {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"LOGGER.info(\"Creating the feature first because it's missing\");");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"Feature feature = Feature.newBuilder().withId(featureId).build();");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"return thingHandle.putFeature(feature)");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)".thenCompose(aVoid -> thingHandle.forFeature(featureId).retrieve())");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)".get(TIMEOUT, TimeUnit.SECONDS);");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"} catch (Exception e) {");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"e.printStackTrace();");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }
}

