/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.functionblock.tests.validator;

import com.google.inject.Injector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.ConstraintIntervalType;
import org.eclipse.vorto.core.api.model.datatype.ConstraintRule;
import org.eclipse.vorto.core.api.model.datatype.DatatypeFactory;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.editor.datatype.internal.validation.ConstraintValueValidator;
import org.eclipse.vorto.editor.datatype.validation.ConstraintValidatorFactory;
import org.eclipse.vorto.editor.datatype.validation.PropertyConstraintMappingValidation;
import org.eclipse.vorto.editor.functionblock.FunctionblockStandaloneSetup;
import org.eclipse.vorto.editor.functionblock.validation.FunctionblockValidator;
import org.eclipse.xtext.junit4.AbstractXtextTests;
import org.eclipse.xtext.junit4.validation.AssertableDiagnostics;
import org.eclipse.xtext.junit4.validation.ValidatorTester;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.junit.Assert;
import org.junit.Test;

public class FbConstraintValidationTest
extends AbstractXtextTests {
    private ValidatorTester<FunctionblockValidator> tester;

    public void setUp() throws Exception {
        ValidatorTester _validatorTester;
        super.setUp();
        this.with(FunctionblockStandaloneSetup.class);
        FunctionblockValidator validator = (FunctionblockValidator)this.get(FunctionblockValidator.class);
        Injector _injector = this.getInjector();
        this.tester = _validatorTester = new ValidatorTester((AbstractDeclarativeValidator)validator, _injector);
    }

    @Test
    public void test_Constraint_INT_IntValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.INT);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MAX);
        constraint1.setConstraintValues("22");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        Constraint constraint2 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint2.setType(ConstraintIntervalType.MIN);
        constraint2.setConstraintValues("1");
        ConstraintRule _constraintRule_1 = prop.getConstraintRule();
        EList _constraints_1 = _constraintRule_1.getConstraints();
        _constraints_1.add((Object)constraint2);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.INT, constraint1);
        Assert.assertTrue((boolean)_evaluateValueType);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"", (Object)_errorMessage);
        ConstraintIntervalType _type_1 = constraint1.getType();
        ConstraintValueValidator validator2 = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type_1);
        boolean _evaluateValueType_1 = validator2.evaluateValueType(PrimitiveType.INT, constraint2);
        Assert.assertTrue((boolean)_evaluateValueType_1);
        String _errorMessage_1 = validator2.getErrorMessage();
        Assert.assertEquals((Object)"", (Object)_errorMessage_1);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Constraint_Float_FloatValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.FLOAT);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MAX);
        constraint1.setConstraintValues("2.2");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        Constraint constraint2 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint2.setType(ConstraintIntervalType.MIN);
        constraint2.setConstraintValues("1");
        ConstraintRule _constraintRule_1 = prop.getConstraintRule();
        EList _constraints_1 = _constraintRule_1.getConstraints();
        _constraints_1.add((Object)constraint2);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator1 = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator1.evaluateValueType(PrimitiveType.FLOAT, constraint1);
        Assert.assertTrue((boolean)_evaluateValueType);
        String _errorMessage = validator1.getErrorMessage();
        Assert.assertEquals((Object)"", (Object)_errorMessage);
        ConstraintIntervalType _type_1 = constraint1.getType();
        ConstraintValueValidator validator2 = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type_1);
        boolean _evaluateValueType_1 = validator2.evaluateValueType(PrimitiveType.FLOAT, constraint2);
        Assert.assertTrue((boolean)_evaluateValueType_1);
        String _errorMessage_1 = validator2.getErrorMessage();
        Assert.assertEquals((Object)"", (Object)_errorMessage_1);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Constraint_String_StrValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.STRING);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.REGEX);
        constraint1.setConstraintValues("[A..B]");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        Constraint constraint2 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint2.setType(ConstraintIntervalType.STRLEN);
        constraint2.setConstraintValues("11");
        ConstraintRule _constraintRule_1 = prop.getConstraintRule();
        EList _constraints_1 = _constraintRule_1.getConstraints();
        _constraints_1.add((Object)constraint2);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator1 = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator1.evaluateValueType(PrimitiveType.STRING, constraint1);
        Assert.assertTrue((boolean)_evaluateValueType);
        String _errorMessage = validator1.getErrorMessage();
        Assert.assertEquals((Object)"", (Object)_errorMessage);
        ConstraintIntervalType _type_1 = constraint1.getType();
        ConstraintValueValidator validator2 = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type_1);
        boolean _evaluateValueType_1 = validator2.evaluateValueType(PrimitiveType.STRING, constraint2);
        Assert.assertTrue((boolean)_evaluateValueType_1);
        String _errorMessage_1 = validator2.getErrorMessage();
        Assert.assertEquals((Object)"", (Object)_errorMessage_1);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Constraint_Datetime_DtValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.DATETIME);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MAX);
        constraint1.setConstraintValues("2002-05-30T09:30:10+06:00");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        Constraint constraint2 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint2.setType(ConstraintIntervalType.MIN);
        constraint2.setConstraintValues("2002-04-30T01:30:10+06:00");
        ConstraintRule _constraintRule_1 = prop.getConstraintRule();
        EList _constraints_1 = _constraintRule_1.getConstraints();
        _constraints_1.add((Object)constraint2);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator1 = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        PropertyType _type_1 = prop.getType();
        PrimitiveType _type_2 = ((PrimitivePropertyType)_type_1).getType();
        boolean _evaluateValueType = validator1.evaluateValueType(_type_2, constraint1);
        Assert.assertTrue((boolean)_evaluateValueType);
        String _errorMessage = validator1.getErrorMessage();
        Assert.assertEquals((Object)"", (Object)_errorMessage);
        ConstraintIntervalType _type_3 = constraint1.getType();
        ConstraintValueValidator validator2 = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type_3);
        PrimitiveType _type_4 = primi.getType();
        boolean _evaluateValueType_1 = validator2.evaluateValueType(_type_4, constraint2);
        Assert.assertTrue((boolean)_evaluateValueType_1);
        String _errorMessage_1 = validator2.getErrorMessage();
        Assert.assertEquals((Object)"", (Object)_errorMessage_1);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Constraint_Datetime_Wrong_DtValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.DATETIME);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MAX);
        constraint1.setConstraintValues("2002-05-30T09:30:10");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator1 = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        PrimitiveType _type_1 = primi.getType();
        boolean _evaluateValueType = validator1.evaluateValueType(_type_1, constraint1);
        Assert.assertFalse((boolean)_evaluateValueType);
        String _errorMessage = validator1.getErrorMessage();
        Assert.assertEquals((Object)"Value expected should be in ISO 8196 Date Format e.g: 2002-05-30T09:30:10+06:00", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Value expected should be in ISO 8196 Date Format e.g: 2002-05-30T09:30:10+06:00");
    }

    @Test
    public void test_Constraint_Boolean_NoConstraint() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.BOOLEAN);
        prop.setType((PropertyType)primi);
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Constraint_INT_MAX_StrValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.INT);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MAX);
        constraint1.setConstraintValues("abc");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.INT, constraint1);
        Assert.assertFalse((boolean)_evaluateValueType);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"This constraint value must be of an Integer", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("This constraint value must be of an Integer");
    }

    @Test
    public void test_Constraint_Float_MAX_StrValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.FLOAT);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MAX);
        constraint1.setConstraintValues("abc");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.FLOAT, constraint1);
        Assert.assertFalse((boolean)_evaluateValueType);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"This constraint value must be of a Float", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("This constraint value must be of a Float");
    }

    @Test
    public void test_Constraint_DateTime_MIN_IntValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.DATETIME);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MIN);
        constraint1.setConstraintValues("211");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.DATETIME, constraint1);
        Assert.assertFalse((boolean)_evaluateValueType);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"Value expected should be in ISO 8196 Date Format e.g: 2002-05-30T09:30:10+06:00", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Value expected should be in ISO 8196 Date Format e.g: 2002-05-30T09:30:10+06:00");
    }

    @Test
    public void test_Constraint_Str_StrLen_FloatValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.STRING);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.STRLEN);
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        constraint1.setConstraintValues("21.1");
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.STRING, constraint1);
        Assert.assertFalse((boolean)_evaluateValueType);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"This constraint value must be of an Integer", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("This constraint value must be of an Integer");
    }

    @Test
    public void test_Constraint_Boolean_Max_StrValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.BOOLEAN);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MAX);
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        constraint1.setConstraintValues("sadfasfa");
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.STRING, constraint1);
        Assert.assertTrue((boolean)_evaluateValueType);
        PropertyConstraintMappingValidation validat = new PropertyConstraintMappingValidation();
        boolean _checkPropertyConstraints = validat.checkPropertyConstraints(PrimitiveType.BOOLEAN, constraint1);
        Assert.assertFalse((boolean)_checkPropertyConstraints);
        String _errorMessage = validat.getErrorMessage();
        Assert.assertEquals((Object)"Constraint cannot apply on this property's datatype", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Constraint cannot apply on this property's datatype");
    }

    @Test
    public void test_Constraint_StringProperty_MIN() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.STRING);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MIN);
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        PropertyConstraintMappingValidation validator = new PropertyConstraintMappingValidation();
        boolean _checkPropertyConstraints = validator.checkPropertyConstraints(PrimitiveType.STRING, constraint1);
        Assert.assertFalse((boolean)_checkPropertyConstraints);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"Constraint cannot apply on this property's datatype", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Constraint cannot apply on this property's datatype");
    }

    @Test
    public void test_Constraint_IntProperty_RegeX() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.INT);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.REGEX);
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        PropertyConstraintMappingValidation validator = new PropertyConstraintMappingValidation();
        boolean _checkPropertyConstraints = validator.checkPropertyConstraints(PrimitiveType.INT, constraint1);
        Assert.assertFalse((boolean)_checkPropertyConstraints);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"Constraint cannot apply on this property's datatype", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Constraint cannot apply on this property's datatype");
    }

    @Test
    public void test_Constraint_IntProperty_Max_NegValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.INT);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MAX);
        constraint1.setConstraintValues("-1111");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        PropertyConstraintMappingValidation validator = new PropertyConstraintMappingValidation();
        boolean _checkPropertyConstraints = validator.checkPropertyConstraints(PrimitiveType.INT, constraint1);
        Assert.assertTrue((boolean)_checkPropertyConstraints);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Constraint_BoolProperty_Min() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.BOOLEAN);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MIN);
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        PropertyConstraintMappingValidation validator = new PropertyConstraintMappingValidation();
        boolean _checkPropertyConstraints = validator.checkPropertyConstraints(PrimitiveType.BOOLEAN, constraint1);
        Assert.assertFalse((boolean)_checkPropertyConstraints);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"Constraint cannot apply on this property's datatype", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Constraint cannot apply on this property's datatype");
    }

    @Test
    public void test_Constraint_ShortProperty_MAX_StrValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.SHORT);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MAX);
        constraint1.setConstraintValues("abc");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.SHORT, constraint1);
        Assert.assertFalse((boolean)_evaluateValueType);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"This constraint value must be of a Short", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("This constraint value must be of a Short");
    }

    @Test
    public void test_Constraint_ShortProperty_MIN_OutOfRange() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.SHORT);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MIN);
        constraint1.setConstraintValues("32800");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.SHORT, constraint1);
        Assert.assertFalse((boolean)_evaluateValueType);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"This constraint value must be of a Short", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("This constraint value must be of a Short");
    }

    @Test
    public void test_Constraint_ShortProperty_MAX_OutOfRange_Negative() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.SHORT);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        constraint1.setType(ConstraintIntervalType.MAX);
        constraint1.setConstraintValues("-32800");
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.SHORT, constraint1);
        Assert.assertFalse((boolean)_evaluateValueType);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"This constraint value must be of a Short", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("This constraint value must be of a Short");
    }

    @Test
    public void test_Constraint_ShortProperty_MIN_NegValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.SHORT);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MIN);
        constraint1.setConstraintValues("-111");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.SHORT, constraint1);
        Assert.assertTrue((boolean)_evaluateValueType);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Constraint_LongProperty_RegeX() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.LONG);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.REGEX);
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        PropertyConstraintMappingValidation validator = new PropertyConstraintMappingValidation();
        boolean _checkPropertyConstraints = validator.checkPropertyConstraints(PrimitiveType.LONG, constraint1);
        Assert.assertFalse((boolean)_checkPropertyConstraints);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"Constraint cannot apply on this property's datatype", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Constraint cannot apply on this property's datatype");
    }

    @Test
    public void test_Constraint_Base64BinaryProperty_NoConstraint() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.BASE64_BINARY);
        prop.setType((PropertyType)primi);
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Constraint_Base64BinaryProperty_Min() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.BASE64_BINARY);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MIN);
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        PropertyConstraintMappingValidation validator = new PropertyConstraintMappingValidation();
        PrimitiveType _type = primi.getType();
        boolean _checkPropertyConstraints = validator.checkPropertyConstraints(_type, constraint1);
        Assert.assertFalse((boolean)_checkPropertyConstraints);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"Constraint cannot apply on this property's datatype", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Constraint cannot apply on this property's datatype");
    }

    @Test
    public void test_Constraint_DoubleProperty_Strlen() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.DOUBLE);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.STRLEN);
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        PropertyConstraintMappingValidation validator = new PropertyConstraintMappingValidation();
        boolean _checkPropertyConstraints = validator.checkPropertyConstraints(PrimitiveType.DOUBLE, constraint1);
        Assert.assertFalse((boolean)_checkPropertyConstraints);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"Constraint cannot apply on this property's datatype", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Constraint cannot apply on this property's datatype");
    }

    @Test
    public void test_Constraint_DoubleProperty_Max_NegValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.DOUBLE);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MAX);
        constraint1.setConstraintValues("-11.11");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        PropertyConstraintMappingValidation validator = new PropertyConstraintMappingValidation();
        boolean _checkPropertyConstraints = validator.checkPropertyConstraints(PrimitiveType.DOUBLE, constraint1);
        Assert.assertTrue((boolean)_checkPropertyConstraints);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Constraint_ByteProperty_MAX_StrValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.BYTE);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        constraint1.setType(ConstraintIntervalType.MAX);
        constraint1.setConstraintValues("abc");
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.BYTE, constraint1);
        Assert.assertFalse((boolean)_evaluateValueType);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"This constraint value must be of a Byte", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("This constraint value must be of a Byte");
    }

    @Test
    public void test_Constraint_ByteProperty_MIN_OutOfRange() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.BYTE);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MIN);
        constraint1.setConstraintValues("128");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.BYTE, constraint1);
        Assert.assertFalse((boolean)_evaluateValueType);
        String _errorMessage = validator.getErrorMessage();
        Assert.assertEquals((Object)"This constraint value must be of a Byte", (Object)_errorMessage);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("This constraint value must be of a Byte");
    }

    @Test
    public void test_Constraint_ByteProperty_MIN_NegValue() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.BYTE);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        constraint1.setType(ConstraintIntervalType.MIN);
        constraint1.setConstraintValues("-128");
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.BYTE, constraint1);
        Assert.assertTrue((boolean)_evaluateValueType);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Constraint_MultipleByteProperty_MIMETYPE_positiveVal() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.BYTE);
        prop.setType((PropertyType)primi);
        prop.setMultiplicity(true);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MIMETYPE);
        constraint1.setConstraintValues("testing");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.BYTE, constraint1);
        Assert.assertTrue((boolean)_evaluateValueType);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Constraint_ByteProperty_MIMETYPE_ONlyAllowedForByteArr() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.BYTE);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MIMETYPE);
        constraint1.setConstraintValues("testing");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.BYTE, constraint1);
        Assert.assertTrue((boolean)_evaluateValueType);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("MIMEType only applies to byte array, have you forgotten to add 'multiple' ?");
    }

    @Test
    public void test_Constraint_DoubleProperty_MIMETYPE() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.DOUBLE);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MIMETYPE);
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        constraint1.setConstraintValues("testing");
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.BYTE, constraint1);
        Assert.assertTrue((boolean)_evaluateValueType);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Constraint cannot apply on this property's datatype");
    }

    @Test
    public void test_Constraint_Base64binaryProperty_MIMETYPE_positiveVal() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.BASE64_BINARY);
        prop.setType((PropertyType)primi);
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.MIMETYPE);
        constraint1.setConstraintValues("testing");
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        ConstraintIntervalType _type = constraint1.getType();
        ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
        boolean _evaluateValueType = validator.evaluateValueType(PrimitiveType.BYTE, constraint1);
        Assert.assertTrue((boolean)_evaluateValueType);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }
}

