/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.dnd.dropaction;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.repository.IModelRepository;
import org.eclipse.vorto.core.api.repository.ModelRepositoryFactory;
import org.eclipse.vorto.core.api.repository.ModelResource;
import org.eclipse.vorto.core.api.repository.RepositoryException;
import org.eclipse.vorto.core.ui.MessageDisplayFactory;
import org.eclipse.vorto.core.ui.exception.ExceptionHandlerFactory;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.perspective.dnd.IDropAction;

public class AddSharedReferenceDropAction
implements IDropAction<IModelElement, ModelResource> {
    private Class<?> droppedObjectClass = null;
    private IModelRepository modelRepo = ModelRepositoryFactory.getModelRepository();

    public AddSharedReferenceDropAction(Class<?> droppedObjectClass) {
        this.droppedObjectClass = droppedObjectClass;
    }

    @Override
    public IModelElement performDrop(IModelElement receivingModelElement, ModelResource modelElementToBeDropped) {
        if (this.droppedObjectClass.isInstance(modelElementToBeDropped) && !receivingModelElement.equals(modelElementToBeDropped)) {
            IModelElement modelToAddAsReference = this.downloadAndSaveModel(receivingModelElement.getProject(), modelElementToBeDropped.getId());
            if (this.canAddAsReference(receivingModelElement.getModel(), modelToAddAsReference.getModel())) {
                receivingModelElement.addModelReference(modelToAddAsReference.getId());
            }
            receivingModelElement.save();
            return receivingModelElement;
        }
        return null;
    }

    private boolean canAddAsReference(Model receivingModel, Model modelToAdd) {
        if (receivingModel instanceof Entity || receivingModel instanceof FunctionblockModel) {
            return modelToAdd instanceof Enum || modelToAdd instanceof Entity;
        }
        if (receivingModel instanceof InformationModel) {
            return modelToAdd instanceof FunctionblockModel;
        }
        return false;
    }

    private IModelElement downloadAndSaveModel(IModelProject project, ModelId modelId) {
        try {
            ModelResource model = this.modelRepo.getModel(modelId);
            if (model != null) {
                for (ModelId reference : model.getReferences()) {
                    this.downloadAndSaveModel(project, reference);
                }
                MessageDisplayFactory.getMessageDisplay().display("Downloading " + modelId.toString());
                byte[] modelContent = this.modelRepo.downloadContent(model.getId());
                return project.addModelElement(model.getId(), (InputStream)new ByteArrayInputStream(modelContent));
            }
            MessageDisplayFactory.getMessageDisplay().displayError("Model " + modelId.toString() + " not found in repository.");
        }
        catch (RepositoryException e) {
            ExceptionHandlerFactory.getHandler().handle((Throwable)e);
        }
        return null;
    }
}

