/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.datatype.internal.validation;

import com.google.common.base.Objects;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.editor.datatype.internal.validation.ConstraintValueValidator;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class AccordinglyValueValidator
extends ConstraintValueValidator {
    @Override
    public boolean evaluateValueType(PrimitiveType type, Constraint constraint) {
        boolean _xblockexpression = false;
        String rawValue = constraint.getConstraintValues();
        String typeStr = type.getLiteral();
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)typeStr, (Object)"int")) {
            _matched = true;
            try {
                Integer.parseInt(rawValue);
            }
            catch (Throwable _t) {
                if (_t instanceof NumberFormatException) {
                    NumberFormatException cfr_ignored_0 = (NumberFormatException)_t;
                    this.setErrorMessage("This constraint value must be of an Integer");
                    return false;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        if (!_matched && Objects.equal((Object)typeStr, (Object)"long")) {
            _matched = true;
            try {
                Long.parseLong(rawValue);
            }
            catch (Throwable _t_1) {
                if (_t_1 instanceof NumberFormatException) {
                    NumberFormatException cfr_ignored_1 = (NumberFormatException)_t_1;
                    this.setErrorMessage("This constraint value must be of a Long");
                    return false;
                }
                throw Exceptions.sneakyThrow((Throwable)_t_1);
            }
        }
        if (!_matched && Objects.equal((Object)typeStr, (Object)"short")) {
            _matched = true;
            try {
                Short.parseShort(rawValue);
            }
            catch (Throwable _t_2) {
                if (_t_2 instanceof NumberFormatException) {
                    NumberFormatException cfr_ignored_2 = (NumberFormatException)_t_2;
                    this.setErrorMessage("This constraint value must be of a Short");
                    return false;
                }
                throw Exceptions.sneakyThrow((Throwable)_t_2);
            }
        }
        if (!_matched && Objects.equal((Object)typeStr, (Object)"double")) {
            _matched = true;
            try {
                Double.parseDouble(rawValue);
            }
            catch (Throwable _t_3) {
                if (_t_3 instanceof NumberFormatException) {
                    NumberFormatException cfr_ignored_3 = (NumberFormatException)_t_3;
                    this.setErrorMessage("This constraint value must be of a Double");
                    return false;
                }
                throw Exceptions.sneakyThrow((Throwable)_t_3);
            }
        }
        if (!_matched && Objects.equal((Object)typeStr, (Object)"float")) {
            _matched = true;
            try {
                Float.parseFloat(rawValue);
            }
            catch (Throwable _t_4) {
                if (_t_4 instanceof NumberFormatException) {
                    NumberFormatException cfr_ignored_4 = (NumberFormatException)_t_4;
                    this.setErrorMessage("This constraint value must be of a Float");
                    return false;
                }
                throw Exceptions.sneakyThrow((Throwable)_t_4);
            }
        }
        if (!_matched && Objects.equal((Object)typeStr, (Object)"dateTime")) {
            _matched = true;
            try {
                SimpleDateFormat _simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
                _simpleDateFormat.parse(rawValue);
            }
            catch (Throwable _t_5) {
                if (_t_5 instanceof ParseException) {
                    ParseException cfr_ignored_5 = (ParseException)_t_5;
                    this.setErrorMessage("Value expected should be in ISO 8196 Date Format e.g: 2002-05-30T09:30:10+06:00");
                    return false;
                }
                throw Exceptions.sneakyThrow((Throwable)_t_5);
            }
        }
        if (!_matched && Objects.equal((Object)typeStr, (Object)"byte")) {
            _matched = true;
            try {
                Byte.parseByte(rawValue);
            }
            catch (Throwable _t_6) {
                if (_t_6 instanceof NumberFormatException) {
                    NumberFormatException cfr_ignored_6 = (NumberFormatException)_t_6;
                    this.setErrorMessage("This constraint value must be of a Byte");
                    return false;
                }
                throw Exceptions.sneakyThrow((Throwable)_t_6);
            }
        }
        _xblockexpression = true;
        return _xblockexpression;
    }
}

