/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.api.model.datatype;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PropertyAttributeType implements Enumerator
{
    MEASUREMENT_UNIT(1, "MeasurementUnit", "MEASUREMENTUNIT"),
    READABLE(2, "Readable", "READABLE"),
    WRITABLE(3, "Writable", "WRITABLE"),
    EVENTABLE(4, "Eventable", "EVENTABLE");

    public static final int MEASUREMENT_UNIT_VALUE = 1;
    public static final int READABLE_VALUE = 2;
    public static final int WRITABLE_VALUE = 3;
    public static final int EVENTABLE_VALUE = 4;
    private static final PropertyAttributeType[] VALUES_ARRAY;
    public static final List<PropertyAttributeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PropertyAttributeType[]{MEASUREMENT_UNIT, READABLE, WRITABLE, EVENTABLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PropertyAttributeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PropertyAttributeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PropertyAttributeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PropertyAttributeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PropertyAttributeType get(int value) {
        switch (value) {
            case 1: {
                return MEASUREMENT_UNIT;
            }
            case 2: {
                return READABLE;
            }
            case 3: {
                return WRITABLE;
            }
            case 4: {
                return EVENTABLE;
            }
        }
        return null;
    }

    private PropertyAttributeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

