/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.net.URLEncoder;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.repository.Attachment;
import org.eclipse.vorto.core.api.repository.CheckInModelException;
import org.eclipse.vorto.core.api.repository.GeneratorResource;
import org.eclipse.vorto.core.api.repository.IModelRepository;
import org.eclipse.vorto.core.api.repository.ModelResource;
import org.eclipse.vorto.core.api.repository.RepositoryException;
import org.eclipse.vorto.core.api.repository.UploadResult;
import org.eclipse.vorto.repository.ConnectionInfo;
import org.eclipse.vorto.repository.RestClient;
import org.eclipse.vorto.repository.function.ModelViewToModelResource;
import org.eclipse.vorto.repository.function.StringToGeneratorList;
import org.eclipse.vorto.repository.function.StringToModelResourceResult;
import org.eclipse.vorto.repository.function.StringToSearchResult;
import org.eclipse.vorto.repository.function.StringToUploadResult;
import org.eclipse.vorto.repository.function.UploadResultViewToUploadResult;
import org.eclipse.vorto.repository.model.ModelView;
import org.eclipse.vorto.repository.model.UploadResultView;

public class RestModelRepository
extends Observable
implements IModelRepository {
    private static final String FILE_PARAMETER_NAME = "file";
    private static final String FILE_DOWNLOAD_FORMAT = "file/%s/%s/%s";
    private static final String MODELID_RESOURCE_FORMAT = "%s/%s/%s";
    private static final String CHECKIN_FORMAT = "%s";
    private Function<String, UploadResultView> uploadResponseConverter = new StringToUploadResult();
    private Function<ModelView, ModelResource> modelViewToModelResource = new ModelViewToModelResource();
    private Function<String, ModelView> contentConverters = new StringToModelResourceResult();
    private Function<String, ModelResource> stringToModelResource = Functions.compose(this.modelViewToModelResource, this.contentConverters);
    private Function<UploadResultView, UploadResult> uploadResultConverter = new UploadResultViewToUploadResult(this.modelViewToModelResource);
    private Function<String, List<ModelView>> searchResultConverter = new StringToSearchResult();
    private Function<String, List<GeneratorResource>> searchGeneratorResultConverter = new StringToGeneratorList();
    private Function<String, byte[]> stringToByteArray = new Function<String, byte[]>(){

        public byte[] apply(String input) {
            return input.getBytes();
        }
    };
    private RestClient httpClient;

    public RestModelRepository(ConnectionInfo connectionUrlSupplier) {
        Objects.requireNonNull(connectionUrlSupplier);
        this.httpClient = new RestClient(connectionUrlSupplier);
    }

    public List<ModelResource> search(String expression) {
        try {
            String searchExpr = null;
            searchExpr = Strings.isNullOrEmpty((String)expression) ? "-Mapping" : String.valueOf(expression) + " -Mapping";
            searchExpr = searchExpr.replaceAll(" ", "%20");
            List<ModelView> result = this.httpClient.executeGet("model/query=" + searchExpr, this.searchResultConverter);
            return Lists.transform(result, this.modelViewToModelResource);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error querying remote repository with queryString = '" + expression + "'", e);
        }
    }

    public byte[] downloadContent(ModelId modelId) {
        Objects.requireNonNull(modelId, "modelId should not be null");
        Objects.requireNonNull(modelId.getModelType(), "modelType should not be null");
        Objects.requireNonNull(modelId.getName(), "name should not be null");
        Objects.requireNonNull(modelId.getNamespace(), "namespace should not be null");
        Objects.requireNonNull(modelId.getVersion(), "version should not be null");
        String url = this.getUrlForModelDownload(modelId);
        try {
            return this.httpClient.executeGet(url, this.stringToByteArray);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error downloading modelContent for resource", e);
        }
    }

    public ModelResource getModel(ModelId modelId) {
        Objects.requireNonNull(modelId, "modelId should not be null");
        Objects.requireNonNull(modelId.getModelType(), "modelType should not be null");
        Objects.requireNonNull(modelId.getName(), "name should not be null");
        Objects.requireNonNull(modelId.getNamespace(), "namespace should not be null");
        Objects.requireNonNull(modelId.getVersion(), "version should not be null");
        String url = this.getUrlForModel(modelId);
        try {
            return this.httpClient.executeGet(url, this.stringToModelResource);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting model info for resource", e);
        }
    }

    private String getUrlForModelDownload(ModelId modelId) {
        return "model/" + String.format(FILE_DOWNLOAD_FORMAT, modelId.getNamespace(), modelId.getName(), modelId.getVersion());
    }

    private String getUrlForModel(ModelId modelId) {
        return "model/" + String.format(MODELID_RESOURCE_FORMAT, modelId.getNamespace(), modelId.getName(), modelId.getVersion());
    }

    private String getUrlForCheckin(String handleId) {
        return "secure/" + String.format(CHECKIN_FORMAT, handleId);
    }

    public UploadResult upload(String name, byte[] model) {
        Objects.requireNonNull(model, "Model should not be null.");
        Objects.requireNonNull(name, "Name should not be null.");
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody(FILE_PARAMETER_NAME, model, ContentType.APPLICATION_OCTET_STREAM, name);
            HttpEntity fileToUpload = builder.build();
            UploadResultView uploadResult = this.httpClient.executePost("secure", fileToUpload, this.uploadResponseConverter);
            return (UploadResult)this.uploadResultConverter.apply((Object)uploadResult);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting model info for resource", e);
        }
    }

    public void commit(String handleId) {
        Objects.requireNonNull(handleId, "handleId should not be null.");
        try {
            this.httpClient.executePut(this.getUrlForCheckin(handleId));
        }
        catch (Exception e) {
            throw new CheckInModelException("Error in committing file with upload id " + handleId + " to repository.", (Throwable)e);
        }
    }

    public List<GeneratorResource> listGenerators() {
        try {
            List<GeneratorResource> result = this.httpClient.executeGet("generation-router/platform", this.searchGeneratorResultConverter);
            return result;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error querying remote repository with listGenerators request.", e);
        }
    }

    public Attachment generateCode(ModelId model, String serviceKey) {
        try {
            String url = "generation-router/" + model.getNamespace() + "/" + model.getName() + "/" + model.getVersion() + "/" + URLEncoder.encode(serviceKey, "utf-8");
            Attachment result = this.httpClient.executeGetAttachment(url);
            return result;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error querying remote repository with generateCode request.", e);
        }
    }
}

