/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.dnd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.perspective.dnd.IDropAction;
import org.eclipse.vorto.perspective.dnd.IDropValidator;
import org.eclipse.vorto.perspective.view.ILocalModelWorkspace;
import org.eclipse.vorto.perspective.view.ModelProjectTreeViewer;

public class ModelDropListener
extends ViewerDropAdapter {
    private ILocalModelWorkspace localModelBrowser;
    private Class<?> allowedTarget;
    private Collection<DropSourceValidatorAndAction> dropActors = new ArrayList<DropSourceValidatorAndAction>();

    public ModelDropListener(Viewer viewer, ILocalModelWorkspace localModelBrowser) {
        super(Objects.requireNonNull(viewer));
        this.localModelBrowser = Objects.requireNonNull(localModelBrowser);
    }

    public ModelDropListener setAllowedTarget(Class<?> allowedTarget) {
        this.allowedTarget = allowedTarget;
        return this;
    }

    public ModelDropListener addDropAction(IDropValidator validator, IDropAction action) {
        Objects.requireNonNull(validator);
        Objects.requireNonNull(action);
        this.dropActors.add(new DropSourceValidatorAndAction(validator, action));
        return this;
    }

    public boolean performDrop(Object data) {
        Object target = this.getTarget();
        if (data instanceof IStructuredSelection) {
            Object droppedResource = ((IStructuredSelection)data).getFirstElement();
            for (DropSourceValidatorAndAction dropActor : this.dropActors) {
                if (!dropActor.validator.allow(target, droppedResource)) continue;
                dropActor.action.performDrop(target, droppedResource);
                break;
            }
            if (target != null) {
                IModelElement targetModelElement;
                ModelProjectTreeViewer viewer = (ModelProjectTreeViewer)this.getViewer();
                viewer.getLocalModelWorkspace().refreshCurrent();
                if (target instanceof IModelElement && (targetModelElement = this.findTarget((IModelElement)target, (Collection)viewer.getInput())) != null) {
                    viewer.expandToLevel(targetModelElement, 1);
                }
                return true;
            }
        }
        return false;
    }

    private IModelElement findTarget(IModelElement target, Collection<IModelElement> inputModelElements) {
        for (IModelElement e : inputModelElements) {
            if (!e.getId().equals((Object)target.getId())) continue;
            return e;
        }
        return null;
    }

    private Object getTarget() {
        Object target = this.getCurrentTarget();
        if (target == null) {
            Viewer viewer = this.getViewer();
            if (viewer instanceof ModelProjectTreeViewer) {
                target = ((ModelProjectTreeViewer)viewer).getLocalModelWorkspace().getProjectBrowser().getSelectedProject();
            }
        } else if (target instanceof IModelElement) {
            IModelProject project = this.localModelBrowser.getProjectBrowser().getSelectedProject();
            target = project.getModelElementById(((IModelElement)target).getId());
        } else {
            throw new RuntimeException("Target is not an IModelElement");
        }
        return target;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return this.allowedTarget == null || this.allowedTarget.isInstance(target);
    }

    private class DropSourceValidatorAndAction {
        private IDropValidator validator;
        private IDropAction action;

        public DropSourceValidatorAndAction(IDropValidator validator, IDropAction action) {
            this.validator = validator;
            this.action = action;
        }
    }
}

