/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.api.model.datatype;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConstraintIntervalType implements Enumerator
{
    MIN(0, "min", "MIN"),
    MAX(1, "max", "MAX"),
    STRLEN(2, "strlen", "STRLEN"),
    REGEX(3, "regex", "REGEX"),
    MIMETYPE(4, "mimetype", "MIMETYPE"),
    SCALING(5, "scaling", "SCALING");

    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 1;
    public static final int STRLEN_VALUE = 2;
    public static final int REGEX_VALUE = 3;
    public static final int MIMETYPE_VALUE = 4;
    public static final int SCALING_VALUE = 5;
    private static final ConstraintIntervalType[] VALUES_ARRAY;
    public static final List<ConstraintIntervalType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConstraintIntervalType[]{MIN, MAX, STRLEN, REGEX, MIMETYPE, SCALING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConstraintIntervalType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstraintIntervalType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstraintIntervalType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstraintIntervalType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstraintIntervalType get(int value) {
        switch (value) {
            case 0: {
                return MIN;
            }
            case 1: {
                return MAX;
            }
            case 2: {
                return STRLEN;
            }
            case 3: {
                return REGEX;
            }
            case 4: {
                return MIMETYPE;
            }
            case 5: {
                return SCALING;
            }
        }
        return null;
    }

    private ConstraintIntervalType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

