/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.ui.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.ModelNotFoundException;

public class ModelFileLookupHelper {
    private IProject project = null;

    public ModelFileLookupHelper(IProject project) {
        this.project = project;
    }

    public IFile getModelFileByExtension(String modelExtension) {
        IFolder folder = this.project.getFolder("src/models");
        IFile modelFile = this.getFileByExtension(folder, modelExtension);
        if (modelFile == null) {
            throw new ModelNotFoundException("No valid model file found", this.project);
        }
        return modelFile;
    }

    private IFile getFileByExtension(IFolder folder, String modelExtension) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member instanceof IFile && member.getFileExtension().equalsIgnoreCase(modelExtension)) {
                    return (IFile)member;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new ModelNotFoundException("Invalid model file found", e, this.project);
        }
        return null;
    }

    public IFile[] getSharedFilesByModelType(ModelType type) {
        return this.getSharedFilesByExtension(this.getExtension(type));
    }

    private String getExtension(ModelType modelType) {
        return modelType.getExtension();
    }

    public IFile[] getSharedFilesByExtension(String modelExtension) {
        ArrayList<IFile> foundFiles = new ArrayList<IFile>();
        foundFiles.addAll(this.getFilesByExtension(this.project.getFolder("src/shared_models"), modelExtension));
        return foundFiles.toArray(new IFile[foundFiles.size()]);
    }

    public List<IFile> getFilesByExtension(IFolder folder, String modelExtension) {
        ArrayList<IFile> foundFiles = new ArrayList<IFile>();
        if (!folder.exists()) {
            return new ArrayList<IFile>();
        }
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member instanceof IFile && member.getFileExtension().equalsIgnoreCase(modelExtension)) {
                    foundFiles.add((IFile)member);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new ModelNotFoundException("Invalid model file found", e, this.project);
        }
        return foundFiles;
    }

    public IFile getModelFile(String modelFileName) {
        IFolder folder = this.project.getFolder("src/models");
        IFile modelFile = this.getFile(folder, modelFileName);
        if (modelFile == null) {
            throw new ModelNotFoundException("No  model file with name " + modelFileName + " found.", this.project);
        }
        return modelFile;
    }

    public IFile getSharedFile(String modelFileName) {
        IFolder folder = this.project.getFolder("src/shared_models");
        return this.getFile(folder, modelFileName);
    }

    private IFile getFile(IFolder folder, String modelFileName) {
        if (!folder.exists()) {
            return null;
        }
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member instanceof IFile && member.getName().equalsIgnoreCase(modelFileName)) {
                    return (IFile)member;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new ModelNotFoundException("Invalid model file found", e, this.project);
        }
        return null;
    }
}

