/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.prosystfi.tasks;

import org.eclipse.vorto.codegen.api.AbstractTemplateGeneratorTask;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.examples.templates.java.JavaClassFieldGetterTemplate;
import org.eclipse.vorto.codegen.examples.templates.java.JavaClassFieldSetterTemplate;
import org.eclipse.vorto.codegen.examples.templates.java.JavaClassFieldTemplate;
import org.eclipse.vorto.codegen.examples.templates.java.JavaEntityTemplate;
import org.eclipse.vorto.core.api.model.datatype.Entity;

public class JavaClassGeneratorTask
extends AbstractTemplateGeneratorTask<Entity> {
    private String javaFileExtension;
    private String targetPath;
    private String classPackage;
    private String getterPrefix;
    private String setterPrefix;

    public JavaClassGeneratorTask(String javaFileExtension, String srcBase, String classPackage, String getterPrefix, String setterPrefix) {
        this.javaFileExtension = javaFileExtension;
        this.classPackage = classPackage;
        this.targetPath = String.valueOf(srcBase) + '/' + classPackage.replace('.', '/');
        this.getterPrefix = getterPrefix;
        this.setterPrefix = setterPrefix;
    }

    public String getFileName(Entity entity) {
        return String.valueOf(entity.getName()) + this.javaFileExtension;
    }

    public String getPath(Entity entity) {
        return this.targetPath;
    }

    public ITemplate<Entity> getTemplate() {
        JavaClassFieldTemplate fieldTemplate = new JavaClassFieldTemplate();
        JavaClassFieldGetterTemplate getterTemplate = new JavaClassFieldGetterTemplate(this.getterPrefix);
        JavaClassFieldSetterTemplate setterTemplate = new JavaClassFieldSetterTemplate(this.setterPrefix);
        return new JavaEntityTemplate(this.classPackage, (ITemplate)fieldTemplate, (ITemplate)getterTemplate, (ITemplate)setterTemplate);
    }
}

