/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.coap;

import org.eclipse.vorto.codegen.api.ChainedCodeGeneratorTask;
import org.eclipse.vorto.codegen.api.GenerationResultZip;
import org.eclipse.vorto.codegen.api.GeneratorTaskFromFileTemplate;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.examples.coap.client.tasks.CoAPClientFunctionblockImplGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.client.tasks.CoAPClientFunctionblockInterfaceGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.client.tasks.CoAPClientInformationModelGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.client.templates.ClientDemoAppTemplate;
import org.eclipse.vorto.codegen.examples.coap.client.templates.ClientTemplate;
import org.eclipse.vorto.codegen.examples.coap.client.templates.CoAPMethodTemplate;
import org.eclipse.vorto.codegen.examples.coap.common.tasks.JavaClassGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.common.tasks.JavaEnumGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.common.tasks.JavaFBOperationParamSetGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.common.tasks.JavaFBOperationReturnPrimitiveTypeWrapperGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.common.tasks.JavaFBPropertyPrimitiveParamWrapperGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.common.tasks.JavaFunctionblockImplGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.common.tasks.JavaFunctionblockInterfaceGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.common.tasks.JavaInformationModelGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.common.tasks.JavaInformationModelInterfaceGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.common.templates.PomFileTemplate;
import org.eclipse.vorto.codegen.examples.coap.server.tasks.CoAPServerGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.server.tasks.CoAPServerIMRequestHandlerGeneratorTask;
import org.eclipse.vorto.codegen.examples.coap.server.templates.CoAPServerDemoAppTemplate;
import org.eclipse.vorto.codegen.examples.coap.server.templates.ICoAPRequestHandlerTemplate;
import org.eclipse.vorto.codegen.examples.coap.server.templates.JsonTransformerTemplate;
import org.eclipse.vorto.codegen.examples.coap.server.templates.LinkTemplate;
import org.eclipse.vorto.codegen.examples.coap.server.templates.ResourceTemplate;
import org.eclipse.vorto.codegen.examples.coap.server.templates.URIAnalyzerTemplate;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class CoAPGenerator
implements IVortoCodeGenerator {
    public static final String COAP_CLIENT_NAME = "Client";
    public static final String COAP_SERVER_NAME = "Server";
    public static final String COAP_REQUEST_HANDLER_NAME = "CoAPRequestHandler";
    public static final String COAP_PARAM_SET_SUFFIX = "ParamSet";
    public static final String COAP_PRIM_TYPE_WRAPPER_SUFFIX = "PrimTypeWrapper";
    public static final String COAP_SERVER_PROJECT_SUFFIX = "_CoAP_Server";
    public static final String COAP_CLIENT_PROJECT_SUFFIX = "_CoAP_Client";
    public static final String JAVA_FILE_EXTENSION = ".java";
    public static final String JAVA_INTERFACE_PREFIX = "I";
    public static final String JAVA_IMPL_SUFFIX = "Impl";
    public static final String GETTER_PREFIX = "get";
    public static final String SETTER_PREFIX = "set";
    public static final String BASE_PACKAGE = "org.eclipse.vorto.";
    public static final String COAP_SERVER_PACKAGE = "org.eclipse.vorto.coap.server";
    public static final String COAP_CLIENT_PACKAGE = "org.eclipse.vorto.coap.client";
    public static final String COAP_REQUEST_HANDLER_PACKAGE = "org.eclipse.vorto.coap";
    public static final String COAP_DEMO_PACKAGE = "org.eclipse.vorto.demo";
    public static final String MODEL_PACKAGE = "org.eclipse.vorto.model.";
    public static final String DT_PACKAGE = "org.eclipse.vorto.model.datatypes";
    public static final String FB_PACKAGE = "org.eclipse.vorto.model.functionblocks";
    public static final String FB_IMPL_PACKAGE = "org.eclipse.vorto.model.functionblocks.implementation";
    public static final String FB_INTERFACE_PACKAGE = "org.eclipse.vorto.model.functionblocks.interfaces";
    public static final String IM_PACKAGE = "org.eclipse.vorto.model.informationmodels";
    public static final String OP_PARAM_SET_PACKAGE = "org.eclipse.vorto.model.operationparameterset";
    public static final String PRIMITIVE_TYPE_WRAPPER_PACKAGE = "org.eclipse.vorto.model.primitivetypewrapper";
    private String javaSrcLoc;
    private String basePath;
    private String coapServerPath;
    private String coapClientPath;
    private String coapRequestHandlerPath;
    private String coapDemoPath;
    private String modelPath;
    private String primitiveTypeWrapperTargetPath;
    private String opParameterSetTargetPath;
    private String entityTargetPath;
    private String fbTargetPath;
    private String fbImplTargetPath;
    private String fbInterfaceTargetPath;
    private String imTargetPath;
    private Boolean opParamSetRequired = false;
    private Boolean primTypeWrapperRequired = false;

    public IGenerationResult generate(InformationModel infomodel, InvocationContext mappingContext) {
        GenerationResultZip zipOutputter = new GenerationResultZip(infomodel, this.getServiceKey());
        ChainedCodeGeneratorTask generator = new ChainedCodeGeneratorTask();
        String CLIENT_PROJ = String.valueOf(infomodel.getName()) + COAP_CLIENT_PROJECT_SUFFIX;
        this.initPaths(CLIENT_PROJ);
        generator.addTask((ICodeGeneratorTask)new CoAPClientInformationModelGeneratorTask(JAVA_FILE_EXTENSION, this.imTargetPath, IM_PACKAGE, JAVA_INTERFACE_PREFIX, JAVA_IMPL_SUFFIX, GETTER_PREFIX, SETTER_PREFIX, FB_INTERFACE_PACKAGE, FB_IMPL_PACKAGE));
        generator.addTask((ICodeGeneratorTask)new JavaInformationModelInterfaceGeneratorTask(JAVA_FILE_EXTENSION, this.imTargetPath, IM_PACKAGE, JAVA_INTERFACE_PREFIX, GETTER_PREFIX, SETTER_PREFIX, FB_INTERFACE_PACKAGE));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ClientTemplate(this.coapClientPath, COAP_CLIENT_PACKAGE)));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new CoAPMethodTemplate(this.coapClientPath, COAP_CLIENT_PACKAGE)));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ClientDemoAppTemplate(this.coapDemoPath, COAP_DEMO_PACKAGE)));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new PomFileTemplate("artifact", "org.eclipse.vorto.demo.ClientDemoApp", CLIENT_PROJ)));
        generator.generate((Object)infomodel, mappingContext, (IGeneratedWriter)zipOutputter);
        for (FunctionblockProperty fbp : infomodel.getProperties()) {
            FunctionBlock fb = fbp.getType().getFunctionblock();
            for (Entity entity : Utils.getReferencedEntities((FunctionBlock)fb)) {
                this.generateForEntity(entity, (IGeneratedWriter)zipOutputter);
            }
            for (Enum en : Utils.getReferencedEnums((FunctionBlock)fb)) {
                this.generateForEnum(en, (IGeneratedWriter)zipOutputter);
            }
            for (Operation op : fb.getOperations()) {
                this.generateForOperation(op, (IGeneratedWriter)zipOutputter);
            }
            if (fb.getStatus() != null) {
                for (Property property : fb.getStatus().getProperties()) {
                    this.generateForProperty(property, (IGeneratedWriter)zipOutputter);
                }
            }
            this.generateForClientFunctionBlock(fbp.getType(), (IGeneratedWriter)zipOutputter);
        }
        String SERVER_PROJ = String.valueOf(infomodel.getName()) + COAP_SERVER_PROJECT_SUFFIX;
        this.initPaths(SERVER_PROJ);
        generator.addTask((ICodeGeneratorTask)new CoAPServerGeneratorTask(COAP_SERVER_NAME, COAP_SERVER_PACKAGE, JAVA_FILE_EXTENSION, this.coapServerPath, "ICoAPRequestHandler", COAP_REQUEST_HANDLER_PACKAGE));
        generator.addTask((ICodeGeneratorTask)new CoAPServerIMRequestHandlerGeneratorTask(COAP_REQUEST_HANDLER_NAME, JAVA_FILE_EXTENSION, this.coapRequestHandlerPath, COAP_REQUEST_HANDLER_PACKAGE, JAVA_INTERFACE_PREFIX, COAP_PRIM_TYPE_WRAPPER_SUFFIX, IM_PACKAGE, DT_PACKAGE, this.getOpParamSetPackage(), this.getPrimitiveParamWrapperPackage()));
        generator.addTask((ICodeGeneratorTask)new JavaInformationModelGeneratorTask(JAVA_FILE_EXTENSION, this.imTargetPath, IM_PACKAGE, JAVA_INTERFACE_PREFIX, JAVA_IMPL_SUFFIX, GETTER_PREFIX, SETTER_PREFIX, FB_INTERFACE_PACKAGE, FB_IMPL_PACKAGE));
        generator.addTask((ICodeGeneratorTask)new JavaInformationModelInterfaceGeneratorTask(JAVA_FILE_EXTENSION, this.imTargetPath, IM_PACKAGE, JAVA_INTERFACE_PREFIX, GETTER_PREFIX, SETTER_PREFIX, FB_INTERFACE_PACKAGE, FB_IMPL_PACKAGE));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ICoAPRequestHandlerTemplate(this.coapRequestHandlerPath, COAP_REQUEST_HANDLER_PACKAGE)));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new JsonTransformerTemplate(this.coapRequestHandlerPath, COAP_REQUEST_HANDLER_PACKAGE)));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new URIAnalyzerTemplate(this.coapRequestHandlerPath, COAP_REQUEST_HANDLER_PACKAGE)));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ResourceTemplate(this.coapServerPath, COAP_SERVER_PACKAGE, COAP_REQUEST_HANDLER_PACKAGE)));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new LinkTemplate(this.coapServerPath, COAP_SERVER_PACKAGE)));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new CoAPServerDemoAppTemplate(this.coapDemoPath, COAP_DEMO_PACKAGE, COAP_REQUEST_HANDLER_PACKAGE, COAP_SERVER_PACKAGE)));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new PomFileTemplate("artifact", "org.eclipse.vorto.demo.ServerDemoApp", SERVER_PROJ)));
        generator.generate((Object)infomodel, mappingContext, (IGeneratedWriter)zipOutputter);
        for (FunctionblockProperty fbp : infomodel.getProperties()) {
            this.generateForFunctionBlock(fbp.getType(), (IGeneratedWriter)zipOutputter);
            FunctionBlock fb = fbp.getType().getFunctionblock();
            for (Entity entity : Utils.getReferencedEntities((FunctionBlock)fb)) {
                this.generateForEntity(entity, (IGeneratedWriter)zipOutputter);
            }
            for (Enum en : Utils.getReferencedEnums((FunctionBlock)fb)) {
                this.generateForEnum(en, (IGeneratedWriter)zipOutputter);
            }
            for (Operation op : fb.getOperations()) {
                this.generateForOperation(op, (IGeneratedWriter)zipOutputter);
            }
        }
        return zipOutputter;
    }

    private void generateForFunctionBlock(FunctionblockModel fbm, IGeneratedWriter outputter) {
        new JavaFunctionblockImplGeneratorTask(JAVA_FILE_EXTENSION, this.fbImplTargetPath, FB_IMPL_PACKAGE, JAVA_INTERFACE_PREFIX, JAVA_IMPL_SUFFIX, DT_PACKAGE, FB_INTERFACE_PACKAGE).generate(fbm, null, outputter);
        new JavaFunctionblockInterfaceGeneratorTask(JAVA_FILE_EXTENSION, this.fbInterfaceTargetPath, FB_INTERFACE_PACKAGE, JAVA_INTERFACE_PREFIX, DT_PACKAGE).generate(fbm, null, outputter);
    }

    private void generateForEntity(Entity entity, IGeneratedWriter outputter) {
        new JavaClassGeneratorTask(JAVA_FILE_EXTENSION, this.entityTargetPath, DT_PACKAGE, GETTER_PREFIX, SETTER_PREFIX).generate(entity, null, outputter);
    }

    private void generateForEnum(Enum en, IGeneratedWriter outputter) {
        new JavaEnumGeneratorTask(JAVA_FILE_EXTENSION, this.entityTargetPath, DT_PACKAGE).generate(en, null, outputter);
    }

    private void generateForOperation(Operation op, IGeneratedWriter outputter) {
        if (op.getReturnType() != null && op.getReturnType() instanceof ReturnPrimitiveType) {
            this.primTypeWrapperRequired = true;
            new JavaFBOperationReturnPrimitiveTypeWrapperGeneratorTask(String.valueOf(op.getName()) + COAP_PRIM_TYPE_WRAPPER_SUFFIX, JAVA_FILE_EXTENSION, this.primitiveTypeWrapperTargetPath, PRIMITIVE_TYPE_WRAPPER_PACKAGE).generate(op, null, outputter);
        }
        if (!op.getParams().isEmpty()) {
            this.opParamSetRequired = true;
            new JavaFBOperationParamSetGeneratorTask(String.valueOf(op.getName()) + COAP_PARAM_SET_SUFFIX, JAVA_FILE_EXTENSION, this.opParameterSetTargetPath, OP_PARAM_SET_PACKAGE, DT_PACKAGE).generate(op, null, outputter);
        }
    }

    private void generateForProperty(Property property, IGeneratedWriter outputter) {
        if (property.getType() != null && property.getType() instanceof PrimitivePropertyType) {
            new JavaFBPropertyPrimitiveParamWrapperGeneratorTask(String.valueOf(property.getName()) + COAP_PRIM_TYPE_WRAPPER_SUFFIX, JAVA_FILE_EXTENSION, this.primitiveTypeWrapperTargetPath, PRIMITIVE_TYPE_WRAPPER_PACKAGE).generate(property, null, outputter);
        }
    }

    private void generateForClientFunctionBlock(FunctionblockModel fbm, IGeneratedWriter outputter) {
        new CoAPClientFunctionblockImplGeneratorTask(JAVA_FILE_EXTENSION, this.fbImplTargetPath, FB_IMPL_PACKAGE, JAVA_INTERFACE_PREFIX, JAVA_IMPL_SUFFIX, COAP_PARAM_SET_SUFFIX, COAP_PRIM_TYPE_WRAPPER_SUFFIX, DT_PACKAGE, FB_INTERFACE_PACKAGE, this.getOpParamSetPackage(), this.getPrimitiveParamWrapperPackage(), COAP_CLIENT_PACKAGE).generate(fbm, null, outputter);
        new CoAPClientFunctionblockInterfaceGeneratorTask(JAVA_FILE_EXTENSION, this.fbInterfaceTargetPath, FB_INTERFACE_PACKAGE, JAVA_INTERFACE_PREFIX, DT_PACKAGE).generate(fbm, null, outputter);
    }

    private void initPaths(String root) {
        this.javaSrcLoc = String.valueOf(root) + "/src/main/java/";
        this.basePath = String.valueOf(this.javaSrcLoc) + "org/eclipse/vorto/";
        this.coapServerPath = String.valueOf(this.basePath) + "coap/server";
        this.coapClientPath = String.valueOf(this.basePath) + "coap/client";
        this.coapRequestHandlerPath = String.valueOf(this.basePath) + "coap";
        this.coapDemoPath = String.valueOf(this.basePath) + "demo";
        this.modelPath = String.valueOf(this.basePath) + "model/";
        this.primitiveTypeWrapperTargetPath = String.valueOf(this.modelPath) + "primitivetypewrapper";
        this.opParameterSetTargetPath = String.valueOf(this.modelPath) + "operationparameterset";
        this.entityTargetPath = String.valueOf(this.modelPath) + "datatypes";
        this.fbTargetPath = String.valueOf(this.modelPath) + "functionblocks";
        this.fbImplTargetPath = String.valueOf(this.fbTargetPath) + "/implementation";
        this.fbInterfaceTargetPath = String.valueOf(this.fbTargetPath) + "/interfaces";
        this.imTargetPath = String.valueOf(this.modelPath) + "informationmodels";
    }

    private String getOpParamSetPackage() {
        return this.opParamSetRequired != false ? OP_PARAM_SET_PACKAGE : null;
    }

    private String getPrimitiveParamWrapperPackage() {
        return this.primTypeWrapperRequired != false ? PRIMITIVE_TYPE_WRAPPER_PACKAGE : null;
    }

    public String getServiceKey() {
        return "coap";
    }
}

