/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.MockResourceDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockResourceDeltaFactory {
    public MockResourceDeltaFactory(IWorkspaceContext wsContext) {
    }

    private void checkResourceValid(IResource res) {
        if (res == null) {
            throw new IllegalArgumentException();
        }
    }

    public MockResourceDelta createSimpleFileChange(IFile file) {
        this.checkResourceValid((IResource)file);
        return this.newChangeDelta((IResource)file, 260);
    }

    public MockResourceDelta createSimpleFileAdded(IFile file) {
        return this.createSimpleFileAdded(file, 1);
    }

    public MockResourceDelta createSimpleFileAdded(IFile file, int kind) {
        this.checkResourceValid((IResource)file);
        return this.newAddDelta((IResource)file, kind);
    }

    public MockResourceDelta createSimpleFolderAdded(IFolder folder) {
        return this.createSimpleFolderAdded(folder, 1);
    }

    public MockResourceDelta createSimpleFolderAdded(IFolder folder, int kind) {
        this.checkResourceValid((IResource)folder);
        MockResourceDelta root = this.newAddDelta((IResource)folder, kind);
        return root;
    }

    public MockResourceDelta createSimpleFileRemoved(IFile file) {
        return this.createSimpleFileRemoved(file, 2);
    }

    public MockResourceDelta createSimpleFileRemoved(IFile file, int kind) {
        this.checkResourceValid((IResource)file);
        return this.newRemoveDelta((IResource)file, kind);
    }

    public MockResourceDelta createSimpleFolderRemoved(IFolder folder) {
        return this.createSimpleFolderRemoved(folder, 2);
    }

    public MockResourceDelta createSimpleFolderRemoved(IFolder folder, int kind) {
        this.checkResourceValid((IResource)folder);
        return this.newRemoveDelta((IResource)folder, kind);
    }

    public MockResourceDelta createRecursiveFolderRemoved(IFolder folder) {
        this.checkResourceValid((IResource)folder);
        return this.newRemoveDeltaRecursive(folder, 2);
    }

    protected MockResourceDelta newChangeDelta(IResource resource, int kind) {
        MockResourceDelta delta = new MockResourceDelta(resource, resource, kind, Collections.EMPTY_LIST);
        return this.createWorkspaceRootedDeltaTo(resource, delta);
    }

    protected MockResourceDelta newAddDelta(IResource resource, int kind) {
        MockResourceDelta delta = new MockResourceDelta(resource, null, kind, Collections.EMPTY_LIST);
        return this.createWorkspaceRootedDeltaTo(resource, delta);
    }

    protected MockResourceDelta newRemoveDelta(IResource resource, int kind) {
        MockResourceDelta delta = new MockResourceDelta(null, resource, kind, Collections.EMPTY_LIST);
        return this.createWorkspaceRootedDeltaTo(resource, delta);
    }

    private MockResourceDelta newRemoveDeltaRecursive(IFolder folder, int kind) {
        MockResourceDelta delta = this.recursiveContainerRemoved((IResource)folder, kind);
        return this.createWorkspaceRootedDeltaTo((IResource)folder, delta);
    }

    private MockResourceDelta recursiveContainerRemoved(IResource rootRes, int kind) {
        ArrayList<MockResourceDelta> childDeltas = new ArrayList<MockResourceDelta>();
        try {
            if (rootRes instanceof IContainer) {
                IResource[] iResourceArray = ((IContainer)rootRes).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    childDeltas.add(this.recursiveContainerRemoved(res, kind));
                    ++n2;
                }
            }
            return new MockResourceDelta(null, rootRes, kind, childDeltas);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public MockResourceDelta createPathToChangeDelta(IResource res, List<MockResourceDelta> descendants) {
        return new MockResourceDelta(res, res, 0, descendants);
    }

    protected MockResourceDelta createWorkspaceRootedDeltaTo(IResource res, MockResourceDelta leafRes) {
        MockResourceDelta curDelta = leafRes;
        IContainer parent = res.getParent();
        while (parent != null) {
            curDelta = this.createPathToChangeDelta((IResource)parent, Collections.singletonList(curDelta));
            parent = parent.getParent();
        }
        return curDelta;
    }

    public MockResourceDelta createFileMove(IFile file, IFile newFile) {
        MockResourceDelta fileAddEvent = this.createSimpleFileAdded(newFile, 4097);
        MockResourceDelta fileRemoveEvent = this.createSimpleFileRemoved(file, 8194);
        return this.merge(file.getWorkspace().getRoot(), fileAddEvent, fileRemoveEvent);
    }

    public MockResourceDelta createFileRename(IFile file, IFile newFile) {
        Assert.assertEquals((Object)file.getParent(), (Object)newFile.getParent());
        return this.createFileMove(file, newFile);
    }

    public MockResourceDelta createFolderRename(IFolder folder, IFolder newFolder) {
        Assert.assertEquals((Object)folder.getParent(), (Object)newFolder.getParent());
        return this.createFolderMove(folder, newFolder);
    }

    public MockResourceDelta createFolderMove(IFolder folder, IFolder newFolder) {
        MockResourceDelta fileAddEvent = this.createSimpleFolderAdded(newFolder, 4097);
        MockResourceDelta fileRemoveEvent = this.createSimpleFolderRemoved(folder, 8194);
        return this.merge(folder.getWorkspace().getRoot(), fileAddEvent, fileRemoveEvent);
    }

    private MockResourceDelta merge(IWorkspaceRoot root, MockResourceDelta ... deltas) {
        MergeVisitor visitor = new MergeVisitor(root);
        MockResourceDelta[] mockResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            MockResourceDelta delta = mockResourceDeltaArray[n2];
            try {
                delta.accept(visitor);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        return visitor.getNewDelta();
    }

    private static final class MergeVisitor
    implements IResourceDeltaVisitor {
        private final Map<IResource, MockResourceDelta> _merged = new HashMap<IResource, MockResourceDelta>();
        private final IWorkspaceRoot _root;

        private MergeVisitor(IWorkspaceRoot root) {
            this._root = root;
        }

        public boolean visit(IResourceDelta addDelta) throws CoreException {
            IResource res = addDelta.getResource();
            if (res == null) {
                throw new IllegalArgumentException();
            }
            MockResourceDelta curDelta = this._merged.get(res);
            curDelta = curDelta != null ? curDelta.merge((MockResourceDelta)addDelta) : (MockResourceDelta)addDelta;
            this._merged.put(res, curDelta);
            return true;
        }

        public final MockResourceDelta getNewDelta() {
            MockResourceDelta newDelta = new MockResourceDelta((IResource)this._root, (IResource)this._root, 0, new ArrayList<MockResourceDelta>());
            this.addAllChildren(newDelta);
            return newDelta;
        }

        private void addAllChildren(MockResourceDelta newDelta) {
            IResource activeRes = newDelta.getResource();
            if (activeRes == null) {
                throw new NullPointerException();
            }
            for (Map.Entry<IResource, MockResourceDelta> entry : this._merged.entrySet()) {
                IResource key = entry.getKey();
                if (key == null) {
                    throw new NullPointerException();
                }
                if (!activeRes.equals((Object)key.getParent())) continue;
                MockResourceDelta value = entry.getValue();
                this.addAllChildren(value);
                MockResourceDelta mergeChild = null;
                for (MockResourceDelta checkChild : newDelta.getChildDeltas()) {
                    if (!value.getActiveResource().equals((Object)checkChild.getActiveResource())) continue;
                    mergeChild = checkChild;
                    break;
                }
                if (mergeChild != null) {
                    newDelta.getChildDeltas().remove(mergeChild);
                    newDelta.getChildDeltas().add(mergeChild.merge(value));
                    continue;
                }
                newDelta.getChildDeltas().add(value);
            }
        }
    }
}

