/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.runtime;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.jsdt.core.runtime.IJSRunner;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.JSRunnerConfiguration;
import org.eclipse.wst.jsdt.js.node.internal.Messages;
import org.eclipse.wst.jsdt.js.node.internal.util.LaunchConfigurationUtil;

public class NodeJsRunner
implements IJSRunner {
    private IJSRuntimeInstall jsRuntimeInstall;

    public NodeJsRunner(IJSRuntimeInstall jsRuntimeInstall) {
        this.jsRuntimeInstall = jsRuntimeInstall;
    }

    public IProcess run(JSRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(this.jsRuntimeInstall.getInstallLocation().getPath());
        String[] nodeRuntimeArguments = this.combineRuntimeArgs(configuration, this.jsRuntimeInstall);
        if (nodeRuntimeArguments.length != 0) {
            String[] stringArray = nodeRuntimeArguments;
            int n = nodeRuntimeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                String argument = stringArray[n2];
                cmdLine.add(argument);
                ++n2;
            }
        }
        String mainFile = configuration.getFileToLaunch();
        cmdLine.add(mainFile);
        String[] appArguments = configuration.getProgramArguments();
        if (appArguments.length != 0) {
            String[] stringArray = appArguments;
            int n = appArguments.length;
            int n3 = 0;
            while (n3 < n) {
                String argument = stringArray[n3];
                cmdLine.add(argument);
                ++n3;
            }
        }
        File workingPath = null;
        String workingDirectory = configuration.getWorkingDirectory();
        if (workingDirectory.length() > 0) {
            workingPath = new File(workingDirectory);
        }
        String[] cmds = new String[]{};
        cmds = cmdLine.toArray(cmds);
        ProcessBuilder builder = new ProcessBuilder(cmds);
        builder.directory(workingPath);
        try {
            Process process = builder.start();
            builder.redirectErrorStream(true);
            launch.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", "UTF-8");
            return DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)"Node.js process", LaunchConfigurationUtil.getDefaultAttributes());
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.js.node", Messages.LAUNCH_CONFIGURATION_FAILED_EXECUTION_ERROR, (Throwable)ex));
        }
    }

    protected String[] combineRuntimeArgs(JSRunnerConfiguration configuration, IJSRuntimeInstall jsRuntimeInstall2) {
        String[] launchVMArgs = configuration.getJSRuntimeArguments();
        String[] vmVMArgs = jsRuntimeInstall2.getJSRuntimeArguments();
        if (vmVMArgs == null || vmVMArgs.length == 0) {
            return launchVMArgs;
        }
        String[] allVMArgs = new String[launchVMArgs.length + vmVMArgs.length];
        System.arraycopy(vmVMArgs, 0, allVMArgs, 0, vmVMArgs.length);
        System.arraycopy(launchVMArgs, 0, allVMArgs, vmVMArgs.length, launchVMArgs.length);
        return allVMArgs;
    }
}

