/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.comparator;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorTools;
import org.eclipse.jpt.common.utility.internal.comparator.VersionComparator;

public class VersionComparatorTests
extends TestCase {
    public VersionComparatorTests(String name) {
        super(name);
    }

    public void testVersionIsEqual_integer() {
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.0.0", "2.0.0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.0.0", "2.0.0.0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.0.0.0.0.0.0000", "2.0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.0.-1", "2.0.-1") == 0 ? 1 : 0) != 0);
    }

    public void testVersionIsLess_integer() {
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.0.0", "2.0.1") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.5.0", "2.14") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.5.0", "2.5.0.0.1.0") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.5.0.0.0.-1", "2.5") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.0.-1", "2.0.0") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.0.-1", "2") < 0 ? 1 : 0) != 0);
    }

    public void testVersionIsGreater_integer() {
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.0.2", "2.0.1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.0.2", "2.0.1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.5.0.0.1.0", "2.5.0") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.5", "2.5.0.0.0.-1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.0.0", "2.0.-1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2", "2.0.-1") > 0 ? 1 : 0) != 0);
    }

    public void testVersionIsEqual_integer_comma() {
        VersionComparator versionComparator = new VersionComparator(",", DecimalSegmentParser.instance());
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0,0", "2,0,0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0.0,0", "2,0,0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0.0,0", "2,0,0.0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0,0.0,0", "2,0,0.0") == 0 ? 1 : 0) != 0);
    }

    public void testVersionIsLess_integer_comma() {
        VersionComparator versionComparator = new VersionComparator(",", DecimalSegmentParser.instance());
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0,0", "2,0,1") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0.0,0", "2,0,1") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0,0", "2,0,1.0") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0,0,0", "2,0,1") < 0 ? 1 : 0) != 0);
    }

    public void testVersionIsGreater_integer_comma() {
        Comparator versionComparator = ComparatorTools.versionComparator((char)',', DecimalSegmentParser.instance());
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0,2", "2,0,1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0,2.1", "2,0,1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0,2", "2,0,1.9") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.000,0,2", "2,0,1") > 0 ? 1 : 0) != 0);
    }

    public void testVersionIsEqual_subclass() {
        Comparator versionComparator = ComparatorTools.integerVersionComparator();
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0.0", "2.0.0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0.0", "2.0.0.0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0.0.0", "2.0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0.-1", "2.0.-1") == 0 ? 1 : 0) != 0);
    }

    public void testVersionIsLess_subclass() {
        Comparator versionComparator = ComparatorTools.integerVersionComparator();
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0.0", "2.0.1") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.5.0", "2.14") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.5.0", "2.5.0.0.1.0") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0.-1", "2.0.0") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0.-1", "2") < 0 ? 1 : 0) != 0);
    }

    public void testVersionIsGreater_subclass() {
        Comparator versionComparator = ComparatorTools.integerVersionComparator();
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0.2", "2.0.1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0.2", "2.0.1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.5.0.0.1.0", "2.5.0") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0.0", "2.0.-1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2", "2.0.-1") > 0 ? 1 : 0) != 0);
    }

    public void testBadString() {
        boolean exCaught = false;
        try {
            VersionComparatorTests.assertTrue((ComparatorTools.integerVersionComparator().compare("2.0.0", "2.O.O") == 0 ? 1 : 0) != 0);
        }
        catch (NumberFormatException numberFormatException) {
            exCaught = true;
        }
        VersionComparatorTests.assertTrue((boolean)exCaught);
    }

    static final class DecimalSegmentParser
    implements VersionComparator.SegmentParser<BigDecimal>,
    Serializable {
        public static final VersionComparator.SegmentParser<BigDecimal> INSTANCE = new DecimalSegmentParser();
        private static final BigDecimal ZERO = new BigDecimal(0);
        private static final long serialVersionUID = 1L;

        public static VersionComparator.SegmentParser<BigDecimal> instance() {
            return INSTANCE;
        }

        private DecimalSegmentParser() {
        }

        public BigDecimal parse(int segmentIndex, String segment) {
            return new BigDecimal(segment);
        }

        public BigDecimal getZero() {
            return ZERO;
        }

        public String toString() {
            return ObjectTools.singletonToString((Object)this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

