/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.context.DTJSPExternalContext;
import org.eclipse.jst.jsf.designtime.context.IDTExternalContext;
import org.eclipse.jst.jsf.designtime.el.AbstractDTMethodResolver;
import org.eclipse.jst.jsf.designtime.el.AbstractDTPropertyResolver;
import org.eclipse.jst.jsf.designtime.el.AbstractDTVariableResolver;
import org.eclipse.jst.jsf.designtime.el.DefaultDTPropertyResolver;
import org.eclipse.jst.jsf.designtime.internal.view.DefaultDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TestDesignTimeApplicationManager
extends TestCase {
    private IFile _testJSP;
    private JSFFacetedTestEnvironment _jsfFactedTestEnvironment;
    private WebProjectTestEnvironment _webProjectTestEnv;
    private JDTTestEnvironment _jdtTestEnv;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        this._webProjectTestEnv = new WebProjectTestEnvironment("TestDesignTimeApplicationManager" + this.getName());
        this._webProjectTestEnv.createProject(false);
        this._jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._webProjectTestEnv);
        TestFileResource input = new TestFileResource();
        input.load(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/bundle1.resources.data");
        this._jdtTestEnv.addResourceFile("src", (InputStream)new ByteArrayInputStream(input.toBytes()), "bundles", "bundle1.properties");
        IResource res = this._webProjectTestEnv.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/testdata1.jsp.data", "testdata1.jsp");
        this._testJSP = (IFile)res;
        this._jsfFactedTestEnvironment = new JSFFacetedTestEnvironment(this._webProjectTestEnv);
        this._jsfFactedTestEnvironment.initialize("1.1");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetFacesContext() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        DTFacesContext facesContext = manager.getFacesContext(this._testJSP);
        TestDesignTimeApplicationManager.assertNotNull((Object)facesContext);
        IDTExternalContext externalContext = facesContext.getDTExternalContext((IAdaptable)this._testJSP);
        TestDesignTimeApplicationManager.assertNotNull((Object)externalContext);
        TestDesignTimeApplicationManager.assertEquals((Object)this._testJSP, (Object)facesContext.adaptContextObject());
    }

    public void testBug147729() throws Exception {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._webProjectTestEnv.getTestProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager.getPropertyResolver());
        manager.setPropertyResolverProvider("my.test.blah");
        TestDesignTimeApplicationManager.assertEquals((String)"my.test.blah", (String)manager.getPropertyResolverProvider());
        RenameSupport renameSupport = RenameSupport.create((IJavaProject)this._jdtTestEnv.getJavaProject(), (String)("RenamedProject" + this.getName()), (int)1);
        renameSupport.perform(new Shell(), (IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        TestDesignTimeApplicationManager.assertFalse((boolean)this._jdtTestEnv.getJavaProject().getProject().isAccessible());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("RenamedProject" + this.getName());
        TestDesignTimeApplicationManager.assertTrue((boolean)project.isAccessible());
        manager = DesignTimeApplicationManager.getInstance((IProject)project);
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        TestDesignTimeApplicationManager.assertEquals((String)"my.test.blah", (String)manager.getPropertyResolverProvider());
    }

    public void testGetVariableResolver() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        AbstractDTVariableResolver variableResolver = manager.getVariableResolver();
        TestDesignTimeApplicationManager.assertNotNull((Object)variableResolver);
    }

    public void testGetPropertyResolver() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        AbstractDTPropertyResolver propertyResolver = manager.getPropertyResolver();
        TestDesignTimeApplicationManager.assertNotNull((Object)propertyResolver);
    }

    public void testGetMethodResolver() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        AbstractDTMethodResolver methodResolver = manager.getMethodResolver();
        TestDesignTimeApplicationManager.assertNotNull((Object)methodResolver);
    }

    public void testFileWithNoDT() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        IFile file1 = this._testJSP.getProject().getFile((IPath)new Path("fakefile1"));
        TestDesignTimeApplicationManager.assertNotNull((Object)file1);
        TestDesignTimeApplicationManager.assertFalse((boolean)file1.isAccessible());
        TestDesignTimeApplicationManager.assertFalse((boolean)manager.hasDTFacesContext(file1));
        TestDesignTimeApplicationManager.assertNull((Object)manager.getFacesContext(file1));
    }

    public void testGetDefaultPropertyResolver() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        AbstractDTPropertyResolver defaultPropertyResolver = manager.getDefaultPropertyResolver();
        TestDesignTimeApplicationManager.assertNotNull((Object)defaultPropertyResolver);
        TestDesignTimeApplicationManager.assertTrue((boolean)(defaultPropertyResolver instanceof DefaultDTPropertyResolver));
    }

    public void testGetExternalContextProvider() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        TestDesignTimeApplicationManager.assertEquals((String)"org.eclipse.jst.jsf.core.externalcontext.default", (String)manager.getExternalContextProvider());
    }

    public void testGetMethodResolverProvider() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        TestDesignTimeApplicationManager.assertEquals((String)"org.eclipse.jst.jsf.core.methodresolver.default", (String)manager.getMethodResolverProvider());
    }

    public void testGetVariableResolverProvider() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        TestDesignTimeApplicationManager.assertEquals((String)"org.eclipse.jst.jsf.core.variableresolver.default.decorative", (String)manager.getVariableResolverProvider());
    }

    public void testSetVariableResolverProvider() throws Exception {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        AbstractDTVariableResolver variableResolver = manager.getVariableResolver();
        manager.setVariableResolverProvider("foo.bar.variableResolver");
        TestDesignTimeApplicationManager.assertEquals((String)"foo.bar.variableResolver", (String)manager.getVariableResolverProvider());
        TestDesignTimeApplicationManager.assertEquals((Object)variableResolver, (Object)manager.getVariableResolver());
    }

    public void testSetPropertyResolverProvider() throws Exception {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        AbstractDTPropertyResolver propertyResolver = manager.getPropertyResolver();
        manager.setPropertyResolverProvider("foo.bar.propertyResolver");
        TestDesignTimeApplicationManager.assertEquals((String)"foo.bar.propertyResolver", (String)manager.getPropertyResolverProvider());
        TestDesignTimeApplicationManager.assertEquals((Object)propertyResolver, (Object)manager.getPropertyResolver());
    }

    public void testSetMethodResolverProvider() throws Exception {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        AbstractDTMethodResolver methodResolver = manager.getMethodResolver();
        manager.setMethodResolverProvider("foo.bar.methodResolver");
        TestDesignTimeApplicationManager.assertEquals((String)"foo.bar.methodResolver", (String)manager.getMethodResolverProvider());
        TestDesignTimeApplicationManager.assertEquals((Object)methodResolver, (Object)manager.getMethodResolver());
    }

    public void testSetExternalContextProvider() throws Exception {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        DTFacesContext facesContext = manager.getFacesContext(this._testJSP);
        IDTExternalContext externalContext = facesContext.getDTExternalContext((IAdaptable)this._testJSP);
        TestDesignTimeApplicationManager.assertTrue((boolean)(externalContext instanceof DTJSPExternalContext));
        manager.setExternalContextProvider("foo.bar.externalContextLocator");
        TestDesignTimeApplicationManager.assertEquals((String)"foo.bar.externalContextLocator", (String)manager.getExternalContextProvider());
        TestDesignTimeApplicationManager.assertTrue((boolean)(facesContext.getDTExternalContext((IAdaptable)this._testJSP) instanceof DTJSPExternalContext));
    }

    public void testGetPropertyResolverProvider() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        TestDesignTimeApplicationManager.assertEquals((String)"org.eclipse.jst.jsf.core.propertyresolver.default.decorative", (String)manager.getPropertyResolverProvider());
    }

    public void testGetViewHandler() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        IDTViewHandler viewHandler = manager.getViewHandler();
        TestDesignTimeApplicationManager.assertNotNull((Object)viewHandler);
        TestDesignTimeApplicationManager.assertTrue((boolean)(viewHandler instanceof DefaultDTViewHandler));
    }

    public void testSetViewHandler() throws Exception {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP.getProject());
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        IFile settingsFile = TestDesignTimeApplicationManager.getSettingsFile(this._testJSP.getProject());
        TestDesignTimeApplicationManager.assertFalse((boolean)settingsFile.isAccessible());
        manager.setViewHandlerId("foobar.chicken.on.a.bun");
        TestDesignTimeApplicationManager.assertTrue((boolean)settingsFile.isAccessible());
        Properties props = new Properties();
        props.load(settingsFile.getContents());
        TestDesignTimeApplicationManager.assertEquals((String)"foobar.chicken.on.a.bun", (String)props.getProperty("ViewHandler"));
    }

    public void testSetAndReloadSettings() throws Exception {
        IProject project = this._testJSP.getProject();
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)project);
        TestDesignTimeApplicationManager.assertNotNull((Object)manager);
        IFile settingsFile = TestDesignTimeApplicationManager.getSettingsFile(project);
        TestDesignTimeApplicationManager.assertFalse((boolean)settingsFile.isAccessible());
        manager.setViewHandlerId("foobar.chicken.on.a.bun");
        TestDesignTimeApplicationManager.assertTrue((boolean)settingsFile.isAccessible());
        Properties props = new Properties();
        props.load(settingsFile.getContents());
        TestDesignTimeApplicationManager.assertEquals((String)"foobar.chicken.on.a.bun", (String)props.getProperty("ViewHandler"));
        project.close(null);
        TestDesignTimeApplicationManager.assertFalse((boolean)project.isOpen());
        project.open(null);
        TestDesignTimeApplicationManager.assertTrue((boolean)project.isOpen());
        DesignTimeApplicationManager newManager = DesignTimeApplicationManager.getInstance((IProject)project);
        TestDesignTimeApplicationManager.assertNotNull((Object)newManager.getViewHandler());
    }

    private static IFile getSettingsFile(IProject project) {
        return project.getFolder((IPath)new Path(".settings")).getFile("org.eclipse.jst.jsf.designtime.appmgr.prefs");
    }
}

