/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.queue;

import java.util.ArrayList;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.queue.ArrayQueue;
import org.eclipse.jpt.common.utility.internal.queue.QueueTools;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.queue.QueueTests;

public class ArrayQueueTests
extends QueueTests {
    public ArrayQueueTests(String name) {
        super(name);
    }

    @Override
    Queue<String> buildQueue() {
        return QueueTools.arrayQueue();
    }

    public void testConstructor_IAE() {
        boolean exCaught = false;
        try {
            ArrayQueue queue = QueueTools.arrayQueue((int)-1);
            ArrayQueueTests.fail((String)("bogus deque: " + queue));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ArrayQueueTests.assertTrue((boolean)exCaught);
    }

    public void testEnsureCapacity() {
        ArrayQueue queue = QueueTools.arrayQueue((int)0);
        queue.ensureCapacity(7);
        ArrayQueueTests.assertEquals((int)7, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
    }

    public void testTrimToSize() {
        ArrayQueue queue = QueueTools.arrayQueue((int)10);
        queue.enqueue((Object)"foo");
        queue.enqueue((Object)"bar");
        queue.trimToSize();
        ArrayQueueTests.assertEquals((int)2, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
    }

    public void testTrimToSize_noChange() {
        ArrayQueue queue = QueueTools.arrayQueue((int)2);
        queue.enqueue((Object)"foo");
        queue.enqueue((Object)"bar");
        queue.trimToSize();
        ArrayQueueTests.assertEquals((int)2, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
    }

    public void testCollectionConstructor() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("first");
        c.add("second");
        c.add("third");
        c.add("fourth");
        c.add("fifth");
        c.add("sixth");
        c.add("seventh");
        c.add("eighth");
        c.add("ninth");
        c.add("tenth");
        ArrayQueue queue = QueueTools.arrayQueue(c);
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"first", (String)((String)queue.peek()));
        queue.enqueue((Object)"eleventh");
        queue.enqueue((Object)"twelfth");
        ArrayQueueTests.assertEquals((String)"first", (String)((String)queue.peek()));
        ArrayQueueTests.assertEquals((String)"first", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"second", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"third", (String)((String)queue.peek()));
        ArrayQueueTests.assertEquals((String)"third", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fourth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fifth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"sixth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"seventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eighth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"ninth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"tenth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eleventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"twelfth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testWrappedElements() {
        Queue<String> queue = this.buildQueue();
        ArrayQueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)"first");
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"second");
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"third");
        queue.enqueue((Object)"fourth");
        queue.enqueue((Object)"fifth");
        queue.enqueue((Object)"sixth");
        ArrayQueueTests.assertEquals((String)"first", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"second", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"third", (String)((String)queue.dequeue()));
        queue.enqueue((Object)"seventh");
        queue.enqueue((Object)"eighth");
        queue.enqueue((Object)"ninth");
        queue.enqueue((Object)"tenth");
        queue.enqueue((Object)"eleventh");
        queue.enqueue((Object)"twelfth");
        ArrayQueueTests.assertEquals((String)"fourth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fifth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"sixth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"seventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eighth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"ninth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"tenth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eleventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"twelfth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceeded() {
        Queue<String> queue = this.buildQueue();
        ArrayQueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)"first");
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"second");
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"third");
        queue.enqueue((Object)"fourth");
        queue.enqueue((Object)"fifth");
        queue.enqueue((Object)"sixth");
        queue.enqueue((Object)"seventh");
        queue.enqueue((Object)"eighth");
        queue.enqueue((Object)"ninth");
        queue.enqueue((Object)"tenth");
        queue.enqueue((Object)"eleventh");
        queue.enqueue((Object)"twelfth");
        ArrayQueueTests.assertEquals((String)"first", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"second", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"third", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fourth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fifth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"sixth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"seventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eighth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"ninth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"tenth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eleventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"twelfth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceededWithWrappedElements() {
        Queue<String> queue = this.buildQueue();
        ArrayQueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)"first");
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"second");
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"third");
        queue.enqueue((Object)"fourth");
        queue.enqueue((Object)"fifth");
        queue.enqueue((Object)"sixth");
        ArrayQueueTests.assertEquals((String)"first", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"second", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertFalse((boolean)queue.isEmpty());
        ArrayQueueTests.assertEquals((String)"third", (String)((String)queue.dequeue()));
        queue.enqueue((Object)"seventh");
        queue.enqueue((Object)"eighth");
        queue.enqueue((Object)"ninth");
        queue.enqueue((Object)"tenth");
        queue.enqueue((Object)"eleventh");
        queue.enqueue((Object)"twelfth");
        queue.enqueue((Object)"thirteenth");
        queue.enqueue((Object)"fourteenth");
        queue.enqueue((Object)"fifteenth");
        ArrayQueueTests.assertEquals((String)"fourth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fifth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"sixth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"seventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eighth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"ninth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"tenth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"eleventh", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"twelfth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"thirteenth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fourteenth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertEquals((String)"fifteenth", (String)((String)queue.dequeue()));
        ArrayQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testSerialization_empty() throws Exception {
        ArrayQueue original = new ArrayQueue(3);
        Queue clone = (Queue)TestTools.serialize(original);
        ArrayQueueTests.assertNotSame((Object)original, (Object)clone);
        ArrayQueueTests.assertTrue((boolean)original.isEmpty());
        ArrayQueueTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueue((Object)"fourth");
        ArrayQueueTests.assertFalse((boolean)original.isEmpty());
        ArrayQueueTests.assertTrue((boolean)clone.isEmpty());
    }

    public void testSerialization_fullArray() throws Exception {
        ArrayQueue queue = new ArrayQueue(3);
        queue.enqueue((Object)"first");
        queue.enqueue((Object)"second");
        queue.enqueue((Object)"third");
        this.verifyClone((Queue<String>)queue, (Queue<String>)((Queue)TestTools.serialize(queue)));
    }

    public void testSerialization_wrappedArray() throws Exception {
        ArrayQueue queue = new ArrayQueue(3);
        queue.enqueue((Object)"first");
        queue.enqueue((Object)"second");
        queue.enqueue((Object)"third");
        queue.dequeue();
        queue.enqueue((Object)"fourth");
        this.verifyClone((Queue<String>)queue, (Queue<String>)((Queue)TestTools.serialize(queue)));
    }
}

