/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.converter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.common.ui.internal.utils.ResourceUtils;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.converter.AbstractTagConverter;
import org.eclipse.jst.pagedesigner.dom.DOMUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class HTMLStringTagConverter
extends AbstractTagConverter {
    static Logger _log = PDPlugin.getLogger(HTMLStringTagConverter.class);

    public HTMLStringTagConverter(Element host) {
        super(host);
    }

    protected Element doConvertRefresh() {
        Element element;
        ByteArrayInputStream stream = null;
        try {
            String id = System.currentTimeMillis() + ".html";
            IModelManager manager = StructuredModelManager.getModelManager();
            stream = new ByteArrayInputStream(this.getGeneratedHTML().getBytes());
            IDOMModel model = (IDOMModel)manager.getModelForRead(id, (InputStream)stream, null);
            Element root = model.getDocument().getDocumentElement();
            Element resultEle = (Element)DOMUtil.cloneNodeDeepIgnoreError((Document)this.getDestDocument(), root);
            model.releaseFromRead();
            element = resultEle;
        }
        catch (Exception ex) {
            Element element2;
            try {
                _log.error("Log.Error.HTMLStringTagConverter.Error", (Throwable)ex);
                Element temp = this.createElement("div");
                temp.appendChild(this.createText("Error loading: " + ex.getMessage()));
                element2 = temp;
            }
            catch (Throwable throwable) {
                ResourceUtils.ensureClosed(stream);
                throw throwable;
            }
            ResourceUtils.ensureClosed((InputStream)stream);
            return element2;
        }
        ResourceUtils.ensureClosed((InputStream)stream);
        return element;
    }

    public abstract String getGeneratedHTML() throws Exception;

    public boolean isMultiLevel() {
        return true;
    }

    public boolean isWidget() {
        return true;
    }
}

