/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ListModelAdapter;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.model.value.CoordinatedBag;
import org.eclipse.jpt.common.utility.tests.internal.model.value.CoordinatedList;

public class ListCollectionValueModelAdapterTests
extends TestCase {
    CollectionValueModel<String> adapter;
    private SimpleListValueModel<String> wrappedListHolder;
    private List<String> wrappedList;

    public ListCollectionValueModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.wrappedList = new ArrayList<String>();
        this.wrappedListHolder = new SimpleListValueModel(this.wrappedList);
        this.adapter = new ListCollectionValueModelAdapter(this.wrappedListHolder);
    }

    private Collection<String> wrappedCollection() {
        return CollectionTools.hashBag(this.wrappedList.iterator());
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator() {
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)new TestListener(this){

            @Override
            public void itemsAdded(CollectionAddEvent e) {
            }
        });
        this.wrappedListHolder.add(0, (Object)"foo");
        this.wrappedListHolder.add(1, (Object)"bar");
        this.wrappedListHolder.add(2, (Object)"baz");
        HashBag adapterCollection = CollectionTools.hashBag((Iterator)this.adapter.iterator());
        ListCollectionValueModelAdapterTests.assertEquals((int)3, (int)adapterCollection.size());
        ListCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), (Object)adapterCollection);
    }

    public void testStaleValues() {
        TestListener listener = new TestListener(this){

            @Override
            public void itemsAdded(CollectionAddEvent e) {
            }
        };
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)listener);
        this.wrappedListHolder.add(0, (Object)"foo");
        this.wrappedListHolder.add(1, (Object)"bar");
        this.wrappedListHolder.add(2, (Object)"baz");
        HashBag adapterCollection = CollectionTools.hashBag((Iterator)this.adapter.iterator());
        ListCollectionValueModelAdapterTests.assertEquals((int)3, (int)adapterCollection.size());
        ListCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), (Object)adapterCollection);
        this.adapter.removeCollectionChangeListener("values", (CollectionChangeListener)listener);
        adapterCollection = CollectionTools.hashBag((Iterator)this.adapter.iterator());
        ListCollectionValueModelAdapterTests.assertEquals((int)0, (int)adapterCollection.size());
        ListCollectionValueModelAdapterTests.assertEquals((Object)new HashBag(), (Object)adapterCollection);
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)listener);
        adapterCollection = CollectionTools.hashBag((Iterator)this.adapter.iterator());
        ListCollectionValueModelAdapterTests.assertEquals((int)3, (int)adapterCollection.size());
        ListCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), (Object)adapterCollection);
    }

    public void testAdd() {
        CoordinatedBag<String> synchCollection = new CoordinatedBag<String>(this.adapter);
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListValueModel<String>)this.wrappedListHolder);
        this.wrappedListHolder.add(0, (Object)"foo");
        ListCollectionValueModelAdapterTests.assertTrue((boolean)this.wrappedList.contains("foo"));
        this.wrappedListHolder.add(1, (Object)"bar");
        this.wrappedListHolder.add(2, (Object)"baz");
        this.wrappedListHolder.add(3, (Object)"joo");
        this.wrappedListHolder.add(4, (Object)"jar");
        this.wrappedListHolder.add(5, (Object)"jaz");
        ListCollectionValueModelAdapterTests.assertEquals((int)6, (int)this.wrappedList.size());
        HashBag adapterCollection = CollectionTools.hashBag((Iterator)this.adapter.iterator());
        ListCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), (Object)adapterCollection);
        ListCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), (Object)CollectionTools.hashBag(synchList.iterator()));
        ListCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), synchCollection);
    }

    public void testRemove() {
        CoordinatedBag<String> synchCollection = new CoordinatedBag<String>(this.adapter);
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListValueModel<String>)this.wrappedListHolder);
        this.wrappedListHolder.add(0, (Object)"foo");
        this.wrappedListHolder.add(1, (Object)"bar");
        this.wrappedListHolder.add(2, (Object)"baz");
        this.wrappedListHolder.add(3, (Object)"joo");
        this.wrappedListHolder.add(4, (Object)"jar");
        this.wrappedListHolder.add(5, (Object)"jaz");
        ListCollectionValueModelAdapterTests.assertEquals((String)"jaz", (String)((String)this.wrappedListHolder.remove(5)));
        ListCollectionValueModelAdapterTests.assertFalse((boolean)this.wrappedList.contains("jaz"));
        ListCollectionValueModelAdapterTests.assertEquals((String)"foo", (String)((String)this.wrappedListHolder.remove(0)));
        ListCollectionValueModelAdapterTests.assertFalse((boolean)this.wrappedList.contains("foo"));
        ListCollectionValueModelAdapterTests.assertEquals((int)4, (int)this.wrappedList.size());
        HashBag adapterCollection = CollectionTools.hashBag((Iterator)this.adapter.iterator());
        ListCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), (Object)adapterCollection);
        ListCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), (Object)CollectionTools.hashBag(synchList.iterator()));
        ListCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), synchCollection);
    }

    public void testListSynch() {
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)new TestListener(this){

            @Override
            public void itemsAdded(CollectionAddEvent e) {
            }

            @Override
            public void itemsRemoved(CollectionRemoveEvent e) {
            }
        });
        this.wrappedListHolder.add(0, (Object)"foo");
        this.wrappedListHolder.add(1, (Object)"bar");
        this.wrappedListHolder.add(2, (Object)"baz");
        this.wrappedListHolder.add(3, (Object)"joo");
        this.wrappedListHolder.add(4, (Object)"jar");
        this.wrappedListHolder.add(5, (Object)"jaz");
        this.wrappedListHolder.remove(5);
        ListCollectionValueModelAdapterTests.assertFalse((boolean)this.wrappedList.contains("jaz"));
        this.wrappedListHolder.remove(0);
        ListCollectionValueModelAdapterTests.assertFalse((boolean)this.wrappedList.contains("foo"));
        ListCollectionValueModelAdapterTests.assertEquals((int)4, (int)this.wrappedList.size());
        HashBag adapterCollection = CollectionTools.hashBag((Iterator)this.adapter.iterator());
        ListCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), (Object)adapterCollection);
    }

    public void testReplace() {
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)new TestListener(this){

            @Override
            public void itemsAdded(CollectionAddEvent e) {
            }

            @Override
            public void itemsRemoved(CollectionRemoveEvent e) {
            }
        });
        this.wrappedListHolder.add(0, (Object)"foo");
        this.wrappedListHolder.add(1, (Object)"bar");
        this.wrappedListHolder.add(2, (Object)"baz");
        HashBag adapterCollection = CollectionTools.hashBag((Iterator)this.adapter.iterator());
        ListCollectionValueModelAdapterTests.assertEquals((int)3, (int)adapterCollection.size());
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)new TestListener(this){

            @Override
            public void itemsRemoved(CollectionRemoveEvent e) {
                ListCollectionValueModelAdapterTests.assertEquals((Object)"foo", e.getItems().iterator().next());
                ListCollectionValueModelAdapterTests.assertFalse((boolean)IteratorTools.contains((Iterator)adapter.iterator(), (Object)"joo"));
                ListCollectionValueModelAdapterTests.assertEquals((int)2, (int)adapter.size());
            }

            @Override
            public void itemsAdded(CollectionAddEvent e) {
                ListCollectionValueModelAdapterTests.assertEquals((Object)"joo", e.getItems().iterator().next());
                ListCollectionValueModelAdapterTests.assertEquals((int)3, (int)adapter.size());
            }
        });
        this.wrappedListHolder.set(0, (Object)"joo");
        adapterCollection = CollectionTools.hashBag((Iterator)this.adapter.iterator());
        ListCollectionValueModelAdapterTests.assertEquals((int)3, (int)adapterCollection.size());
        ListCollectionValueModelAdapterTests.assertEquals(this.wrappedCollection(), (Object)adapterCollection);
    }

    public void testHasListeners() {
        ListCollectionValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyCollectionChangeListeners("values"));
        CoordinatedBag<String> synchCollection = new CoordinatedBag<String>(this.adapter);
        ListCollectionValueModelAdapterTests.assertTrue((boolean)((AbstractModel)this.adapter).hasAnyCollectionChangeListeners("values"));
        this.adapter.removeCollectionChangeListener("values", synchCollection);
        ListCollectionValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyCollectionChangeListeners("values"));
        ChangeAdapter cl = new ChangeAdapter();
        this.adapter.addChangeListener((ChangeListener)cl);
        ListCollectionValueModelAdapterTests.assertTrue((boolean)((AbstractModel)this.adapter).hasAnyCollectionChangeListeners("values"));
        this.adapter.removeChangeListener((ChangeListener)cl);
        ListCollectionValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyCollectionChangeListeners("values"));
    }

    public void testListChangedToEmpty() {
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)new TestListener(this){

            @Override
            public void itemsAdded(CollectionAddEvent e) {
            }

            @Override
            public void collectionCleared(CollectionClearEvent e) {
            }
        });
        this.wrappedListHolder.add(0, (Object)"foo");
        this.wrappedListHolder.add(1, (Object)"bar");
        this.wrappedListHolder.add(2, (Object)"baz");
        JList jList = new JList(new ListModelAdapter(this.adapter));
        this.wrappedListHolder.setListValues(new ArrayList());
        ListCollectionValueModelAdapterTests.assertEquals((int)0, (int)jList.getModel().getSize());
    }

    public void testCollectionChangedFromEmpty() {
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)new TestListener(this){

            @Override
            public void itemsAdded(CollectionAddEvent e) {
            }

            @Override
            public void itemsRemoved(CollectionRemoveEvent e) {
            }
        });
        JList jList = new JList(new ListModelAdapter(this.adapter));
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        list.add("bar");
        this.wrappedListHolder.setListValues(list);
        ListCollectionValueModelAdapterTests.assertEquals((int)2, (int)jList.getModel().getSize());
    }

    public void testCollectionChangedFromEmptyToEmpty() {
        this.adapter.addCollectionChangeListener("values", (CollectionChangeListener)new TestListener(this){

            @Override
            public void itemsAdded(CollectionAddEvent e) {
            }

            @Override
            public void itemsRemoved(CollectionRemoveEvent e) {
            }
        });
        JList jList = new JList(new ListModelAdapter(this.adapter));
        ArrayList list = new ArrayList();
        this.wrappedListHolder.setListValues(list);
        ListCollectionValueModelAdapterTests.assertEquals((int)0, (int)jList.getModel().getSize());
    }

    class TestListener
    implements CollectionChangeListener {
        TestListener() {
        }

        public void itemsAdded(CollectionAddEvent e) {
            ListCollectionValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void itemsRemoved(CollectionRemoveEvent e) {
            ListCollectionValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void collectionCleared(CollectionClearEvent e) {
            ListCollectionValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void collectionChanged(CollectionChangeEvent e) {
            ListCollectionValueModelAdapterTests.fail((String)"unexpected event");
        }
    }
}

