/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.encoding.util.NullInputStream;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModelModifications
extends TestCase {
    public void testPlainDocument() throws BadLocationException {
        Document document = new Document();
        document.set("");
        document.replace(0, 0, "test");
        document.set("");
        document.replace(0, 0, "test2");
        ModelModifications.assertTrue((boolean)true);
    }

    public void testRepDocumentHTMLMods() throws UnsupportedEncodingException, IOException {
        IDOMModel model = null;
        model = ModelModifications.createHTMLModel();
        try {
            IDOMDocument doc = model.getDocument();
            Element ele = doc.createElement("P");
            doc.appendChild((Node)ele);
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.replaceText((Object)this, 0, structuredDocument.getLength(), "<tag>text</tag>");
            Element ele2 = doc.createElement("P");
            doc.appendChild((Node)ele2);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testSetDocumentXMLMods() throws UnsupportedEncodingException, IOException {
        IDOMModel model = null;
        model = ModelModifications.createXMLModel();
        try {
            IDOMDocument doc = model.getDocument();
            Element ele = doc.createElement("P");
            doc.appendChild((Node)ele);
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.setText((Object)this, "");
            Element ele2 = doc.createElement("P");
            doc.appendChild((Node)ele2);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testRepDocumentJSPMods() throws UnsupportedEncodingException, IOException {
        IDOMModel model = null;
        model = ModelModifications.createJSPModel();
        try {
            IDOMDocument doc = model.getDocument();
            Element ele = doc.createElement("P");
            doc.appendChild((Node)ele);
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.replaceText((Object)this, 0, structuredDocument.getLength(), "<tag>text</tag>");
            Element ele2 = doc.createElement("P");
            doc.appendChild((Node)ele2);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testSetDocumentHTMLMods() throws UnsupportedEncodingException, IOException {
        IDOMModel model = null;
        model = ModelModifications.createHTMLModel();
        try {
            IDOMDocument doc = model.getDocument();
            Element ele = doc.createElement("P");
            doc.appendChild((Node)ele);
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.setText((Object)this, "");
            Element ele2 = doc.createElement("P");
            doc.appendChild((Node)ele2);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testSetDocumentJSPMods() throws UnsupportedEncodingException, IOException {
        IDOMModel model = null;
        model = ModelModifications.createJSPModel();
        try {
            IDOMDocument doc = model.getDocument();
            Element ele = doc.createElement("P");
            doc.appendChild((Node)ele);
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.setText((Object)this, "");
            Element ele2 = doc.createElement("P");
            doc.appendChild((Node)ele2);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testRepDocumentXMLMods() throws UnsupportedEncodingException, IOException {
        IDOMModel model = null;
        model = ModelModifications.createXMLModel();
        try {
            IDOMDocument doc = model.getDocument();
            Element ele = doc.createElement("P");
            doc.appendChild((Node)ele);
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.replaceText((Object)this, 0, structuredDocument.getLength(), "<tag>text</tag>");
            Element ele2 = doc.createElement("P");
            doc.appendChild((Node)ele2);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testDocumentHTMLMods() throws UnsupportedEncodingException, IOException {
        IDOMModel model = null;
        model = ModelModifications.createHTMLModel();
        try {
            IDOMDocument doc = model.getDocument();
            Element ele = doc.createElement("P");
            doc.appendChild((Node)ele);
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.replaceText((Object)this, 0, structuredDocument.getLength(), "");
            Element ele2 = doc.createElement("P");
            doc.appendChild((Node)ele2);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testDocumentJSPMods() throws UnsupportedEncodingException, IOException {
        IDOMModel model = null;
        model = ModelModifications.createJSPModel();
        try {
            IDOMDocument doc = model.getDocument();
            Element ele = doc.createElement("P");
            doc.appendChild((Node)ele);
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.replaceText((Object)this, 0, structuredDocument.getLength(), "");
            Element ele2 = doc.createElement("P");
            doc.appendChild((Node)ele2);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testDocumentXMLMods() throws UnsupportedEncodingException, IOException {
        IDOMModel model = null;
        model = ModelModifications.createXMLModel();
        try {
            IDOMDocument doc = model.getDocument();
            Element ele = doc.createElement("P");
            doc.appendChild((Node)ele);
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.replaceText((Object)this, 0, structuredDocument.getLength(), "");
            Element ele2 = doc.createElement("P");
            doc.appendChild((Node)ele2);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    private static IDOMModel createXMLModel() throws UnsupportedEncodingException, IOException {
        IStructuredModel model = null;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        model = modelManager.getModelForEdit("test.xml", (InputStream)new NullInputStream(), null);
        model.getStructuredDocument().setLineDelimiter("\r\n");
        return (IDOMModel)model;
    }

    private static IDOMModel createHTMLModel() throws UnsupportedEncodingException, IOException {
        IStructuredModel model = null;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        model = modelManager.getModelForEdit("test.html", (InputStream)new NullInputStream(), null);
        model.getStructuredDocument().setLineDelimiter("\r\n");
        return (IDOMModel)model;
    }

    private static IDOMModel createJSPModel() throws UnsupportedEncodingException, IOException {
        IStructuredModel model = null;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        model = modelManager.getModelForEdit("test.xml", (InputStream)new NullInputStream(), null);
        model.getStructuredDocument().setLineDelimiter("\r\n");
        return (IDOMModel)model;
    }
}

