/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions.pinpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.chromium.DebugContext;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsObject;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Value;
import org.eclipse.wst.jsdt.chromium.debug.ui.DialogUtils;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.pinpoint.DialogImpl;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.pinpoint.Messages;

class DialogLogic {
    DialogLogic() {
    }

    static Handle buildDialogLogic(final DialogImpl.Elements elements, final DialogImpl.DialogPreferencesStore dialogPreferencesStore, Value uiValue) {
        final DialogUtils.Updater updater = new DialogUtils.Updater();
        DialogUtils.Scope rootScope = updater.rootScope();
        ArrayList<DialogUtils.ValueSource<String>> warningSources = new ArrayList<DialogUtils.ValueSource<String>>(2);
        final DialogUtils.ValueSource<String> propertyExpressionEditorValue = new DialogUtils.ValueSource<String>(elements, dialogPreferencesStore, updater){
            private final Text textElement;
            {
                this.textElement = elements.getExpressionText();
                String text = dialogPreferencesStore.getExpressionText();
                this.textElement.setText(text);
                int selectionStart = text.startsWith(".") ? 1 : 0;
                this.textElement.setSelection(selectionStart, text.length());
                DialogUtils.addModifyListener(this.textElement, this, updater);
            }

            @Override
            public String getValue() {
                return this.textElement.getText();
            }
        };
        updater.addSource(rootScope, propertyExpressionEditorValue);
        final DialogUtils.ValueSource<DialogUtils.Optional<PreviewContext>> evaluatorValue = DialogUtils.createConstant(PreviewContext.build(uiValue), updater);
        final DialogUtils.ValueProcessor<DialogUtils.Optional<Expression>> parsedPropertyExpressionValue = DialogUtils.createProcessor(new DialogUtils.Gettable<DialogUtils.Optional<Expression>>(){

            @Override
            public DialogUtils.Optional<Expression> getValue() {
                return DialogLogic.parseExpression((String)propertyExpressionEditorValue.getValue());
            }
        });
        updater.addConsumer(rootScope, parsedPropertyExpressionValue);
        updater.addSource(rootScope, parsedPropertyExpressionValue);
        updater.addDependency(parsedPropertyExpressionValue, propertyExpressionEditorValue);
        DialogUtils.ValueSource<Boolean> previewCheckBoxValue = new DialogUtils.ValueSource<Boolean>(elements, dialogPreferencesStore, updater){
            private final Button checkBox;
            {
                this.checkBox = elements.getPreviewCheckBox();
                this.checkBox.setSelection(dialogPreferencesStore.getPreviewCheck());
                DialogUtils.addModifyListener(this.checkBox, this, updater);
            }

            @Override
            public Boolean getValue() {
                return this.checkBox.getSelection();
            }
        };
        DialogUtils.Switcher<Boolean> checkerSwitch = rootScope.addSwitch(previewCheckBoxValue);
        PreviewSwitchOutput switchBlockOutput = DialogLogic.fillShowPreviewSwitch(checkerSwitch, updater, rootScope, elements, evaluatorValue, parsedPropertyExpressionValue);
        warningSources.add(switchBlockOutput.warningSource());
        final DialogUtils.ValueSource<Boolean> addWatchExpressionValue = new DialogUtils.ValueSource<Boolean>(elements, dialogPreferencesStore, updater){
            private final Button checkBox;
            {
                this.checkBox = elements.getAddWatchCheckBox();
                this.checkBox.setSelection(dialogPreferencesStore.getAddWatchExpression());
                DialogUtils.addModifyListener(this.checkBox, this, updater);
            }

            @Override
            public Boolean getValue() {
                return this.checkBox.getSelection();
            }
        };
        updater.addSource(rootScope, addWatchExpressionValue);
        DialogUtils.ValueProcessor<DialogUtils.Optional<Runnable>> okRunnable = DialogUtils.createProcessor(DialogUtils.handleErrors(new DialogUtils.NormalExpression<Runnable>(){

            @DialogUtils.NormalExpression.Calculate
            public Runnable calculate(PreviewContext previewContext, Expression expression) {
                return new OkRunnable(elements.getParentShell(), expression, previewContext, (Boolean)addWatchExpressionValue.getValue());
            }

            @DialogUtils.NormalExpression.DependencyGetter
            public DialogUtils.ValueSource<DialogUtils.Optional<PreviewContext>> previewContextSource() {
                return evaluatorValue;
            }

            @DialogUtils.NormalExpression.DependencyGetter
            public DialogUtils.ValueSource<DialogUtils.Optional<Expression>> parsedPropertyExpressionSource() {
                return parsedPropertyExpressionValue;
            }
        }));
        updater.addSource(rootScope, okRunnable);
        updater.addConsumer(rootScope, okRunnable);
        updater.addDependency(okRunnable, evaluatorValue);
        updater.addDependency(okRunnable, parsedPropertyExpressionValue);
        updater.addDependency(okRunnable, addWatchExpressionValue);
        final DialogUtils.OkButtonControl<Runnable> okButtonControl = new DialogUtils.OkButtonControl<Runnable>(okRunnable, warningSources, elements);
        updater.addConsumer(rootScope, okButtonControl);
        updater.addDependency(okButtonControl, okButtonControl.getDependencies());
        return new Handle(){

            @Override
            public void updateAll() {
                updater.updateAll();
            }

            @Override
            public Runnable getOkRunnable() {
                return (Runnable)okButtonControl.getNormalValue();
            }

            @Override
            public void saveStateInStore() {
                dialogPreferencesStore.setExpressionText(elements.getExpressionText().getText());
                dialogPreferencesStore.setPreviewCheck(elements.getPreviewCheckBox().getSelection());
                dialogPreferencesStore.setAddWatchExpression(elements.getAddWatchCheckBox().getSelection());
            }
        };
    }

    private static PreviewSwitchOutput fillShowPreviewSwitch(DialogUtils.Switcher<Boolean> switcher, DialogUtils.Updater updater, DialogUtils.Scope scope, final DialogImpl.Elements elements, DialogUtils.ValueSource<DialogUtils.Optional<PreviewContext>> evaluatorValue, DialogUtils.ValueProcessor<DialogUtils.Optional<Expression>> parsedPropertyNameValue) {
        DialogUtils.Scope checkerScope = switcher.addScope(Boolean.TRUE, new DialogUtils.ScopeEnabler(){

            @Override
            public void setEnabled(boolean enabled, boolean recursive) {
                elements.getPreviewDisplay().setEnabled(enabled);
            }
        });
        PreviewSwitchOutput checkDisplayCase = DialogLogic.fillCheckDisplayCase(updater, checkerScope, elements, evaluatorValue, parsedPropertyNameValue);
        switcher.addScope(Boolean.FALSE, null);
        final PreviewSwitchOutput mergedOutput = DialogUtils.mergeBranchVariables(PreviewSwitchOutput.class, switcher, checkDisplayCase, null);
        return new PreviewSwitchOutput(){

            @Override
            public DialogUtils.ValueSource<String> warningSource() {
                return mergedOutput.warningSource();
            }
        };
    }

    private static PreviewSwitchOutput fillCheckDisplayCase(DialogUtils.Updater updater, DialogUtils.Scope scope, final DialogImpl.Elements elements, DialogUtils.ValueSource<DialogUtils.Optional<PreviewContext>> evaluatorValue, DialogUtils.ValueProcessor<DialogUtils.Optional<Expression>> parsedPropertyNameValue) {
        final CheckerResultProcessor checkerResultSource = new CheckerResultProcessor(evaluatorValue, parsedPropertyNameValue, updater);
        updater.addConsumer(scope, checkerResultSource);
        updater.addSource(scope, checkerResultSource);
        updater.addSource(scope, checkerResultSource.getWarningSource());
        updater.addDependency((DialogUtils.ValueConsumer)checkerResultSource, evaluatorValue);
        updater.addDependency((DialogUtils.ValueConsumer)checkerResultSource, parsedPropertyNameValue);
        DialogUtils.ValueConsumer checkerResultConsumer = new DialogUtils.ValueConsumer(){

            @Override
            public void update(DialogUtils.Updater updater) {
                elements.getPreviewDisplay().setText(checkerResultSource.getValue());
            }
        };
        updater.addConsumer(scope, checkerResultConsumer);
        updater.addDependency(checkerResultConsumer, checkerResultSource);
        return new PreviewSwitchOutput(){

            @Override
            public DialogUtils.ValueSource<String> warningSource() {
                return checkerResultSource.getWarningSource();
            }
        };
    }

    private static DialogUtils.Optional<Expression> parseExpression(String string) {
        return DotSeparatedExpression.parse(string);
    }

    private static class CheckerResultProcessor
    implements DialogUtils.ValueSource<String>,
    DialogUtils.ValueConsumer {
        private final DialogUtils.ValueSource<DialogUtils.Optional<PreviewContext>> previewContextValue;
        private final DialogUtils.ValueProcessor<DialogUtils.Optional<Expression>> parsedExpressionValue;
        private final DialogUtils.Updater updater;
        private final Monitor monitor = new Monitor();
        private final DialogUtils.ValueSource<String> warningSource = new DialogUtils.ValueSource<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getValue() {
                Monitor monitor = CheckerResultProcessor.this.monitor;
                synchronized (monitor) {
                    return ((CheckerResultProcessor)CheckerResultProcessor.this).monitor.additionalWarning;
                }
            }
        };

        public CheckerResultProcessor(DialogUtils.ValueSource<DialogUtils.Optional<PreviewContext>> previewContextValue, DialogUtils.ValueProcessor<DialogUtils.Optional<Expression>> parsedPropertyNameValue, DialogUtils.Updater updater) {
            this.previewContextValue = previewContextValue;
            this.parsedExpressionValue = parsedPropertyNameValue;
            this.updater = updater;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getValue() {
            Monitor monitor = this.monitor;
            synchronized (monitor) {
                return this.monitor.currentValue;
            }
        }

        DialogUtils.ValueSource<String> getWarningSource() {
            return this.warningSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(DialogUtils.Updater updater) {
            int requestNumber;
            Monitor monitor = this.monitor;
            synchronized (monitor) {
                requestNumber = ++this.monitor.requestId;
            }
            String newValue = this.calculateValue(requestNumber);
            if (newValue == null) {
                return;
            }
            Monitor monitor2 = this.monitor;
            synchronized (monitor2) {
                this.monitor.currentValue = newValue;
            }
            updater.reportChanged(this);
        }

        private String calculateValue(final int requestNumber) {
            DialogUtils.Optional<PreviewContext> evaluatorOptional = this.previewContextValue.getValue();
            if (!evaluatorOptional.isNormal()) {
                return "";
            }
            PreviewContext previewContext = evaluatorOptional.getNormal();
            DialogUtils.Optional<Expression> expressionOptional = this.parsedExpressionValue.getValue();
            if (!expressionOptional.isNormal()) {
                return "";
            }
            Expression expression = expressionOptional.getNormal();
            Expression.PreviewCallback callback = new Expression.PreviewCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void done(String message, String additionalWarning) {
                    Monitor monitor = CheckerResultProcessor.this.monitor;
                    synchronized (monitor) {
                        if (((CheckerResultProcessor)CheckerResultProcessor.this).monitor.requestId != requestNumber) {
                            return;
                        }
                        ((CheckerResultProcessor)CheckerResultProcessor.this).monitor.currentValue = message;
                        ((CheckerResultProcessor)CheckerResultProcessor.this).monitor.additionalWarning = additionalWarning;
                        CheckerResultProcessor.this.updater.reportChanged(CheckerResultProcessor.this);
                        CheckerResultProcessor.this.updater.reportChanged(CheckerResultProcessor.this.warningSource);
                        CheckerResultProcessor.this.updater.updateAsync();
                    }
                }
            };
            expression.doPreview(previewContext, callback);
            return null;
        }

        private static class Monitor {
            String additionalWarning = null;
            int requestId = 1;
            String currentValue = "";

            private Monitor() {
            }
        }
    }

    private static class DotSeparatedExpression
    extends Expression {
        private final List<String> parts;
        private static final String freePropertyCode = "free";
        private static final String occupiedPropertyCode = "occupied";

        static DialogUtils.Optional<Expression> parse(String string) {
            if (string.length() == 0) {
                return DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.LogicImpl_ENTER_EXPRESSION, DialogUtils.MessagePriority.BLOCKING_PROBLEM));
            }
            ArrayList<String> parts = new ArrayList<String>();
            int pos = 0;
            do {
                if (pos >= string.length() || string.charAt(pos) != '.') {
                    return DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.LogicImpl_DOT_EXPECTED, DialogUtils.MessagePriority.BLOCKING_PROBLEM));
                }
                int partStartPos = ++pos;
                if (pos >= string.length()) {
                    return DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.LogicImpl_ENTER_AFTER_DOT, DialogUtils.MessagePriority.BLOCKING_INFO));
                }
                if (!Character.isJavaIdentifierStart(string.codePointAt(pos))) {
                    return DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.LogicImpl_INVALID_COMPONENT_START, DialogUtils.MessagePriority.BLOCKING_PROBLEM));
                }
                pos = string.offsetByCodePoints(pos, 1);
                while (pos < string.length() && string.charAt(pos) != '.') {
                    if (!Character.isJavaIdentifierPart(string.codePointAt(pos))) {
                        return DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.LogicImpl_INVALID_COMPONENT_CHAR, DialogUtils.MessagePriority.BLOCKING_PROBLEM));
                    }
                    pos = string.offsetByCodePoints(pos, 1);
                }
                parts.add(string.substring(partStartPos, pos));
            } while (pos < string.length());
            return DialogUtils.createOptional(new DotSeparatedExpression(parts));
        }

        DotSeparatedExpression(List<String> parts) {
            this.parts = parts;
        }

        @Override
        protected void doPreview(PreviewContext previewContext, final Expression.PreviewCallback callback) {
            StringBuilder builder = new StringBuilder();
            builder.append("(function() {\n");
            builder.append("var t = (function GetGlobal(){return this;})();\n");
            int i = 0;
            while (i < this.parts.size() - 1) {
                builder.append("if (\"" + this.parts.get(i) + "\" in t) { t = t." + this.parts.get(i) + "; } else { return '" + freePropertyCode + "'; }\n");
                builder.append("if (t instanceof Object == false) { throw \"Property '" + this.parts.get(i) + "' contains non-object\"}\n");
                ++i;
            }
            String lastComponent = this.parts.get(this.parts.size() - 1);
            builder.append("if (\"" + lastComponent + "\" in t) { return '" + occupiedPropertyCode + "' + String(t." + lastComponent + "); } else { return '" + freePropertyCode + "'; }\n");
            builder.append("})()");
            String expression = builder.toString();
            JsEvaluateContext.EvaluateCallback evaluateCallback = new JsEvaluateContext.EvaluateCallback(){
                private final String warningMessage = Messages.LogicImpl_WARNING_SEEMS_A_PROBLEM;

                public void success(JsEvaluateContext.ResultOrException result) {
                    result.accept((JsEvaluateContext.ResultOrException.Visitor)new JsEvaluateContext.ResultOrException.Visitor<Void>(){

                        public Void visitResult(JsValue value) {
                            this.handleSuccess(value);
                            return null;
                        }

                        public Void visitException(JsValue exception) {
                            this.handleFailure(exception.getValueString());
                            return null;
                        }
                    });
                }

                public void failure(Exception cause) {
                    this.handleFailure(cause.getMessage());
                }

                private void handleSuccess(JsValue jsValue) {
                    String warning;
                    String value;
                    String stringValue = jsValue.getValueString();
                    if (DotSeparatedExpression.freePropertyCode.equals(stringValue)) {
                        value = Messages.LogicImpl_PROPERTY_FREE;
                        warning = null;
                    } else if (stringValue.startsWith(DotSeparatedExpression.occupiedPropertyCode)) {
                        String additionalString = stringValue.substring(DotSeparatedExpression.occupiedPropertyCode.length());
                        value = String.valueOf(Messages.LogicImpl_PROPERTY_WILL_BE_OVERWRITTEN) + additionalString;
                        warning = null;
                    } else {
                        value = stringValue;
                        warning = this.warningMessage;
                    }
                    callback.done(value, warning);
                }

                private void handleFailure(String errorMessage) {
                    callback.done(String.valueOf(Messages.LogicImpl_PROBLEM_ON_REMOTE) + errorMessage, this.warningMessage);
                }
            };
            previewContext.globalEvaluateContext.evaluateAsync(expression, null, evaluateCallback, null);
        }

        @Override
        protected void execute(PreviewContext previewContext, final Expression.SetCallback callback) {
            StringBuilder builder = new StringBuilder();
            builder.append("(function() {\n");
            builder.append("var t = (function GetGlobal(){return this;})();\n");
            int i = 0;
            while (i < this.parts.size() - 1) {
                builder.append("if (\"" + this.parts.get(i) + "\" in t) { t = t." + this.parts.get(i) + "; } else { t = (t." + this.parts.get(i) + " = {}); }\n");
                ++i;
            }
            String paramJsName = "__pinPointedValue";
            String lastComponent = this.parts.get(this.parts.size() - 1);
            builder.append("t." + lastComponent + " = " + paramJsName + ";\n");
            builder.append("})()");
            String expression = builder.toString();
            JsEvaluateContext.EvaluateCallback evaluateCallback = new JsEvaluateContext.EvaluateCallback(){

                public void success(JsEvaluateContext.ResultOrException result) {
                    String errorMessage = (String)result.accept((JsEvaluateContext.ResultOrException.Visitor)new JsEvaluateContext.ResultOrException.Visitor<String>(){

                        public String visitResult(JsValue value) {
                            return null;
                        }

                        public String visitException(JsValue exception) {
                            return exception.getValueString();
                        }
                    });
                    callback.done(errorMessage);
                }

                public void failure(Exception cause) {
                    callback.done(cause.getMessage());
                }
            };
            previewContext.globalEvaluateContext.evaluateAsync(expression, Collections.singletonMap(paramJsName, previewContext.jsObject), evaluateCallback, null);
        }

        @Override
        protected String getWatchExpression() {
            StringBuilder builder = new StringBuilder();
            for (String s : this.parts) {
                if (builder.length() != 0) {
                    builder.append(".");
                }
                builder.append(s);
            }
            return builder.toString();
        }
    }

    private static abstract class Expression {
        private Expression() {
        }

        protected abstract void doPreview(PreviewContext var1, PreviewCallback var2);

        protected abstract void execute(PreviewContext var1, SetCallback var2);

        protected abstract String getWatchExpression();

        static interface PreviewCallback {
            public void done(String var1, String var2);
        }

        static interface SetCallback {
            public void done(String var1);
        }
    }

    static interface Handle {
        public void updateAll();

        public Runnable getOkRunnable();

        public void saveStateInStore();
    }

    private static class OkRunnable
    implements Runnable {
        private final Shell parentShell;
        private final Expression expression;
        private final PreviewContext previewContext;
        private final boolean addWatchExpression;

        OkRunnable(Shell parentShell, Expression expression, PreviewContext previewContext, boolean addWatchExpression) {
            this.parentShell = parentShell;
            this.expression = expression;
            this.previewContext = previewContext;
            this.addWatchExpression = addWatchExpression;
        }

        @Override
        public void run() {
            Expression.SetCallback callback = new Expression.SetCallback(){

                @Override
                public void done(final String errorMessage) {
                    if (errorMessage == null) {
                        if (OkRunnable.this.addWatchExpression) {
                            IExpressionManager expressionManager = DebugPlugin.getDefault().getExpressionManager();
                            IWatchExpression watchExpression = expressionManager.newWatchExpression(OkRunnable.this.expression.getWatchExpression());
                            expressionManager.addExpression((IExpression)watchExpression);
                        }
                    } else {
                        OkRunnable.this.parentShell.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageBox messageBox = new MessageBox(OkRunnable.this.parentShell);
                                messageBox.setText(Messages.LogicImpl_RESULT_FAILURE_TITLE);
                                messageBox.setMessage(errorMessage);
                                messageBox.open();
                            }
                        });
                    }
                }
            };
            this.expression.execute(this.previewContext, callback);
        }
    }

    private static class PreviewContext {
        final JsEvaluateContext globalEvaluateContext;
        final JsObject jsObject;

        static DialogUtils.Optional<PreviewContext> build(Value uiValue) {
            if (uiValue == null) {
                return DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.LogicImpl_VALUE_IS_NOT_AVAILABLE, DialogUtils.MessagePriority.BLOCKING_PROBLEM));
            }
            JsValue jsValue = uiValue.getJsValue();
            JsObject jsObject = jsValue.asObject();
            if (jsObject == null) {
                return DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.LogicImpl_NOT_FOR_PRIMITIVE, DialogUtils.MessagePriority.BLOCKING_PROBLEM));
            }
            DebugContext debugContext = uiValue.getSuspendedState().getDebugContext();
            if (uiValue.getSuspendedState().isDismissed()) {
                return DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.LogicImpl_CONTEXT_DISMISSED, DialogUtils.MessagePriority.BLOCKING_PROBLEM));
            }
            JsEvaluateContext globalEvaluateContext = debugContext.getGlobalEvaluateContext();
            return DialogUtils.createOptional(new PreviewContext(globalEvaluateContext, jsObject));
        }

        private PreviewContext(JsEvaluateContext globalEvaluateContext, JsObject jsObject) {
            this.globalEvaluateContext = globalEvaluateContext;
            this.jsObject = jsObject;
        }
    }

    private static interface PreviewSwitchOutput {
        @DialogUtils.BranchVariableGetter
        public DialogUtils.ValueSource<String> warningSource();
    }
}

