/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant.ISaveParticipantPreferenceConfiguration;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant.SaveParticipantDescriptor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant.SaveParticipantRegistry;
import org.eclipse.wst.jsdt.internal.ui.preferences.IPreferenceAndPropertyConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PropertyAndPreferencePage;

class SaveParticipantConfigurationBlock
implements IPreferenceAndPropertyConfigurationBlock {
    private final PreferencePage fPreferencePage;
    private final IScopeContext fContext;
    private final ArrayList fConfigurations;

    public SaveParticipantConfigurationBlock(IScopeContext context, PreferencePage preferencePage) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)preferencePage);
        this.fContext = context;
        this.fPreferencePage = preferencePage;
        this.fConfigurations = new ArrayList();
    }

    @Override
    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        SaveParticipantRegistry registry = JavaScriptPlugin.getDefault().getSaveParticipantRegistry();
        SaveParticipantDescriptor[] descriptors = registry.getSaveParticipantDescriptors();
        if (descriptors.length == 0) {
            return composite;
        }
        Arrays.sort(descriptors, new Comparator(){

            public int compare(Object o1, Object o2) {
                SaveParticipantDescriptor d1 = (SaveParticipantDescriptor)o1;
                SaveParticipantDescriptor d2 = (SaveParticipantDescriptor)o2;
                return Collator.getInstance().compare(d1.getPostSaveListener().getName(), d2.getPostSaveListener().getName());
            }
        });
        IPreferencePageContainer container = this.fPreferencePage.getContainer();
        int i = 0;
        while (i < descriptors.length) {
            SaveParticipantDescriptor descriptor = descriptors[i];
            ISaveParticipantPreferenceConfiguration configuration = descriptor.createPreferenceConfiguration();
            configuration.createControl(composite, container);
            this.fConfigurations.add(configuration);
            ++i;
        }
        return composite;
    }

    @Override
    public void dispose() {
        this.delegateToPreferenceConfiguration(new IDelegateOperation(){

            @Override
            public void run(ISaveParticipantPreferenceConfiguration block) {
                block.dispose();
            }
        });
    }

    @Override
    public void initialize() {
        this.delegateToPreferenceConfiguration(new IDelegateOperation(){

            @Override
            public void run(ISaveParticipantPreferenceConfiguration block) {
                IAdaptable element = null;
                if (SaveParticipantConfigurationBlock.this.fPreferencePage instanceof PropertyAndPreferencePage) {
                    element = ((PropertyAndPreferencePage)SaveParticipantConfigurationBlock.this.fPreferencePage).getElement();
                }
                block.initialize(SaveParticipantConfigurationBlock.this.fContext, element);
            }
        });
    }

    @Override
    public void performDefaults() {
        this.delegateToPreferenceConfiguration(new IDelegateOperation(){

            @Override
            public void run(ISaveParticipantPreferenceConfiguration block) {
                block.performDefaults();
            }
        });
    }

    @Override
    public void performOk() {
        this.delegateToPreferenceConfiguration(new IDelegateOperation(){

            @Override
            public void run(ISaveParticipantPreferenceConfiguration block) {
                block.performOk();
            }
        });
    }

    @Override
    public void enableProjectSettings() {
        this.delegateToPreferenceConfiguration(new IDelegateOperation(){

            @Override
            public void run(ISaveParticipantPreferenceConfiguration block) {
                block.enableProjectSettings();
            }
        });
    }

    @Override
    public void disableProjectSettings() {
        this.delegateToPreferenceConfiguration(new IDelegateOperation(){

            @Override
            public void run(ISaveParticipantPreferenceConfiguration block) {
                block.disableProjectSettings();
            }
        });
    }

    private void delegateToPreferenceConfiguration(IDelegateOperation op) {
        int i = 0;
        while (i < this.fConfigurations.size()) {
            ISaveParticipantPreferenceConfiguration block = (ISaveParticipantPreferenceConfiguration)this.fConfigurations.get(i);
            op.run(block);
            ++i;
        }
    }

    private static interface IDelegateOperation {
        public void run(ISaveParticipantPreferenceConfiguration var1);
    }
}

