/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class AddToClasspathAction
extends SelectionDispatchAction {
    public AddToClasspathAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.AddToClasspathAction_label);
        this.setToolTipText(ActionMessages.AddToClasspathAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.addjtoclasspath_action_context");
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(AddToClasspathAction.checkEnabled(selection));
        }
        catch (JavaScriptModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaScriptPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private static boolean checkEnabled(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (AddToClasspathAction.canBeAddedToBuildPath(iter.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean canBeAddedToBuildPath(Object element) throws JavaScriptModelException {
        return element instanceof IAdaptable && AddToClasspathAction.getCandidate((IAdaptable)element) != null;
    }

    private static IFile getCandidate(IAdaptable element) throws JavaScriptModelException {
        IResource resource = (IResource)element.getAdapter(IResource.class);
        if (!(resource instanceof IFile) || !ArchiveFileFilter.isArchivePath(resource.getFullPath())) {
            return null;
        }
        IJavaScriptProject project = JavaScriptCore.create((IProject)resource.getProject());
        if (project != null && project.exists() && project.findPackageFragmentRoot(resource.getFullPath()) == null) {
            return (IFile)resource;
        }
        return null;
    }

    @Override
    public void run(IStructuredSelection selection) {
        try {
            final IFile[] files = AddToClasspathAction.getJARFiles(selection);
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    monitor.beginTask(ActionMessages.AddToClasspathAction_progressMessage, files.length);
                    int i = 0;
                    while (i < files.length) {
                        monitor.subTask(files[i].getFullPath().toString());
                        IJavaScriptProject project = JavaScriptCore.create((IProject)files[i].getProject());
                        this.addToClassPath(project, files[i].getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++i;
                    }
                }

                private void addToClassPath(IJavaScriptProject project, IPath jarPath, IProgressMonitor monitor) throws JavaScriptModelException {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IIncludePathEntry[] entries = project.getRawIncludepath();
                    IIncludePathEntry[] newEntries = new IIncludePathEntry[entries.length + 1];
                    System.arraycopy(entries, 0, newEntries, 0, entries.length);
                    newEntries[entries.length] = JavaScriptCore.newLibraryEntry((IPath)jarPath, null, null, (boolean)false);
                    project.setRawIncludepath(newEntries, monitor);
                }
            };
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.AddToClasspathAction_error_title, ActionMessages.AddToClasspathAction_error_message);
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), ActionMessages.AddToClasspathAction_error_title, ActionMessages.AddToClasspathAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static IFile[] getJARFiles(IStructuredSelection selection) throws JavaScriptModelException {
        ArrayList<IFile> list = new ArrayList<IFile>();
        for (Object element : selection) {
            IFile file;
            if (!(element instanceof IAdaptable) || (file = AddToClasspathAction.getCandidate((IAdaptable)element)) == null) continue;
            list.add(file);
        }
        return list.toArray(new IFile[list.size()]);
    }
}

