/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class FileUtils {
    public static void copyFile(String src, String dest) {
        FileInputStream is = null;
        FileOutputStream fos = null;
        try {
            try {
                is = new FileInputStream(src);
                fos = new FileOutputStream(dest);
                int c = 0;
                byte[] array = new byte[1024];
                while ((c = ((InputStream)is).read(array)) >= 0) {
                    fos.write(array, 0, c);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    fos.close();
                    ((InputStream)is).close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                fos.close();
                ((InputStream)is).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static File createFileAndParentDirectories(String fileName) throws Exception {
        File file = new File(fileName);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        file.createNewFile();
        return file;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static void deleteDirectories(File dir) {
        File[] children = dir.listFiles();
        int i = 0;
        while (i < children.length) {
            if (children[i].list() != null && children[i].list().length > 0) {
                FileUtils.deleteDirectories(children[i]);
            } else {
                children[i].delete();
            }
            ++i;
        }
        dir.delete();
    }

    public static void deleteDirectories(String dir) {
        File directory = new File(dir);
        FileUtils.deleteDirectories(directory);
    }

    public static void createTargetFile(String sourceFileName, String targetFileName) throws Exception {
        FileUtils.createTargetFile(sourceFileName, targetFileName, false);
    }

    public static void createTargetFile(String sourceFileName, String targetFileName, boolean overwrite) throws Exception {
        File idealResultFile = new File(targetFileName);
        if (overwrite || !idealResultFile.exists()) {
            FileUtils.createFileAndParentDirectories(targetFileName);
            FileUtils.copyFile(sourceFileName, targetFileName);
        }
    }

    public static boolean createDirectory(String directory) {
        boolean success = new File(directory).mkdir();
        return success;
    }

    public static boolean createDirectorys(String directory) {
        boolean success = new File(directory).mkdirs();
        return success;
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            int i = 0;
            while (i < children.length) {
                FileUtils.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
                ++i;
            }
        } else {
            FileUtils.copy(srcDir, dstDir);
        }
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static String addAnotherNodeToPath(String currentPath, String newNode) {
        return String.valueOf(currentPath) + File.separator + newNode;
    }

    public static String addNodesToPath(String currentPath, String[] newNode) {
        String returnPath = currentPath;
        int i = 0;
        while (i < newNode.length) {
            returnPath = String.valueOf(returnPath) + File.separator + newNode[i];
            ++i;
        }
        return returnPath;
    }

    public static String addNodesToPath(StringBuffer currentPath, String[] pathNodes) {
        int i = 0;
        while (i < pathNodes.length) {
            currentPath.append(File.separator);
            currentPath.append(pathNodes[i]);
            ++i;
        }
        return currentPath.toString();
    }

    public static String addNodesToURL(String currentPath, String[] newNode) {
        String returnPath = currentPath;
        int i = 0;
        while (i < newNode.length) {
            returnPath = String.valueOf(returnPath) + "/" + newNode[i];
            ++i;
        }
        return returnPath;
    }

    public static File[] getMatchingFiles(String sourceDir, String fileNamePrefix, String extension) {
        ArrayList<File> fileList = new ArrayList<File>();
        File libDir = new File(sourceDir);
        String libDirPath = libDir.getAbsolutePath();
        String[] items = libDir.list();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                String item = items[i];
                if (fileNamePrefix != null && extension != null) {
                    if (item.startsWith(fileNamePrefix) && item.endsWith(extension)) {
                        fileList.add(new File(String.valueOf(libDirPath) + File.separator + item));
                    }
                } else if (fileNamePrefix == null && extension != null) {
                    if (item.endsWith(extension)) {
                        fileList.add(new File(String.valueOf(libDirPath) + File.separator + item));
                    }
                } else if (fileNamePrefix != null && extension == null) {
                    if (item.startsWith(fileNamePrefix)) {
                        fileList.add(new File(String.valueOf(libDirPath) + File.separator + item));
                    }
                } else {
                    fileList.add(new File(String.valueOf(libDirPath) + File.separator + item));
                }
                ++i;
            }
            return fileList.toArray(new File[fileList.size()]);
        }
        return new File[0];
    }

    public static void filterOutRestrictedFiles(String sourceDir, String fileNamePrefix, String extension) {
        File[] resultedMatchingFiles = FileUtils.getMatchingFiles(sourceDir, fileNamePrefix, extension);
        int i = 0;
        while (i < resultedMatchingFiles.length) {
            File matchingFilePath = new File(resultedMatchingFiles[i].getAbsolutePath());
            matchingFilePath.delete();
            ++i;
        }
    }
}

