/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.reference;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.predicate.int_.IntPredicateTools;
import org.eclipse.jpt.common.utility.internal.reference.SimpleIntReference;
import org.eclipse.jpt.common.utility.reference.IntReference;

public abstract class IntReferenceTests
extends TestCase {
    public IntReferenceTests(String name) {
        super(name);
    }

    protected IntReference buildIntReference() {
        return this.buildIntReference(0);
    }

    protected abstract IntReference buildIntReference(int var1);

    public void testGetValue() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertEquals((int)42, (int)ref.getValue());
    }

    public void testEqualsInt() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertTrue((boolean)ref.equals(42));
        IntReferenceTests.assertFalse((boolean)ref.equals(0));
    }

    public void testNotEqualInt() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertFalse((boolean)ref.notEqual(42));
        IntReferenceTests.assertTrue((boolean)ref.notEqual(0));
    }

    public void testIsZero() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertFalse((boolean)ref.isZero());
        ref = this.buildIntReference(0);
        IntReferenceTests.assertTrue((boolean)ref.isZero());
    }

    public void testIsNotZero() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertTrue((boolean)ref.isNotZero());
        ref = this.buildIntReference(0);
        IntReferenceTests.assertFalse((boolean)ref.isNotZero());
    }

    public void testIsGreaterThan() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertTrue((boolean)ref.isGreaterThan(22));
        IntReferenceTests.assertFalse((boolean)ref.isGreaterThan(2222));
    }

    public void testIsGreaterThanOrEqual() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertTrue((boolean)ref.isGreaterThanOrEqual(22));
        IntReferenceTests.assertTrue((boolean)ref.isGreaterThanOrEqual(42));
        IntReferenceTests.assertFalse((boolean)ref.isGreaterThanOrEqual(2222));
    }

    public void testIsLessThan() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertTrue((boolean)ref.isLessThan(2222));
        IntReferenceTests.assertFalse((boolean)ref.isLessThan(22));
    }

    public void testIsLessThanOrEqual() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertTrue((boolean)ref.isLessThanOrEqual(2222));
        IntReferenceTests.assertTrue((boolean)ref.isLessThanOrEqual(42));
        IntReferenceTests.assertFalse((boolean)ref.isLessThanOrEqual(22));
    }

    public void testIsPositive() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertTrue((boolean)ref.isPositive());
        ref = this.buildIntReference(0);
        IntReferenceTests.assertFalse((boolean)ref.isPositive());
        ref = this.buildIntReference(-42);
        IntReferenceTests.assertFalse((boolean)ref.isPositive());
    }

    public void testIsNotPositive() {
        IntReference ref = this.buildIntReference(-42);
        IntReferenceTests.assertTrue((boolean)ref.isNotPositive());
        ref = this.buildIntReference(0);
        IntReferenceTests.assertTrue((boolean)ref.isNotPositive());
        ref = this.buildIntReference(42);
        IntReferenceTests.assertFalse((boolean)ref.isNotPositive());
    }

    public void testIsNegative() {
        IntReference ref = this.buildIntReference(-42);
        IntReferenceTests.assertTrue((boolean)ref.isNegative());
        ref = this.buildIntReference(0);
        IntReferenceTests.assertFalse((boolean)ref.isNegative());
        ref = this.buildIntReference(42);
        IntReferenceTests.assertFalse((boolean)ref.isNegative());
    }

    public void testIsNotNegative() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertTrue((boolean)ref.isNotNegative());
        ref = this.buildIntReference(0);
        IntReferenceTests.assertTrue((boolean)ref.isNotNegative());
        ref = this.buildIntReference(-42);
        IntReferenceTests.assertFalse((boolean)ref.isNotNegative());
    }

    public void testIsMemberOf() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertTrue((boolean)ref.isMemberOf(IntPredicateTools.isEven()));
        IntReferenceTests.assertFalse((boolean)ref.isMemberOf(IntPredicateTools.isOdd()));
    }

    public void testIsNotMemberOf() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertFalse((boolean)ref.isNotMemberOf(IntPredicateTools.isEven()));
        IntReferenceTests.assertTrue((boolean)ref.isNotMemberOf(IntPredicateTools.isOdd()));
    }

    public void testCompareToIntReference() {
        SimpleIntReference ref2;
        IntReference ref1 = this.buildIntReference(44);
        IntReferenceTests.assertTrue((ref1.compareTo((Object)(ref2 = new SimpleIntReference(44))) == 0 ? 1 : 0) != 0);
        ref2 = new SimpleIntReference(55);
        IntReferenceTests.assertTrue((ref1.compareTo((Object)ref2) < 0 ? 1 : 0) != 0);
        ref2 = new SimpleIntReference(33);
        IntReferenceTests.assertTrue((ref1.compareTo((Object)ref2) > 0 ? 1 : 0) != 0);
    }

    public void testEquals() {
        IntReference ref1 = this.buildIntReference(42);
        IntReference ref2 = this.buildIntReference(42);
        IntReferenceTests.assertTrue((boolean)ref1.equals(ref1));
        IntReferenceTests.assertFalse((boolean)ref1.equals(ref2));
    }

    public void testHashCode() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertEquals((int)ref.hashCode(), (int)ref.hashCode());
    }

    public void testToString() {
        IntReference ref = this.buildIntReference(42);
        IntReferenceTests.assertEquals((String)"[42]", (String)ref.toString());
    }
}

