/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadPropertyValidatorTestCase
extends BaseReadTestCase {
    public ReadPropertyValidatorTestCase(String name) {
        super(name);
    }

    public void testProperty() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType property1 = this.getProperty1(edit.getFacesConfig());
            ReadPropertyValidatorTestCase.assertNotNull((Object)property1);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ValidatorType getValidator1(FacesConfigType facesConfigType) {
        return (ValidatorType)FacesConfigModelUtil.findEObjectElementById((List)facesConfigType.getValidator(), "validator1");
    }

    private PropertyType getProperty1(FacesConfigType facesConfigType) {
        ValidatorType validator1 = this.getValidator1(facesConfigType);
        ReadPropertyValidatorTestCase.assertNotNull((Object)validator1);
        return (PropertyType)FacesConfigModelUtil.findEObjectElementById((List)validator1.getProperty(), "validator1_property");
    }

    public void testDescription() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyValidatorTestCase.assertNotNull((Object)propertyType);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)propertyType.getDescription(), "validator1_property_description");
            ReadPropertyValidatorTestCase.assertEquals((String)"validator-property-description", (String)descType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDisplayName() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyValidatorTestCase.assertNotNull((Object)propertyType);
            DisplayNameType displayNameType = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)propertyType.getDisplayName(), "validator1_property_displayName");
            ReadPropertyValidatorTestCase.assertEquals((String)"validator-property-display-name", (String)displayNameType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testIcon() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyValidatorTestCase.assertNotNull((Object)propertyType);
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)propertyType.getIcon(), "validator1_property_icon");
            ReadPropertyValidatorTestCase.assertNotNull((Object)iconType);
            ReadPropertyValidatorTestCase.assertEquals((String)"validator-property-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadPropertyValidatorTestCase.assertEquals((String)"validator-property-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testPropertyNameAndClass() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType property1 = this.getProperty1(edit.getFacesConfig());
            ReadPropertyValidatorTestCase.assertNotNull((Object)property1);
            ReadPropertyValidatorTestCase.assertEquals((String)"validator-property-name", (String)property1.getPropertyName().getTextContent());
            ReadPropertyValidatorTestCase.assertEquals((String)"validator-property-class", (String)property1.getPropertyClass().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testSuggestedValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyValidatorTestCase.assertNotNull((Object)propertyType);
            ReadPropertyValidatorTestCase.assertEquals((String)"validator property suggested value", (String)propertyType.getSuggestedValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDefaultValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyValidatorTestCase.assertNotNull((Object)propertyType);
            ReadPropertyValidatorTestCase.assertEquals((String)"validator property default value", (String)propertyType.getDefaultValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

