/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.ui.internal.validation.DelegatingSourceValidatorForXML;
import org.eclipse.wst.xml.ui.tests.ProjectUtil;
import org.eclipse.wst.xml.ui.tests.XMLUITestsPlugin;
import org.osgi.framework.Bundle;

public class TestDelegatingSourceValidatorForXML
extends TestCase {
    DelegatingSourceValidatorForXML sourceValidator = new DelegatingSourceValidatorForXML();

    public void testNon8BitChars() {
        IFile file;
        String projName = "Project";
        String fileName1 = "international-instance.xml";
        String fileName2 = "international.xsd";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        if (!project.isAccessible()) {
            IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projName);
            try {
                project.create(description, (IProgressMonitor)new NullProgressMonitor());
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if ((file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(projName) + "/" + fileName1))) != null && !file.exists()) {
            try {
                file.create(FileLocator.openStream((Bundle)XMLUITestsPlugin.getDefault().getBundle(), (IPath)new Path("/testresources/Non8BitChars/international-instance.xml"), (boolean)false), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(projName) + "/" + fileName2))) != null && !file.exists()) {
            try {
                file.create(FileLocator.openStream((Bundle)XMLUITestsPlugin.getDefault().getBundle(), (IPath)new Path("/testresources/Non8BitChars/international.xsd"), (boolean)false), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        WorkbenchContext context = new WorkbenchContext();
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add("/" + projName + "/" + fileName1);
        context.setValidationFileURIs(fileList);
        TestReporter reporter = new TestReporter();
        try {
            this.sourceValidator.validate((IValidationContext)context, (IReporter)reporter);
        }
        catch (ValidationException e) {
            e.printStackTrace();
        }
        TestDelegatingSourceValidatorForXML.assertFalse((String)"Messages were reported on valid file 1.", (boolean)reporter.isMessageReported());
        WorkbenchContext context2 = new WorkbenchContext();
        ArrayList<String> fileList2 = new ArrayList<String>();
        fileList2.add("/" + projName + "/" + fileName2);
        context2.setValidationFileURIs(fileList2);
        TestReporter reporter2 = new TestReporter();
        try {
            this.sourceValidator.validate((IValidationContext)context2, (IReporter)reporter2);
        }
        catch (ValidationException e) {
            e.printStackTrace();
        }
        TestDelegatingSourceValidatorForXML.assertFalse((String)"Messages were reported on valid file 2.", (boolean)reporter2.isMessageReported());
    }

    public void testRemoveAndAddBackCommentEndTag() throws Exception {
        IProject project;
        block8: {
            String projectName = "RemoveAndAddBackCommentEndTag";
            project = ProjectUtil.createProject(projectName, XMLUITestsPlugin.getDefault().getStateLocation().append(this.getName()), null);
            IFile testFile = null;
            IStructuredModel model = null;
            try {
                try {
                    ProjectUtil.copyBundleEntriesIntoWorkspace("testresources/RemoveAndAddBackCommentEndTag", projectName);
                    testFile = project.getFile("Test1.xml");
                    TestDelegatingSourceValidatorForXML.assertTrue((String)("Test file " + testFile + " does not exist"), (boolean)testFile.exists());
                    model = StructuredModelManager.getModelManager().getModelForEdit(testFile);
                    IStructuredDocument document = model.getStructuredDocument();
                    WorkbenchContext context = new WorkbenchContext();
                    ArrayList<String> fileList = new ArrayList<String>();
                    fileList.add(testFile.getFullPath().toPortableString());
                    context.setValidationFileURIs(fileList);
                    TestReporter reporter = new TestReporter();
                    this.sourceValidator.validate((IValidationContext)context, (IReporter)reporter);
                    TestDelegatingSourceValidatorForXML.assertFalse((String)("There should be no validation errors on " + testFile), (boolean)reporter.isMessageReported());
                    String contents = document.get();
                    int endCommentIndex = contents.indexOf("-->");
                    document.replace(endCommentIndex, 3, "");
                    reporter = new TestReporter();
                    this.sourceValidator.validate((IValidationContext)context, (IReporter)reporter);
                    TestDelegatingSourceValidatorForXML.assertTrue((String)("There should be validation errors on " + testFile), (boolean)reporter.isMessageReported());
                    document.replace(endCommentIndex, 0, "-->");
                    reporter = new TestReporter();
                    this.sourceValidator.validate((IValidationContext)context, (IReporter)reporter);
                    TestDelegatingSourceValidatorForXML.assertFalse((String)("There should be no validation errors on " + testFile), (boolean)reporter.isMessageReported());
                }
                catch (ValidationException e) {
                    TestDelegatingSourceValidatorForXML.fail((String)("Could not validate test file " + testFile + ": " + e.getMessage()));
                    if (model != null) {
                        model.releaseFromEdit();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (model != null) {
                    model.releaseFromEdit();
                }
                throw throwable;
            }
            if (model != null) {
                model.releaseFromEdit();
            }
        }
        project.delete(true, null);
    }

    public void testValidateAgainstDTD() throws Exception {
        String projectName = "TestValidateAgainstDTD";
        IProject project = ProjectUtil.createProject(projectName, XMLUITestsPlugin.getDefault().getStateLocation().append(this.getName()), null);
        IFile testFile = null;
        try {
            ProjectUtil.copyBundleEntriesIntoWorkspace("testresources/TestValidateAgainstDTD", projectName);
            testFile = project.getFile("simple.xml");
            TestDelegatingSourceValidatorForXML.assertTrue((String)("Test file " + testFile + " does not exist"), (boolean)testFile.exists());
            WorkbenchContext context = new WorkbenchContext();
            ArrayList<String> fileList = new ArrayList<String>();
            fileList.add(testFile.getFullPath().toPortableString());
            context.setValidationFileURIs(fileList);
            TestReporter reporter = new TestReporter();
            this.sourceValidator.validate((IValidationContext)context, (IReporter)reporter);
            TestDelegatingSourceValidatorForXML.assertFalse((String)("There should be an error message reported for not conforming to the DTD " + testFile), (!reporter.isMessageReported() ? 1 : 0) != 0);
        }
        catch (ValidationException e) {
            TestDelegatingSourceValidatorForXML.fail((String)("Could not validate test file " + testFile + ": " + e.getMessage()));
        }
        project.delete(true, null);
    }

    private class TestReporter
    implements IReporter {
        private boolean messageReported = false;

        public void addMessage(IValidator origin, IMessage message) {
            this.messageReported = true;
        }

        public boolean isMessageReported() {
            return this.messageReported;
        }

        public void displaySubtask(IValidator validator, IMessage message) {
        }

        public List getMessages() {
            return null;
        }

        public boolean isCancelled() {
            return false;
        }

        public void removeAllMessages(IValidator origin, Object object) {
        }

        public void removeAllMessages(IValidator origin) {
        }

        public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        }
    }
}

