/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterable;

import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.CompositeListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class CompositeListIterable<E>
implements ListIterable<E> {
    private final ListIterable<? extends ListIterable<E>> iterables;

    public CompositeListIterable(ListIterable<? extends ListIterable<E>> iterables) {
        if (iterables == null) {
            throw new NullPointerException();
        }
        this.iterables = iterables;
    }

    @Override
    public ListIterator<E> iterator() {
        return new CompositeListIterator<E>(this.iterators());
    }

    protected ListIterator<? extends ListIterator<E>> iterators() {
        Transformer transformer = IterableTools.listIteratorTransformer();
        return IteratorTools.transform(this.iterables(), transformer);
    }

    protected ListIterator<? extends ListIterable<E>> iterables() {
        return this.iterables.iterator();
    }

    public String toString() {
        return ListTools.arrayList(this).toString();
    }
}

